/*
 * Decompiled with CFR 0.152.
 */
package org.calrissian.accumulorecipes.graphstore.tinkerpop.model;

import com.google.common.base.Preconditions;
import com.tinkerpop.blueprints.Element;
import java.util.Set;
import org.calrissian.accumulorecipes.commons.domain.Auths;
import org.calrissian.accumulorecipes.graphstore.GraphStore;
import org.calrissian.mango.domain.Tuple;
import org.calrissian.mango.domain.entity.Entity;
import org.calrissian.mango.domain.entity.EntityIndex;

public class EntityElement
implements Element {
    protected Entity entity;
    protected GraphStore graphStore;
    protected Auths auths;

    public EntityElement(Entity entity, GraphStore graphStore, Auths auths) {
        Preconditions.checkNotNull((Object)entity);
        Preconditions.checkNotNull((Object)graphStore);
        this.entity = entity;
        this.graphStore = graphStore;
        this.auths = auths;
    }

    public Entity getEntity() {
        return this.entity;
    }

    public GraphStore getGraphStore() {
        return this.graphStore;
    }

    public <T> T getProperty(String s) {
        Preconditions.checkNotNull((Object)s);
        if (s.equals("type")) {
            return (T)this.entity.getType();
        }
        if (this.entity.get(s) == null) {
            return null;
        }
        return (T)this.entity.get(s).getValue();
    }

    public Set<String> getPropertyKeys() {
        return this.entity.keys();
    }

    public void setProperty(String s, Object o) {
        Preconditions.checkNotNull((Object)s);
        Preconditions.checkNotNull((Object)o);
        this.entity.put(new Tuple(s, o));
    }

    public <T> T removeProperty(String s) {
        Preconditions.checkNotNull((Object)s);
        return (T)this.entity.remove(s).getValue();
    }

    public void remove() {
    }

    public Object getId() {
        return new EntityIndex(this.entity.getType(), this.entity.getId());
    }
}

