/*
 * Decompiled with CFR 0.152.
 */
package org.calrissian.accumulorecipes.graphstore.tinkerpop.model;

import com.tinkerpop.blueprints.Direction;
import com.tinkerpop.blueprints.Edge;
import com.tinkerpop.blueprints.Vertex;
import java.util.Collections;
import java.util.Iterator;
import org.calrissian.accumulorecipes.commons.domain.Auths;
import org.calrissian.accumulorecipes.graphstore.GraphStore;
import org.calrissian.accumulorecipes.graphstore.model.EdgeEntity;
import org.calrissian.accumulorecipes.graphstore.tinkerpop.model.EntityElement;
import org.calrissian.accumulorecipes.graphstore.tinkerpop.model.EntityVertex;
import org.calrissian.mango.collect.CloseableIterable;
import org.calrissian.mango.domain.entity.Entity;
import org.calrissian.mango.domain.entity.EntityIndex;
import org.calrissian.mango.domain.entity.EntityRelationship;

public class EntityEdge
extends EntityElement
implements Edge {
    public EntityEdge(Entity entity, GraphStore graphStore, Auths auths) {
        super((Entity)new EdgeEntity(entity), graphStore, auths);
    }

    public Vertex getVertex(Direction direction) throws IllegalArgumentException {
        EntityRelationship rel;
        EdgeEntity edgeEntity = (EdgeEntity)this.entity;
        if (direction == Direction.IN) {
            rel = edgeEntity.getHead();
        } else if (direction == Direction.OUT) {
            rel = edgeEntity.getTail();
        } else {
            throw new RuntimeException("Direction.BOTH cannot be used when retrieving a vertex from an edge.");
        }
        CloseableIterable entities = this.graphStore.get(Collections.singletonList(new EntityIndex(rel.getType(), rel.getId())), null, this.auths);
        Iterator entityItr = entities.iterator();
        Entity vertexEntity = null;
        if (entityItr.hasNext()) {
            vertexEntity = (Entity)entityItr.next();
        }
        entities.closeQuietly();
        if (vertexEntity != null) {
            return new EntityVertex(vertexEntity, this.graphStore, this.auths);
        }
        return null;
    }

    public String getLabel() {
        return ((EdgeEntity)this.entity).getLabel();
    }
}

