/*
 * Decompiled with CFR 0.152.
 */
package org.caffinitas.ohc.jmh;

import java.io.IOException;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import org.caffinitas.ohc.Eviction;
import org.caffinitas.ohc.HashAlgorithm;
import org.caffinitas.ohc.OHCache;
import org.caffinitas.ohc.OHCacheBuilder;
import org.caffinitas.ohc.jmh.Utils;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.BenchmarkMode;
import org.openjdk.jmh.annotations.Fork;
import org.openjdk.jmh.annotations.Measurement;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.annotations.OutputTimeUnit;
import org.openjdk.jmh.annotations.Param;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.annotations.TearDown;
import org.openjdk.jmh.annotations.Threads;
import org.openjdk.jmh.annotations.Warmup;

@BenchmarkMode(value={Mode.Throughput})
@State(value=Scope.Benchmark)
@Warmup(iterations=2)
@Measurement(iterations=3, time=5)
@Threads(value=4)
@OutputTimeUnit(value=TimeUnit.MICROSECONDS)
@Fork(value=1, jvmArgsAppend={"-Xmx512M"})
public class OHCBenchmark {
    private OHCache<Integer, byte[]> cache;
    @Param(value={"256"})
    private int valueSz = 256;
    @Param(value={"1073741824"})
    private long capacity = 0x40000000L;
    @Param(value={"-1"})
    private int segCnt = -1;
    @Param(value={"-1"})
    private int hashTableSz = -1;
    @Param(value={"10000000"})
    private int keys = 10000000;
    @Param(value={"MURMUR3", "CRC32", "CRC32C", "XX"})
    private HashAlgorithm hashAlg = HashAlgorithm.MURMUR3;
    @Param(value={"-1", "65536"})
    private int chunkSz = -1;
    @Param(value={"-1"})
    private int fixedKeyLen = -1;
    @Param(value={"-1"})
    private int fixedValLen = -1;
    @Param(value={"LRU", "W_TINY_LFU"})
    private Eviction eviction = Eviction.LRU;
    private byte[] value;

    @Setup
    public void setup() throws ClassNotFoundException {
        this.cache = OHCacheBuilder.newBuilder().capacity(this.capacity).segmentCount(this.segCnt).hashTableSize(this.hashTableSz).keySerializer(Utils.intSerializer).valueSerializer(Utils.byteArraySerializer).chunkSize(this.chunkSz).fixedEntrySize(this.fixedKeyLen, this.fixedValLen).hashMode(this.hashAlg).eviction(this.eviction).build();
        this.value = new byte[this.valueSz];
        for (int i = 0; i < this.keys; ++i) {
            this.cache.put((Object)i, (Object)this.value);
        }
    }

    @TearDown
    public void tearDown() throws IOException {
        this.cache.close();
    }

    @Benchmark
    @Threads(value=4)
    public void getNonExisting() {
        this.cache.get((Object)0);
    }

    @Benchmark
    @Threads(value=4)
    public void containsNonExisting() {
        this.cache.containsKey((Object)0);
    }

    @Benchmark
    @Threads(value=1)
    public void putSingleThreaded(PutState state) {
        this.cache.put((Object)state.key++, (Object)this.value);
        if (state.key > this.keys) {
            state.key = 1;
        }
    }

    @Benchmark
    @Threads(value=4)
    public void putMultiThreaded(PutState state) {
        this.cache.put((Object)state.key++, (Object)this.value);
        if (state.key > this.keys) {
            state.key = 1;
        }
    }

    @Benchmark
    @Threads(value=1)
    public void getSingleThreaded(GetState state) {
        this.cache.get((Object)state.key++);
        if (state.key > this.keys) {
            state.key = 1;
        }
    }

    @Benchmark
    @Threads(value=4)
    public void getMultiThreaded(GetState state) {
        this.cache.get((Object)state.key++);
        ++state.run;
        if (state.run < 4 && state.key > this.keys / 5) {
            state.key = 1;
        }
        state.run = 0;
        if (state.key > this.keys) {
            state.key = 1;
        }
    }

    @State(value=Scope.Thread)
    public static class GetState {
        public int key = ThreadLocalRandom.current().nextInt(1000);
        public int run;
    }

    @State(value=Scope.Thread)
    public static class PutState {
        public int key = ThreadLocalRandom.current().nextInt(1000);
    }
}

