/*
 * Decompiled with CFR 0.152.
 */
package org.caffinitas.ohc.linked;

import com.google.common.collect.AbstractIterator;
import com.google.common.primitives.Ints;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.SettableFuture;
import java.io.EOFException;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.SeekableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.util.Arrays;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.caffinitas.ohc.CacheLoader;
import org.caffinitas.ohc.CacheSerializer;
import org.caffinitas.ohc.CloseableIterator;
import org.caffinitas.ohc.DirectValueAccess;
import org.caffinitas.ohc.OHCache;
import org.caffinitas.ohc.OHCacheBuilder;
import org.caffinitas.ohc.OHCacheStats;
import org.caffinitas.ohc.PermanentLoadException;
import org.caffinitas.ohc.TemporaryLoadException;
import org.caffinitas.ohc.Ticker;
import org.caffinitas.ohc.histo.EstimatedHistogram;
import org.caffinitas.ohc.linked.DirectValueAccessImpl;
import org.caffinitas.ohc.linked.HashEntries;
import org.caffinitas.ohc.linked.Hasher;
import org.caffinitas.ohc.linked.KeyBuffer;
import org.caffinitas.ohc.linked.LongArrayList;
import org.caffinitas.ohc.linked.OffHeapLinkedLRUMap;
import org.caffinitas.ohc.linked.OffHeapLinkedMap;
import org.caffinitas.ohc.linked.OffHeapLinkedPermMap;
import org.caffinitas.ohc.linked.OffHeapLinkedWTinyLFUMap;
import org.caffinitas.ohc.linked.Uns;
import org.caffinitas.ohc.linked.Util;
import org.caffinitas.ohc.util.ByteBufferCompat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class OHCacheLinkedImpl<K, V>
implements OHCache<K, V> {
    private static final Logger LOGGER = LoggerFactory.getLogger(OHCacheLinkedImpl.class);
    private static final int CURRENT_FILE_VERSION = 2;
    private final CacheSerializer<K> keySerializer;
    private final CacheSerializer<V> valueSerializer;
    private final OffHeapLinkedMap[] maps;
    private final long segmentMask;
    private final int segmentShift;
    private final long maxEntrySize;
    private final long defaultTTL;
    private long capacity;
    private volatile long putFailCount;
    private boolean closed;
    private final ScheduledExecutorService executorService;
    private final boolean throwOOME;
    private final Hasher hasher;
    private final Ticker ticker;

    public OHCacheLinkedImpl(OHCacheBuilder<K, V> builder) {
        long capacity = builder.getCapacity();
        if (capacity <= 0L) {
            throw new IllegalArgumentException("capacity:" + capacity);
        }
        this.capacity = capacity;
        this.ticker = builder.getTicker();
        this.defaultTTL = builder.getDefaultTTLmillis();
        this.throwOOME = builder.isThrowOOME();
        this.hasher = Hasher.create(builder.getHashAlgorighm());
        int segments = builder.getSegmentCount();
        if (segments <= 0) {
            segments = Runtime.getRuntime().availableProcessors() * 2;
        }
        segments = Ints.checkedCast((long)Util.roundUpToPowerOf2(segments, 0x40000000L));
        this.maps = new OffHeapLinkedMap[segments];
        for (int i = 0; i < segments; ++i) {
            try {
                this.maps[i] = this.makeMap(builder, capacity / (long)segments);
                continue;
            }
            catch (RuntimeException e) {
                while (i >= 0) {
                    if (this.maps[i] != null) {
                        this.maps[i].release();
                    }
                    --i;
                }
                throw e;
            }
        }
        int bitNum = Util.bitNum(segments) - 1;
        this.segmentShift = 64 - bitNum;
        this.segmentMask = (long)segments - 1L << this.segmentShift;
        long maxEntrySize = builder.getMaxEntrySize();
        if (maxEntrySize > capacity / (long)segments) {
            throw new IllegalArgumentException("Illegal max entry size " + maxEntrySize);
        }
        if (maxEntrySize <= 0L) {
            maxEntrySize = capacity / (long)segments;
        }
        this.maxEntrySize = maxEntrySize;
        this.keySerializer = builder.getKeySerializer();
        if (this.keySerializer == null) {
            throw new NullPointerException("keySerializer == null");
        }
        this.valueSerializer = builder.getValueSerializer();
        if (this.valueSerializer == null) {
            throw new NullPointerException("valueSerializer == null");
        }
        this.executorService = builder.getExecutorService();
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("OHC linked instance with {} segments and capacity of {} created.", (Object)segments, (Object)capacity);
        }
    }

    private OffHeapLinkedMap makeMap(OHCacheBuilder<K, V> builder, long perMapCapacity) {
        switch (builder.getEviction()) {
            case LRU: {
                return new OffHeapLinkedLRUMap(builder, perMapCapacity);
            }
            case W_TINY_LFU: {
                return new OffHeapLinkedWTinyLFUMap(builder, perMapCapacity);
            }
            case NONE: {
                return new OffHeapLinkedPermMap(builder, perMapCapacity);
            }
        }
        throw new IllegalArgumentException("Unsupported eviction: " + (Object)((Object)builder.getEviction()));
    }

    @Override
    public DirectValueAccess getDirect(K key) {
        return this.getDirect(key, true);
    }

    @Override
    public DirectValueAccess getDirect(K key, boolean updateLRU) {
        if (key == null) {
            throw new NullPointerException();
        }
        KeyBuffer keySource = this.keySource(key);
        long hashEntryAdr = this.segment(keySource.hash()).getEntry(keySource, true, updateLRU);
        if (hashEntryAdr == 0L) {
            return null;
        }
        return new DirectValueAccessImpl(hashEntryAdr, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V get(K key) {
        if (key == null) {
            throw new NullPointerException();
        }
        long hashEntryAdr = 0L;
        KeyBuffer keySource = this.keySource(key);
        try {
            hashEntryAdr = this.segment(keySource.hash()).getEntry(keySource, true, true);
            if (hashEntryAdr == 0L) {
                V v = null;
                return v;
            }
            V v = this.valueSerializer.deserialize(Uns.valueBufferR(hashEntryAdr));
            return v;
        }
        finally {
            HashEntries.dereference(hashEntryAdr);
        }
    }

    @Override
    public boolean containsKey(K key) {
        if (key == null) {
            throw new NullPointerException();
        }
        KeyBuffer keySource = this.keySource(key);
        return this.segment(keySource.hash()).getEntry(keySource, false, true) != 0L;
    }

    @Override
    public boolean put(K k, V v) {
        return this.putInternal(k, v, false, null, this.defaultExpireAt());
    }

    @Override
    public boolean put(K k, V v, long expireAt) {
        return this.putInternal(k, v, false, null, expireAt);
    }

    @Override
    public boolean addOrReplace(K key, V old, V value) {
        return this.putInternal(key, value, false, old, this.defaultExpireAt());
    }

    @Override
    public boolean addOrReplace(K key, V old, V value, long expireAt) {
        return this.putInternal(key, value, false, old, expireAt);
    }

    @Override
    public boolean putIfAbsent(K k, V v) {
        return this.putInternal(k, v, true, null, this.defaultExpireAt());
    }

    @Override
    public boolean putIfAbsent(K k, V v, long expireAt) {
        return this.putInternal(k, v, true, null, expireAt);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean putInternal(K k, V v, boolean ifAbsent, V old, long expireAt) {
        if (k == null || v == null) {
            throw new NullPointerException();
        }
        int keyLen = this.keySize(k);
        int valueLen = this.valueSize(v);
        long bytes = Util.allocLen(keyLen, valueLen);
        long oldValueAdr = 0L;
        long oldValueLen = 0L;
        try {
            long hashEntryAdr;
            if (old != null) {
                oldValueLen = this.valueSize(old);
                oldValueAdr = Uns.allocate(oldValueLen, this.throwOOME);
                if (oldValueAdr == 0L) {
                    throw new RuntimeException("Unable to allocate " + oldValueLen + " bytes in off-heap");
                }
                this.valueSerializer.serialize(old, Uns.directBufferFor(oldValueAdr, 0L, oldValueLen, false));
            }
            if (this.maxEntrySize > 0L && bytes > this.maxEntrySize || (hashEntryAdr = Uns.allocate(bytes, this.throwOOME)) == 0L) {
                ++this.putFailCount;
                this.remove(k);
                boolean bl = false;
                return bl;
            }
            long hash = this.serializeForPut(k, v, keyLen, valueLen, hashEntryAdr);
            if (expireAt == -1L) {
                expireAt = this.defaultExpireAt();
            }
            HashEntries.init(hash, keyLen, valueLen, hashEntryAdr, 0, expireAt);
            if (this.segment(hash).putEntry(hashEntryAdr, hash, keyLen, bytes, ifAbsent, expireAt, oldValueAdr, oldValueLen)) {
                boolean bl = true;
                return bl;
            }
            Uns.free(hashEntryAdr);
            boolean bl = false;
            return bl;
        }
        finally {
            Uns.free(oldValueAdr);
        }
    }

    private int keySize(K k) {
        int sz = this.keySerializer.serializedSize(k);
        if (sz <= 0) {
            throw new IllegalArgumentException("Illegal key length " + sz);
        }
        return sz;
    }

    private int valueSize(V v) {
        int sz = this.valueSerializer.serializedSize(v);
        if (sz <= 0) {
            throw new IllegalArgumentException("Illegal value length " + sz);
        }
        return sz;
    }

    private long defaultExpireAt() {
        long ttl = this.defaultTTL;
        return ttl > 0L ? this.ticker.currentTimeMillis() + ttl : 0L;
    }

    private long serializeForPut(K k, V v, int keyLen, long valueLen, long hashEntryAdr) {
        try {
            this.keySerializer.serialize(k, Uns.keyBuffer(hashEntryAdr, keyLen));
            if (v != null) {
                this.valueSerializer.serialize(v, Uns.valueBuffer(hashEntryAdr, keyLen, valueLen));
            }
        }
        catch (Throwable e) {
            OHCacheLinkedImpl.freeAndThrow(e, hashEntryAdr);
        }
        return this.hasher.hash(hashEntryAdr, 64L, keyLen);
    }

    private static void freeAndThrow(Throwable e, long hashEntryAdr) {
        Uns.free(hashEntryAdr);
        if (e instanceof RuntimeException) {
            throw (RuntimeException)e;
        }
        if (e instanceof Error) {
            throw (Error)e;
        }
        throw new RuntimeException(e);
    }

    @Override
    public boolean remove(K k) {
        if (k == null) {
            throw new NullPointerException();
        }
        KeyBuffer keySource = this.keySource(k);
        return this.segment(keySource.hash()).removeEntry(keySource);
    }

    @Override
    public V getWithLoader(K key, CacheLoader<K, V> loader) throws InterruptedException, ExecutionException {
        return this.getWithLoaderAsync(key, loader).get();
    }

    @Override
    public V getWithLoader(K key, CacheLoader<K, V> loader, long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        return this.getWithLoaderAsync(key, loader).get(timeout, unit);
    }

    @Override
    public Future<V> getWithLoaderAsync(K key, CacheLoader<K, V> loader) {
        return this.getWithLoaderAsync(key, loader, this.defaultExpireAt());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Future<V> getWithLoaderAsync(K key, CacheLoader<K, V> loader, long expireAt) {
        if (key == null) {
            throw new NullPointerException();
        }
        if (this.executorService == null || this.executorService.isShutdown() || this.closed) {
            throw new IllegalStateException("OHCache has no executor service - configure one via OHCacheBuilder.executorService()");
        }
        final KeyBuffer keySource = this.keySource(key);
        final OffHeapLinkedMap segment = this.segment(keySource.hash());
        long hashEntryAdr = segment.getEntry(keySource, true, true);
        if (hashEntryAdr == 0L) {
            int keyLen = this.keySize(key);
            long bytes = Util.allocLen(keyLen, 0L);
            if (this.maxEntrySize > 0L && bytes > this.maxEntrySize || (hashEntryAdr = Uns.allocate(bytes, this.throwOOME)) == 0L) {
                ++this.putFailCount;
                this.remove(key);
                return Futures.immediateFailedFuture((Throwable)new RuntimeException("max entry size exceeded or malloc() failed"));
            }
            try {
                this.keySerializer.serialize(key, Uns.keyBuffer(hashEntryAdr, keyLen));
            }
            catch (Throwable e) {
                OHCacheLinkedImpl.freeAndThrow(e, hashEntryAdr);
            }
            long hash = this.hasher.hash(hashEntryAdr, 64L, keyLen);
            HashEntries.init(hash, keyLen, 0, hashEntryAdr, 1, 0L);
            if (segment.putEntry(hashEntryAdr, hash, keyLen, bytes, true, 0L, 0L, 0L)) {
                long sentinelHashEntryAdr = hashEntryAdr;
                return this.executorService.submit(() -> {
                    Exception failure = null;
                    V value = null;
                    boolean derefSentinel = false;
                    try {
                        long hashEntryAdr1;
                        value = loader.load(key);
                        long entryExpireAt = expireAt;
                        if (value == null || entryExpireAt > 0L && entryExpireAt <= this.ticker.currentTimeMillis()) {
                            segment.removeEntry(sentinelHashEntryAdr);
                            return null;
                        }
                        int valueLen = this.valueSize(value);
                        long bytes1 = Util.allocLen(keyLen, valueLen);
                        if (this.maxEntrySize > 0L && bytes1 > this.maxEntrySize || (hashEntryAdr1 = Uns.allocate(bytes1, this.throwOOME)) == 0L) {
                            throw new RuntimeException("max entry size exceeded or malloc() failed");
                        }
                        long hash1 = this.serializeForPut(key, value, keyLen, valueLen, hashEntryAdr1);
                        if (entryExpireAt == -1L) {
                            entryExpireAt = this.defaultExpireAt();
                        }
                        HashEntries.init(hash1, keyLen, valueLen, hashEntryAdr1, 0, entryExpireAt);
                        if (!segment.replaceSentinelEntry(hash1, sentinelHashEntryAdr, hashEntryAdr1, bytes1, entryExpireAt)) {
                            throw new RuntimeException("not enough free capacity");
                        }
                        derefSentinel = true;
                        HashEntries.setSentinel(sentinelHashEntryAdr, 2);
                        HashEntries.dereference(sentinelHashEntryAdr);
                    }
                    catch (PermanentLoadException e) {
                        HashEntries.setSentinel(sentinelHashEntryAdr, 4);
                        throw e;
                    }
                    catch (Throwable e) {
                        failure = e instanceof Exception ? (Exception)e : new RuntimeException(e);
                        HashEntries.setSentinel(sentinelHashEntryAdr, 3);
                        if (derefSentinel) {
                            HashEntries.dereference(sentinelHashEntryAdr);
                        }
                        segment.removeEntry(sentinelHashEntryAdr);
                    }
                    if (failure != null) {
                        throw failure;
                    }
                    return value;
                });
            }
            Uns.free(hashEntryAdr);
        }
        int sentinelStatus = HashEntries.getSentinel(hashEntryAdr);
        switch (sentinelStatus) {
            case 0: {
                try {
                    ListenableFuture bytes = Futures.immediateFuture(this.valueSerializer.deserialize(Uns.valueBufferR(hashEntryAdr)));
                    return bytes;
                }
                finally {
                    HashEntries.dereference(hashEntryAdr);
                }
            }
            case 4: {
                HashEntries.dereference(hashEntryAdr);
                return Futures.immediateFailedFuture((Throwable)new PermanentLoadException());
            }
        }
        final SettableFuture future = SettableFuture.create();
        final long sentinelHashEntryAdr = hashEntryAdr;
        this.executorService.schedule(new Runnable(){

            @Override
            public void run() {
                if (future.isCancelled() || OHCacheLinkedImpl.this.closed) {
                    HashEntries.dereference(sentinelHashEntryAdr);
                    return;
                }
                int sentinelStatus = HashEntries.getSentinel(sentinelHashEntryAdr);
                switch (sentinelStatus) {
                    case 2: {
                        break;
                    }
                    case 1: {
                        this.reschedule(0L);
                        return;
                    }
                    case 4: {
                        this.failure(0L, new PermanentLoadException());
                        return;
                    }
                    case 3: {
                        this.failure(0L, new TemporaryLoadException());
                        return;
                    }
                    default: {
                        this.failure(0L, (Throwable)((Object)new AssertionError((Object)("illegal sentinel value " + sentinelStatus))));
                        return;
                    }
                }
                long hashEntryAdr = segment.getEntry(keySource, true, true);
                if (hashEntryAdr == 0L) {
                    future.setException((Throwable)new TemporaryLoadException());
                }
                if (hashEntryAdr == sentinelHashEntryAdr) {
                    this.reschedule(0L);
                    return;
                }
                sentinelStatus = HashEntries.getSentinel(hashEntryAdr);
                switch (sentinelStatus) {
                    case 0: {
                        try {
                            future.set(OHCacheLinkedImpl.this.valueSerializer.deserialize(Uns.valueBufferR(hashEntryAdr)));
                            HashEntries.dereference(hashEntryAdr);
                            HashEntries.dereference(sentinelHashEntryAdr);
                        }
                        catch (Throwable e) {
                            this.failure(hashEntryAdr, e);
                        }
                        break;
                    }
                    case 1: 
                    case 2: {
                        HashEntries.dereference(hashEntryAdr);
                        this.reschedule(hashEntryAdr);
                        break;
                    }
                    case 4: {
                        this.failure(hashEntryAdr, new PermanentLoadException());
                        break;
                    }
                    case 3: {
                        this.failure(hashEntryAdr, new TemporaryLoadException());
                        break;
                    }
                    default: {
                        this.failure(hashEntryAdr, (Throwable)((Object)new AssertionError((Object)("illegal sentinel value " + sentinelStatus))));
                    }
                }
            }

            private void failure(long hashEntryAdr, Throwable e) {
                if (hashEntryAdr != 0L) {
                    HashEntries.dereference(hashEntryAdr);
                }
                HashEntries.dereference(sentinelHashEntryAdr);
                future.setException(e);
            }

            private void reschedule(long hashEntryAdr) {
                try {
                    OHCacheLinkedImpl.this.executorService.schedule(this, 10L, TimeUnit.MILLISECONDS);
                }
                catch (Throwable t) {
                    this.failure(hashEntryAdr, t);
                }
            }
        }, 10L, TimeUnit.MILLISECONDS);
        return future;
    }

    private OffHeapLinkedMap segment(long hash) {
        int seg = (int)((hash & this.segmentMask) >>> this.segmentShift);
        return this.maps[seg];
    }

    private KeyBuffer keySource(K o) {
        int size = this.keySize(o);
        KeyBuffer keyBuffer = new KeyBuffer(size);
        ByteBuffer bb = keyBuffer.byteBuffer();
        this.keySerializer.serialize(o, bb);
        assert (bb.position() == bb.capacity() && bb.capacity() == size);
        return keyBuffer.finish(this.hasher);
    }

    @Override
    public void clear() {
        for (OffHeapLinkedMap map : this.maps) {
            map.clear();
        }
    }

    @Override
    public void setCapacity(long capacity) {
        if (capacity < 0L) {
            throw new IllegalArgumentException();
        }
        long oldPerSegment = this.capacity / (long)this.segments();
        this.capacity = capacity;
        long perSegment = capacity / (long)this.segments();
        long diff = perSegment - oldPerSegment;
        for (OffHeapLinkedMap map : this.maps) {
            map.updateFreeCapacity(diff);
        }
    }

    @Override
    public void close() {
        this.closed = true;
        if (this.executorService != null) {
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
        this.clear();
        for (OffHeapLinkedMap map : this.maps) {
            map.release();
        }
        Arrays.fill(this.maps, null);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Closing OHC instance");
        }
    }

    @Override
    public void resetStatistics() {
        for (OffHeapLinkedMap map : this.maps) {
            map.resetStatistics();
        }
        this.putFailCount = 0L;
    }

    @Override
    public OHCacheStats stats() {
        long rehashes = 0L;
        for (OffHeapLinkedMap map : this.maps) {
            rehashes += map.rehashes();
        }
        return new OHCacheStats(this.hitCount(), this.missCount(), this.evictedEntries(), this.expiredEntries(), this.perSegmentSizes(), this.size(), this.capacity(), this.freeCapacity(), rehashes, this.putAddCount(), this.putReplaceCount(), this.putFailCount, this.removeCount(), Uns.getTotalAllocated(), 0L);
    }

    private long putAddCount() {
        long putAddCount = 0L;
        for (OffHeapLinkedMap map : this.maps) {
            putAddCount += map.putAddCount();
        }
        return putAddCount;
    }

    private long putReplaceCount() {
        long putReplaceCount = 0L;
        for (OffHeapLinkedMap map : this.maps) {
            putReplaceCount += map.putReplaceCount();
        }
        return putReplaceCount;
    }

    private long removeCount() {
        long removeCount = 0L;
        for (OffHeapLinkedMap map : this.maps) {
            removeCount += map.removeCount();
        }
        return removeCount;
    }

    private long hitCount() {
        long hitCount = 0L;
        for (OffHeapLinkedMap map : this.maps) {
            hitCount += map.hitCount();
        }
        return hitCount;
    }

    private long missCount() {
        long missCount = 0L;
        for (OffHeapLinkedMap map : this.maps) {
            missCount += map.missCount();
        }
        return missCount;
    }

    @Override
    public long capacity() {
        return this.capacity;
    }

    @Override
    public long freeCapacity() {
        long freeCapacity = 0L;
        for (OffHeapLinkedMap map : this.maps) {
            freeCapacity += map.freeCapacity();
        }
        return freeCapacity;
    }

    private long evictedEntries() {
        long evictedEntries = 0L;
        for (OffHeapLinkedMap map : this.maps) {
            evictedEntries += map.evictedEntries();
        }
        return evictedEntries;
    }

    private long expiredEntries() {
        long expiredEntries = 0L;
        for (OffHeapLinkedMap map : this.maps) {
            expiredEntries += map.expiredEntries();
        }
        return expiredEntries;
    }

    int usedTimeouts() {
        int used = 0;
        for (OffHeapLinkedMap map : this.maps) {
            used += map.usedTimeouts();
        }
        return used;
    }

    @Override
    public long size() {
        long size = 0L;
        for (OffHeapLinkedMap map : this.maps) {
            size += map.size();
        }
        return size;
    }

    @Override
    public int segments() {
        return this.maps.length;
    }

    @Override
    public float loadFactor() {
        return this.maps[0].loadFactor();
    }

    @Override
    public int[] hashTableSizes() {
        int[] r = new int[this.maps.length];
        for (int i = 0; i < this.maps.length; ++i) {
            r[i] = this.maps[i].hashTableSize();
        }
        return r;
    }

    @Override
    public long[] perSegmentSizes() {
        long[] r = new long[this.maps.length];
        for (int i = 0; i < this.maps.length; ++i) {
            r[i] = this.maps[i].size();
        }
        return r;
    }

    @Override
    public EstimatedHistogram getBucketHistogram() {
        int i;
        EstimatedHistogram hist = new EstimatedHistogram();
        for (OffHeapLinkedMap map : this.maps) {
            map.updateBucketHistogram(hist);
        }
        long[] offsets = hist.getBucketOffsets();
        long[] buckets = hist.getBuckets(false);
        for (i = buckets.length - 1; i > 0; --i) {
            if (buckets[i] == 0L) continue;
            offsets = Arrays.copyOf(offsets, i + 2);
            buckets = Arrays.copyOf(buckets, i + 3);
            System.arraycopy(offsets, 0, offsets, 1, i + 1);
            System.arraycopy(buckets, 0, buckets, 1, i + 2);
            offsets[0] = 0L;
            buckets[0] = 0L;
            break;
        }
        i = 0;
        while (i < offsets.length) {
            int n = i++;
            offsets[n] = offsets[n] - 1L;
        }
        return new EstimatedHistogram(offsets, buckets);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CloseableIterator<K> deserializeKeys(final ReadableByteChannel channel) throws IOException {
        long headerAddress = Uns.allocateIOException(8L, this.throwOOME);
        try {
            ByteBuffer header = Uns.directBufferFor(headerAddress, 0L, 8L, false);
            Util.readFully(channel, header);
            ByteBufferCompat.byteBufferFlip(header);
            int magic = header.getInt();
            if (magic == 1262700623) {
                throw new IOException("File from instance with different CPU architecture cannot be loaded");
            }
            if (magic == 1330135877) {
                throw new IOException("File contains entries - expected keys");
            }
            if (magic != 1330135883) {
                throw new IOException("Illegal file header");
            }
            if (header.getInt() != 2) {
                throw new IOException("Illegal file version");
            }
        }
        finally {
            Uns.free(headerAddress);
        }
        return new CloseableIterator<K>(){
            private K next;
            private boolean eod;
            private final byte[] keyLenBuf = new byte[4];
            private final ByteBuffer bb = ByteBuffer.wrap(this.keyLenBuf);
            private long bufAdr;
            private long bufLen;

            @Override
            public void close() {
                Uns.free(this.bufAdr);
                this.bufAdr = 0L;
            }

            protected void finalize() throws Throwable {
                this.close();
                super.finalize();
            }

            @Override
            public boolean hasNext() {
                if (this.eod) {
                    return false;
                }
                if (this.next == null) {
                    this.checkNext();
                }
                return this.next != null;
            }

            private void checkNext() {
                try {
                    ByteBufferCompat.byteBufferClear(this.bb);
                    if (!Util.readFully(channel, this.bb)) {
                        this.eod = true;
                        return;
                    }
                    int keyLen = Uns.getIntFromByteArray(this.keyLenBuf, 0);
                    long totalLen = 64L + (long)keyLen;
                    if (this.bufLen < totalLen) {
                        Uns.free(this.bufAdr);
                        this.bufAdr = 0L;
                        this.bufLen = Math.max(4096L, Util.roundUpToPowerOf2(totalLen, 0x40000000L));
                        this.bufAdr = Uns.allocateIOException(this.bufLen, OHCacheLinkedImpl.this.throwOOME);
                    }
                    if (!Util.readFully(channel, Uns.directBufferFor(this.bufAdr, 64L, keyLen, false))) {
                        this.eod = true;
                        throw new EOFException();
                    }
                    HashEntries.init(0L, keyLen, 0, this.bufAdr, 0, OHCacheLinkedImpl.this.defaultExpireAt());
                    this.next = OHCacheLinkedImpl.this.keySerializer.deserialize(Uns.directBufferFor(this.bufAdr + 64L, 0L, keyLen, true));
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }

            @Override
            public K next() {
                if (this.eod) {
                    throw new NoSuchElementException();
                }
                Object r = this.next;
                if (r == null) {
                    this.checkNext();
                    r = this.next;
                }
                if (r == null) {
                    throw new NoSuchElementException();
                }
                this.next = null;
                return r;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    @Override
    public boolean deserializeEntry(ReadableByteChannel channel) throws IOException {
        long hashEntryAdr;
        long kvLen;
        byte[] hashKeyValueLen = new byte[16];
        ByteBuffer bb = ByteBuffer.wrap(hashKeyValueLen);
        if (!Util.readFully(channel, bb)) {
            return false;
        }
        long expireAt = 0L;
        long hash = Uns.getLongFromByteArray(hashKeyValueLen, 0);
        int valueLen = Uns.getIntFromByteArray(hashKeyValueLen, 8);
        int keyLen = Uns.getIntFromByteArray(hashKeyValueLen, 12);
        long totalLen = kvLen + 64L;
        if (this.maxEntrySize > 0L && totalLen > this.maxEntrySize || (hashEntryAdr = Uns.allocate(totalLen, this.throwOOME)) == 0L) {
            if (channel instanceof SeekableByteChannel) {
                SeekableByteChannel sc = (SeekableByteChannel)channel;
                sc.position(sc.position() + kvLen);
            } else {
                ByteBuffer tmp = ByteBuffer.allocate(8192);
                for (kvLen = Util.roundUpTo8(keyLen) + (long)valueLen; kvLen > 0L; kvLen -= (long)tmp.limit()) {
                    ByteBufferCompat.byteBufferClear(tmp);
                    if (kvLen < (long)tmp.capacity()) {
                        ByteBufferCompat.byteBufferLimit(tmp, Ints.checkedCast((long)kvLen));
                    }
                    if (Util.readFully(channel, tmp)) continue;
                    return false;
                }
            }
            return false;
        }
        HashEntries.init(hash, keyLen, valueLen, hashEntryAdr, 0, this.defaultExpireAt());
        if (!Util.readFully(channel, Uns.keyBuffer(hashEntryAdr, kvLen)) || !this.segment(hash).putEntry(hashEntryAdr, hash, keyLen, totalLen, false, expireAt, 0L, 0L)) {
            Uns.free(hashEntryAdr);
            return false;
        }
        return true;
    }

    @Override
    public boolean serializeEntry(K key, WritableByteChannel channel) throws IOException {
        KeyBuffer keySource = this.keySource(key);
        long hashEntryAdr = this.segment(keySource.hash()).getEntry(keySource, true, true);
        return hashEntryAdr != 0L && OHCacheLinkedImpl.serializeEntry(channel, hashEntryAdr);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int deserializeEntries(ReadableByteChannel channel) throws IOException {
        long headerAddress = Uns.allocateIOException(8L, this.throwOOME);
        try {
            ByteBuffer header = Uns.directBufferFor(headerAddress, 0L, 8L, false);
            Util.readFully(channel, header);
            ByteBufferCompat.byteBufferFlip(header);
            int magic = header.getInt();
            if (magic == 1162037327) {
                throw new IOException("File from instance with different CPU architecture cannot be loaded");
            }
            if (magic == 1330135883) {
                throw new IOException("File contains keys - expected entries");
            }
            if (magic != 1330135877) {
                throw new IOException("Illegal file header");
            }
            if (header.getInt() != 2) {
                throw new IOException("Illegal file version");
            }
        }
        finally {
            Uns.free(headerAddress);
        }
        int count = 0;
        while (this.deserializeEntry(channel)) {
            ++count;
        }
        return count;
    }

    @Override
    public int serializeHotNEntries(int n, WritableByteChannel channel) throws IOException {
        return this.serializeHotN(n, channel, true);
    }

    @Override
    public int serializeHotNKeys(int n, WritableByteChannel channel) throws IOException {
        return this.serializeHotN(n, channel, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int serializeHotN(int n, WritableByteChannel channel, boolean entries) throws IOException {
        long headerAddress = Uns.allocateIOException(8L, this.throwOOME);
        try {
            ByteBuffer headerBuffer = Uns.directBufferFor(headerAddress, 0L, 8L, false);
            headerBuffer.putInt(entries ? 1330135877 : 1330135883);
            headerBuffer.putInt(2);
            ByteBufferCompat.byteBufferFlip(headerBuffer);
            Util.writeFully(channel, headerBuffer);
        }
        finally {
            Uns.free(headerAddress);
        }
        int perMap = n / this.maps.length + 1;
        int cnt = 0;
        for (OffHeapLinkedMap map : this.maps) {
            long[] hotPerMap = map.hotN(perMap);
            try {
                for (int i = 0; i < hotPerMap.length; ++i) {
                    long hashEntryAdr = hotPerMap[i];
                    if (hashEntryAdr == 0L) continue;
                    try {
                        if (entries) {
                            OHCacheLinkedImpl.serializeEntry(channel, hashEntryAdr);
                        } else {
                            OHCacheLinkedImpl.serializeKey(channel, hashEntryAdr);
                        }
                    }
                    finally {
                        hotPerMap[i] = 0L;
                    }
                    ++cnt;
                }
            }
            finally {
                for (long hashEntryAdr : hotPerMap) {
                    if (hashEntryAdr == 0L) continue;
                    HashEntries.dereference(hashEntryAdr);
                }
            }
        }
        return cnt;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean serializeEntry(WritableByteChannel channel, long hashEntryAdr) throws IOException {
        try {
            int keyLen = HashEntries.getKeyLen(hashEntryAdr);
            int valueLen = HashEntries.getValueLen(hashEntryAdr);
            long totalLen = 16L + Util.roundUpTo8(keyLen) + (long)valueLen;
            Util.writeFully(channel, Uns.directBufferFor(hashEntryAdr, 48L, totalLen, true));
            boolean bl = true;
            return bl;
        }
        finally {
            HashEntries.dereference(hashEntryAdr);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean serializeKey(WritableByteChannel channel, long hashEntryAdr) throws IOException {
        try {
            long keyLen = HashEntries.getKeyLen(hashEntryAdr);
            long totalLen = 4L + keyLen;
            Util.writeFully(channel, Uns.directBufferFor(hashEntryAdr, 60L, totalLen, true));
            boolean bl = true;
            return bl;
        }
        finally {
            HashEntries.dereference(hashEntryAdr);
        }
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> m) {
        for (Map.Entry<K, V> entry : m.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public void removeAll(Iterable<K> iterable) {
        for (K o : iterable) {
            this.remove(o);
        }
    }

    @Override
    public long memUsed() {
        return this.capacity() - this.freeCapacity();
    }

    @Override
    public CloseableIterator<K> hotKeyIterator(int n) {
        return new AbstractHotKeyIterator<K>(n){

            @Override
            K buildResult(long hashEntryAdr) {
                return OHCacheLinkedImpl.this.keySerializer.deserialize(Uns.directBufferFor(hashEntryAdr + 64L, 0L, HashEntries.getKeyLen(hashEntryAdr), true));
            }
        };
    }

    @Override
    public CloseableIterator<ByteBuffer> hotKeyBufferIterator(int n) {
        return new AbstractHotKeyIterator<ByteBuffer>(n){

            @Override
            ByteBuffer buildResult(long hashEntryAdr) {
                return Uns.directBufferFor(hashEntryAdr, 64L, HashEntries.getKeyLen(hashEntryAdr), true);
            }
        };
    }

    @Override
    public CloseableIterator<K> keyIterator() {
        return new AbstractKeyIterator<K>(){

            @Override
            K buildResult(long hashEntryAdr) {
                return OHCacheLinkedImpl.this.keySerializer.deserialize(Uns.keyBufferR(hashEntryAdr));
            }
        };
    }

    @Override
    public CloseableIterator<ByteBuffer> keyBufferIterator() {
        return new AbstractKeyIterator<ByteBuffer>(){

            @Override
            ByteBuffer buildResult(long hashEntryAdr) {
                return Uns.directBufferFor(hashEntryAdr, 64L, HashEntries.getKeyLen(hashEntryAdr), true);
            }
        };
    }

    public String toString() {
        return this.getClass().getSimpleName() + "(capacity=" + this.capacity() + " ,segments=" + this.maps.length + " ,defaultTTL=" + this.defaultTTL + " ,maxEntrySize=" + this.maxEntrySize;
    }

    private abstract class AbstractHotKeyIterator<R>
    extends AbstractIterator<R>
    implements CloseableIterator<R> {
        private final int perMap;
        int mapIndex;
        long[] hotPerMap;
        int subIndex;
        long lastHashEntryAdr;

        AbstractHotKeyIterator(int n) {
            this.perMap = n / OHCacheLinkedImpl.this.maps.length + 1;
        }

        private void derefLast() {
            if (this.lastHashEntryAdr != 0L) {
                HashEntries.dereference(this.lastHashEntryAdr);
                this.lastHashEntryAdr = 0L;
            }
        }

        @Override
        public void close() {
            this.derefLast();
            while (this.hotPerMap != null && this.subIndex < this.hotPerMap.length) {
                long hashEntryAdr;
                if ((hashEntryAdr = this.hotPerMap[this.subIndex++]) == 0L) continue;
                HashEntries.dereference(hashEntryAdr);
            }
        }

        abstract R buildResult(long var1);

        protected R computeNext() {
            this.derefLast();
            while (true) {
                long hashEntryAdr;
                if (this.hotPerMap != null && this.subIndex < this.hotPerMap.length && (hashEntryAdr = this.hotPerMap[this.subIndex++]) != 0L) {
                    this.lastHashEntryAdr = hashEntryAdr;
                    return this.buildResult(hashEntryAdr);
                }
                if (this.mapIndex == OHCacheLinkedImpl.this.maps.length) {
                    return (R)this.endOfData();
                }
                this.hotPerMap = OHCacheLinkedImpl.this.maps[this.mapIndex++].hotN(this.perMap);
                this.subIndex = 0;
            }
        }
    }

    private abstract class AbstractKeyIterator<R>
    implements CloseableIterator<R> {
        private int segmentIndex;
        private OffHeapLinkedMap segment;
        private int mapSegmentCount;
        private int mapSegmentIndex;
        private final LongArrayList hashEntryAdrs = new LongArrayList(1024);
        private int listIndex;
        private boolean eod;
        private R next;
        private OffHeapLinkedMap lastSegment;
        private long lastHashEntryAdr;

        private AbstractKeyIterator() {
        }

        private void derefLast() {
            if (this.lastHashEntryAdr != 0L) {
                HashEntries.dereference(this.lastHashEntryAdr);
                this.lastHashEntryAdr = 0L;
                this.lastSegment = null;
            }
        }

        @Override
        public void close() {
            this.derefLast();
            while (this.listIndex < this.hashEntryAdrs.size()) {
                long hashEntryAdr = this.hashEntryAdrs.getLong(this.listIndex++);
                HashEntries.dereference(hashEntryAdr);
            }
        }

        @Override
        public boolean hasNext() {
            if (this.eod) {
                return false;
            }
            if (this.next == null) {
                this.next = this.computeNext();
            }
            return this.next != null;
        }

        @Override
        public R next() {
            if (this.eod) {
                throw new NoSuchElementException();
            }
            if (this.next == null) {
                this.next = this.computeNext();
            }
            R r = this.next;
            this.next = null;
            if (!this.eod) {
                return r;
            }
            throw new NoSuchElementException();
        }

        @Override
        public void remove() {
            if (this.eod) {
                throw new NoSuchElementException();
            }
            this.lastSegment.removeEntry(this.lastHashEntryAdr);
            this.derefLast();
        }

        private R computeNext() {
            this.derefLast();
            while (true) {
                if (this.listIndex < this.hashEntryAdrs.size()) {
                    long hashEntryAdr = this.hashEntryAdrs.getLong(this.listIndex++);
                    this.lastSegment = this.segment;
                    this.lastHashEntryAdr = hashEntryAdr;
                    return this.buildResult(hashEntryAdr);
                }
                if (this.mapSegmentIndex >= this.mapSegmentCount) {
                    if (this.segmentIndex == OHCacheLinkedImpl.this.maps.length) {
                        this.eod = true;
                        return null;
                    }
                    this.segment = OHCacheLinkedImpl.this.maps[this.segmentIndex++];
                    this.mapSegmentCount = this.segment.hashTableSize();
                    this.mapSegmentIndex = 0;
                }
                if (this.listIndex != this.hashEntryAdrs.size()) continue;
                this.hashEntryAdrs.clear();
                this.segment.getEntryAddresses(this.mapSegmentIndex, 1024, this.hashEntryAdrs);
                this.mapSegmentIndex += 1024;
                this.listIndex = 0;
            }
        }

        abstract R buildResult(long var1);
    }
}

