/*
 * Decompiled with CFR 0.152.
 */
package org.caffinitas.ohc.linked;

import org.caffinitas.ohc.HashAlgorithm;

abstract class Hasher {
    Hasher() {
    }

    static Hasher create(HashAlgorithm hashAlgorithm) {
        String cls = Hasher.forAlg(hashAlgorithm);
        try {
            return (Hasher)Class.forName(cls).newInstance();
        }
        catch (ClassNotFoundException e) {
            if (hashAlgorithm == HashAlgorithm.XX) {
                cls = Hasher.forAlg(HashAlgorithm.CRC32);
                try {
                    return (Hasher)Class.forName(cls).newInstance();
                }
                catch (ClassNotFoundException | IllegalAccessException | InstantiationException e1) {
                    throw new RuntimeException(e1);
                }
            }
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new RuntimeException(e);
        }
    }

    private static String forAlg(HashAlgorithm hashAlgorithm) {
        return Hasher.class.getName().substring(0, Hasher.class.getName().lastIndexOf(46) + 1) + hashAlgorithm.name().substring(0, 1) + hashAlgorithm.name().substring(1).toLowerCase() + "Hash";
    }

    abstract long hash(byte[] var1);

    abstract long hash(long var1, long var3, int var5);
}

