/*
 * Decompiled with CFR 0.152.
 */
package org.caffinitas.ohc.chunked;

import com.google.common.collect.AbstractIterator;
import com.google.common.primitives.Ints;
import java.nio.ByteBuffer;
import java.util.Iterator;
import java.util.concurrent.atomic.AtomicLongFieldUpdater;
import org.caffinitas.ohc.CacheSerializer;
import org.caffinitas.ohc.OHCacheBuilder;
import org.caffinitas.ohc.Ticker;
import org.caffinitas.ohc.chunked.KeyBuffer;
import org.caffinitas.ohc.chunked.Uns;
import org.caffinitas.ohc.chunked.Util;
import org.caffinitas.ohc.histo.EstimatedHistogram;
import sun.nio.ch.DirectBuffer;

final class OffHeapChunkedMap {
    private static final int TWO_POWER_30 = 0x40000000;
    private final int fixedKeySize;
    private final int fixedValueSize;
    private long size;
    private long hitCount;
    private long missCount;
    private long putAddCount;
    private long putReplaceCount;
    private long removeCount;
    private final float loadFactor;
    private long rehashes;
    private long evictedEntries;
    private long expiredEntries;
    private final boolean unlocked;
    private volatile long lock;
    private static final AtomicLongFieldUpdater<OffHeapChunkedMap> lockFieldUpdater = AtomicLongFieldUpdater.newUpdater(OffHeapChunkedMap.class, "lock");
    private final boolean throwOOME;
    private final Ticker ticker;
    private Table table;
    private long threshold;
    private int capacity;
    private int freeCapacity;
    private final int chunkDataSize;
    private final int chunkFullSize;
    private final int chunkCount;
    private int chunksUsed;
    private int writeChunk;
    private int writeChunkOffset;
    private int writeChunkFree;
    private final ByteBuffer memory;

    OffHeapChunkedMap(OHCacheBuilder builder, long freeCapacity, long chunkSize) {
        this.throwOOME = builder.isThrowOOME();
        this.ticker = builder.getTicker();
        this.unlocked = builder.isUnlocked();
        float lf = builder.getLoadFactor();
        if ((double)lf <= 0.0) {
            lf = 0.75f;
        }
        this.loadFactor = lf;
        if (freeCapacity > 0x40000000L) {
            throw new IllegalArgumentException("Segment too big (max 2^30)");
        }
        this.fixedKeySize = builder.getFixedKeySize();
        this.fixedValueSize = builder.getFixedValueSize();
        this.chunkDataSize = Ints.checkedCast((long)chunkSize);
        this.chunkFullSize = Ints.checkedCast((long)(chunkSize + 16L));
        this.chunkCount = (int)(freeCapacity / chunkSize);
        this.freeCapacity = this.capacity = Ints.checkedCast((long)((long)this.chunkCount * chunkSize));
        int allocSize = Ints.checkedCast((long)((long)this.chunkCount * (long)this.chunkFullSize));
        this.memory = Uns.allocate(allocSize, this.throwOOME);
        for (int i = 0; i < this.chunkCount; ++i) {
            this.resetChunk(i);
        }
        this.initWriteChunk(0);
        this.chunksUsed = 1;
        int hts = builder.getHashTableSize();
        if (hts <= 0) {
            hts = 8192;
        }
        if (hts < 256) {
            hts = 256;
        }
        int msz = Ints.checkedCast((long)Util.roundUpToPowerOf2(hts, 0x40000000L));
        this.table = this.createTable(msz, this.throwOOME);
        if (this.table == null) {
            throw new RuntimeException("unable to allocate off-heap memory for segment");
        }
        this.threshold = (long)((double)this.table.size() * (double)this.loadFactor);
    }

    long size() {
        return this.size;
    }

    long hitCount() {
        return this.hitCount;
    }

    long missCount() {
        return this.missCount;
    }

    long putAddCount() {
        return this.putAddCount;
    }

    long putReplaceCount() {
        return this.putReplaceCount;
    }

    long removeCount() {
        return this.removeCount;
    }

    void resetStatistics() {
        this.rehashes = 0L;
        this.evictedEntries = 0L;
        this.expiredEntries = 0L;
        this.hitCount = 0L;
        this.missCount = 0L;
        this.putAddCount = 0L;
        this.putReplaceCount = 0L;
        this.removeCount = 0L;
    }

    long rehashes() {
        return this.rehashes;
    }

    long evictedEntries() {
        return this.evictedEntries;
    }

    long expiredEntries() {
        return this.expiredEntries;
    }

    float loadFactor() {
        return this.loadFactor;
    }

    void release() {
        boolean wasFirst = this.lock();
        try {
            Uns.free(this.memory);
            this.table.release();
            this.table = null;
        }
        finally {
            this.unlock(wasFirst);
        }
    }

    long freeCapacity() {
        return this.freeCapacity;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Object getEntry(KeyBuffer key, CacheSerializer<?> valueSerializer) {
        ByteBuffer serBuffer = null;
        boolean wasFirst = this.lock();
        try {
            int hashEntryOffset = this.table.getFirst(key.hash());
            while ((long)hashEntryOffset != 0L) {
                if (!this.notSameKey(key, hashEntryOffset) && !this.isEntryRemoved(hashEntryOffset)) {
                    ++this.hitCount;
                    if (valueSerializer == null) {
                        Boolean bl = Boolean.TRUE;
                        return bl;
                    }
                    this.touch(hashEntryOffset);
                    int keyLen = this.getKeyLen(hashEntryOffset);
                    int valueLen = this.getValueLen(hashEntryOffset);
                    int hashEntryValueOffset = hashEntryOffset + Util.entryOffData(this.isFixedSize()) + keyLen;
                    serBuffer = ByteBuffer.allocate(valueLen);
                    Uns.copyMemory(((DirectBuffer)((Object)this.memory)).address(), (long)hashEntryValueOffset, serBuffer.array(), 0, (long)valueLen);
                    serBuffer.limit(valueLen);
                    break;
                }
                hashEntryOffset = this.getNext(hashEntryOffset);
            }
            if (hashEntryOffset == 0) {
                ++this.missCount;
                Object var6_8 = null;
                return var6_8;
            }
        }
        finally {
            this.unlock(wasFirst);
        }
        return valueSerializer.deserialize(serBuffer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean putEntry(ByteBuffer newHashEntry, long hash, int keyLen, int entryBytes, boolean ifAbsent, int oldValueLen) {
        boolean wasFirst = this.lock();
        try {
            int prevEntryOffset = 0;
            int hashEntryOffset = this.table.getFirst(hash);
            while ((long)hashEntryOffset != 0L) {
                if (!this.notSameKey(newHashEntry, hash, keyLen, hashEntryOffset)) {
                    if (!this.isEntryRemoved(hashEntryOffset)) {
                        int valueLen;
                        if (ifAbsent) {
                            boolean bl = false;
                            return bl;
                        }
                        int valueOffset = Util.entryOffData(this.isFixedSize()) + keyLen;
                        int hashEntryValueOffset = hashEntryOffset + valueOffset;
                        if (!(oldValueLen == 0 || (valueLen = this.getValueLen(hashEntryOffset)) == oldValueLen && this.compare(hashEntryValueOffset, newHashEntry, entryBytes, oldValueLen))) {
                            boolean bl = false;
                            return bl;
                        }
                        if (this.getValueReservedLen(hashEntryOffset) >= this.getValueLen(newHashEntry)) {
                            if (!this.isFixedSize()) {
                                this.setValueLen(hashEntryOffset, this.getValueLen(newHashEntry));
                            }
                            Uns.copyMemory(newHashEntry.array(), valueOffset, ((DirectBuffer)((Object)this.memory)).address(), (long)hashEntryValueOffset, (long)(entryBytes - valueOffset));
                            ++this.putReplaceCount;
                            valueLen = 1;
                            return valueLen != 0;
                        }
                    }
                    this.removeInternal(hashEntryOffset, prevEntryOffset);
                    break;
                }
                prevEntryOffset = hashEntryOffset;
                hashEntryOffset = this.getNext(hashEntryOffset);
            }
            if (this.writeChunkFree < entryBytes) {
                if (this.chunksUsed >= this.chunkCount) {
                    long minTS = Long.MAX_VALUE;
                    int eldestChunk = 0;
                    for (int i = 0; i < this.chunkCount; ++i) {
                        long ts = this.lastUsed(i);
                        if (ts >= minTS) continue;
                        eldestChunk = i;
                        minTS = ts;
                    }
                    int entries = this.entriesInChunk(eldestChunk);
                    int removed = 0;
                    int off = this.chunkOffset(eldestChunk) + 16;
                    for (int i = 0; i < entries; ++i) {
                        int nextOff = this.nextHashEntryOffset(off);
                        if (!this.isEntryRemoved(off)) {
                            this.removeInternal(off, -1);
                            ++removed;
                        }
                        off = nextOff;
                    }
                    this.evictedEntries += (long)entries;
                    this.size -= (long)removed;
                    this.freeCapacity += this.bytesInChunk(eldestChunk);
                    this.initWriteChunk(eldestChunk);
                } else {
                    this.initWriteChunk(this.writeChunk + 1);
                    ++this.chunksUsed;
                }
            }
            if ((long)hashEntryOffset == 0L) {
                if (this.size >= this.threshold) {
                    this.rehash();
                }
                ++this.size;
            }
            if ((long)hashEntryOffset == 0L) {
                ++this.putAddCount;
            } else {
                ++this.putReplaceCount;
            }
            hashEntryOffset = this.chunkOffset(this.writeChunk) + this.writeChunkOffset;
            Uns.copyMemory(newHashEntry.array(), newHashEntry.position(), ((DirectBuffer)((Object)this.memory)).address(), (long)hashEntryOffset, (long)(entryBytes - newHashEntry.position()));
            this.writeChunkOffset += entryBytes;
            this.writeChunkFree -= entryBytes;
            this.freeCapacity -= entryBytes;
            this.entryAdded(this.writeChunk, entryBytes);
            this.table.addAsHead(hash, hashEntryOffset);
            boolean bl = true;
            return bl;
        }
        finally {
            this.unlock(wasFirst);
        }
    }

    void clear() {
        boolean wasFirst = this.lock();
        try {
            this.size = 0L;
            this.freeCapacity = this.capacity;
            this.table.clear();
            this.initWriteChunk(0);
            this.chunksUsed = 1;
        }
        finally {
            this.unlock(wasFirst);
        }
    }

    private void initWriteChunk(int newWriteChunk) {
        this.writeChunk = newWriteChunk;
        this.writeChunkFree = this.chunkDataSize;
        this.writeChunkOffset = 16;
        this.resetChunk(newWriteChunk);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean removeEntry(KeyBuffer key) {
        boolean wasFirst = this.lock();
        try {
            int prevEntryOffset = 0;
            int hashEntryOffset = this.table.getFirst(key.hash());
            while (hashEntryOffset != 0) {
                if (!this.notSameKey(key, hashEntryOffset) && !this.isEntryRemoved(hashEntryOffset)) {
                    this.removeInternal(hashEntryOffset, prevEntryOffset);
                    --this.size;
                    ++this.removeCount;
                    boolean bl = true;
                    return bl;
                }
                prevEntryOffset = hashEntryOffset;
                hashEntryOffset = this.getNext(hashEntryOffset);
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.unlock(wasFirst);
        }
    }

    private boolean notSameKey(KeyBuffer key, int hashEntryOffset) {
        if (this.getHash(hashEntryOffset) != key.hash()) {
            return true;
        }
        int serKeyLen = this.getKeyLen(hashEntryOffset);
        return serKeyLen != key.size() || !this.compareKey(hashEntryOffset, key);
    }

    private boolean notSameKey(ByteBuffer hashEntry, long newHash, int newKeyLen, int hashEntryOffset) {
        if (this.getHash(hashEntry) != newHash) {
            return true;
        }
        int serKeyLen = this.getKeyLen(hashEntryOffset);
        return serKeyLen != newKeyLen || !this.compare(hashEntryOffset + Util.entryOffData(this.isFixedSize()), hashEntry, Util.entryOffData(this.isFixedSize()), serKeyLen);
    }

    private void rehash() {
        Table tab = this.table;
        int tableSize = tab.size();
        if (tableSize > 0x40000000) {
            return;
        }
        Table newTable = this.createTable(tableSize * 2, this.throwOOME);
        if (newTable == null) {
            return;
        }
        for (int part = 0; part < tableSize; ++part) {
            int hashEntryOffset = tab.getFirst(part);
            while ((long)hashEntryOffset != 0L) {
                int next = this.getNext(hashEntryOffset);
                this.setNext(hashEntryOffset, 0);
                newTable.addAsHead(this.getHash(hashEntryOffset), hashEntryOffset);
                hashEntryOffset = next;
            }
        }
        this.threshold = (long)((float)newTable.size() * this.loadFactor);
        this.table.release();
        this.table = newTable;
        ++this.rehashes;
    }

    int hashTableSize() {
        return this.table.size();
    }

    void updateBucketHistogram(EstimatedHistogram hist) {
        boolean wasFirst = this.lock();
        try {
            this.table.updateBucketHistogram(hist);
        }
        finally {
            this.unlock(wasFirst);
        }
    }

    private Table createTable(int hashTableSize, boolean throwOOME) {
        int msz = 4 * hashTableSize;
        ByteBuffer table = Uns.allocate(msz, throwOOME);
        return table == null ? null : new Table(table, hashTableSize);
    }

    private void removeInternal(int hashEntryOffset, int prevEntryOffset) {
        long hash = this.getHash(hashEntryOffset);
        this.table.removeLink(hash, hashEntryOffset, prevEntryOffset);
        this.setEntryRemoved(hashEntryOffset);
    }

    public String toString() {
        return String.valueOf(this.size);
    }

    Iterator<ByteBuffer> snapshotIterator(final int keysPerChunk, final ByteBuffer snaphotBuffer) {
        return new AbstractIterator<ByteBuffer>(){
            private int chunk;
            private Iterator<ByteBuffer> snapshotIterator;

            protected ByteBuffer computeNext() {
                while (this.snapshotIterator == null || !this.snapshotIterator.hasNext()) {
                    if (this.chunk == OffHeapChunkedMap.this.chunkCount) {
                        return (ByteBuffer)this.endOfData();
                    }
                    boolean wasFirst = OffHeapChunkedMap.this.lock();
                    try {
                        Uns.copyMemory(((DirectBuffer)((Object)OffHeapChunkedMap.this.memory)).address(), (long)OffHeapChunkedMap.this.chunkOffset(this.chunk), snaphotBuffer.array(), 0, (long)OffHeapChunkedMap.this.chunkFullSize);
                        snaphotBuffer.position(0);
                        snaphotBuffer.limit(OffHeapChunkedMap.this.chunkFullSize);
                        this.snapshotIterator = new ChunkSnapshotIterator(keysPerChunk, snaphotBuffer);
                        continue;
                    }
                    finally {
                        OffHeapChunkedMap.this.unlock(wasFirst);
                        ++this.chunk;
                        continue;
                    }
                    break;
                }
                return this.snapshotIterator.next();
            }
        };
    }

    private long getHash(int hashEntryOffset) {
        return this.memory.getLong(hashEntryOffset + 0);
    }

    private long getHash(ByteBuffer hashEntry) {
        return hashEntry.getLong(0);
    }

    private int getNext(int hashEntryOffset) {
        return hashEntryOffset != 0 ? this.memory.getInt(hashEntryOffset + 8) : 0;
    }

    private void setNext(int hashEntryOffset, int nextEntryOffset) {
        this.memory.putInt(hashEntryOffset + 8, nextEntryOffset);
    }

    private boolean isEntryRemoved(int hashEntryOffset) {
        return this.memory.getInt(hashEntryOffset + (this.isFixedSize() ? 12 : 12)) == -1;
    }

    private void setEntryRemoved(int hashEntryOffset) {
        this.memory.putInt(hashEntryOffset + (this.isFixedSize() ? 12 : 12), -1);
    }

    private int getKeyLen(int hashEntryOffset) {
        if (this.fixedKeySize > 0) {
            return this.fixedKeySize;
        }
        return this.memory.getInt(hashEntryOffset + 16);
    }

    private int getValueLen(int hashEntryOffset) {
        if (this.fixedKeySize > 0) {
            return this.fixedValueSize;
        }
        return this.memory.getInt(hashEntryOffset + 12);
    }

    private void setValueLen(int hashEntryOffset, int valueLen) {
        if (this.fixedKeySize == 0) {
            this.memory.putInt(hashEntryOffset + 12, valueLen);
        }
    }

    private int getValueLen(ByteBuffer hashEntry) {
        if (this.fixedValueSize > 0) {
            return this.fixedValueSize;
        }
        return hashEntry.getInt(12);
    }

    private int getValueReservedLen(int hashEntryOffset) {
        if (this.fixedValueSize > 0) {
            return this.fixedValueSize;
        }
        return this.memory.getInt(hashEntryOffset + 20);
    }

    private boolean compare(int memoryOffset, ByteBuffer otherHashEntry, int otherOffset, int len) {
        int p = 0;
        while (p <= len - 8) {
            if (this.memory.getLong(memoryOffset) != otherHashEntry.getLong(otherOffset)) {
                return false;
            }
            p += 8;
            memoryOffset += 8;
            otherOffset += 8;
        }
        while (p <= len - 4) {
            if (this.memory.getInt(memoryOffset) != otherHashEntry.getInt(otherOffset)) {
                return false;
            }
            p += 4;
            memoryOffset += 4;
            otherOffset += 4;
        }
        while (p <= len - 2) {
            if (this.memory.getShort(memoryOffset) != otherHashEntry.getShort(otherOffset)) {
                return false;
            }
            p += 2;
            memoryOffset += 2;
            otherOffset += 2;
        }
        while (p < len) {
            if (this.memory.get(memoryOffset) != otherHashEntry.get(otherOffset)) {
                return false;
            }
            ++p;
            ++memoryOffset;
            ++otherOffset;
        }
        return true;
    }

    private boolean compareKey(int hashEntryOffset, KeyBuffer key) {
        int blkOff = Util.entryOffData(this.isFixedSize());
        ByteBuffer buf = key.buffer();
        int p = buf.position();
        int endIdx = buf.limit();
        while (p <= endIdx - 8) {
            if (this.memory.getLong(hashEntryOffset + blkOff) != buf.getLong(p)) {
                return false;
            }
            p += 8;
            blkOff += 8;
        }
        while (p <= endIdx - 4) {
            if (this.memory.getInt(hashEntryOffset + blkOff) != buf.getInt(p)) {
                return false;
            }
            p += 4;
            blkOff += 4;
        }
        while (p <= endIdx - 2) {
            if (this.memory.getShort(hashEntryOffset + blkOff) != buf.getShort(p)) {
                return false;
            }
            p += 2;
            blkOff += 2;
        }
        while (p < endIdx) {
            if (this.memory.get(hashEntryOffset + blkOff) != buf.get(p)) {
                return false;
            }
            ++p;
            ++blkOff;
        }
        return true;
    }

    private int chunkOffset(int chunkNum) {
        return chunkNum * this.chunkFullSize;
    }

    private void resetChunk(int chunkNum) {
        int offset = this.chunkOffset(chunkNum);
        this.memory.putLong(offset + 0, this.ticker.nanos());
        this.memory.putInt(offset + 8, 0);
        this.memory.putInt(offset + 12, 0);
    }

    private void touch(int hashEntryOffset) {
        this.touchChunk(this.chunkNum(hashEntryOffset));
    }

    private int chunkNum(int hashEntryOffset) {
        return hashEntryOffset / this.chunkFullSize;
    }

    private void touchChunk(int chunkNum) {
        int offset = this.chunkOffset(chunkNum);
        this.memory.putLong(offset + 0, this.ticker.nanos());
    }

    private long lastUsed(int chunkNum) {
        int offset = this.chunkOffset(chunkNum);
        return this.memory.getLong(offset + 0);
    }

    private void entryAdded(int chunkNum, int bytes) {
        int offset = this.chunkOffset(chunkNum);
        this.memory.putInt(offset + 8, this.memory.getInt(offset + 8) + 1);
        this.memory.putInt(offset + 12, this.memory.getInt(offset + 12) + bytes);
    }

    private int entriesInChunk(int chunkNum) {
        int offset = this.chunkOffset(chunkNum);
        return this.memory.getInt(offset + 8);
    }

    private int bytesInChunk(int chunkNum) {
        int offset = this.chunkOffset(chunkNum);
        return this.memory.getInt(offset + 12);
    }

    private int nextHashEntryOffset(int off) {
        int allocLen = Util.allocLen(this.getKeyLen(off), this.getValueReservedLen(off), this.isFixedSize());
        return off + allocLen;
    }

    private boolean isFixedSize() {
        return this.fixedKeySize > 0;
    }

    private boolean lock() {
        if (this.unlocked) {
            return false;
        }
        long t = Thread.currentThread().getId();
        if (t == lockFieldUpdater.get(this)) {
            return false;
        }
        while (!lockFieldUpdater.compareAndSet(this, 0L, t)) {
            Thread.yield();
        }
        return true;
    }

    private void unlock(boolean wasFirst) {
        if (this.unlocked || !wasFirst) {
            return;
        }
        long t = Thread.currentThread().getId();
        boolean r = lockFieldUpdater.compareAndSet(this, t, 0L);
        assert (r);
    }

    private final class ChunkSnapshotIterator
    extends AbstractIterator<ByteBuffer> {
        private final int entries;
        private final int limit;
        private final ByteBuffer snaphotBuffer;
        private int n;
        private int pos;

        ChunkSnapshotIterator(int limit, ByteBuffer snaphotBuffer) {
            this.snaphotBuffer = snaphotBuffer;
            this.limit = limit;
            this.entries = snaphotBuffer.getInt(8);
            this.pos = 16;
        }

        protected ByteBuffer computeNext() {
            int keyOff;
            int keyLen;
            boolean removed;
            do {
                int reservedLen;
                if (this.n == this.entries || this.n == this.limit) {
                    return (ByteBuffer)this.endOfData();
                }
                this.snaphotBuffer.clear();
                if (OffHeapChunkedMap.this.isFixedSize()) {
                    keyLen = OffHeapChunkedMap.this.fixedKeySize;
                    reservedLen = OffHeapChunkedMap.this.fixedValueSize;
                    removed = this.snaphotBuffer.getInt(this.pos + 12) == -1;
                } else {
                    keyLen = this.snaphotBuffer.getInt(this.pos + 16);
                    removed = this.snaphotBuffer.getInt(this.pos + 12) == -1;
                    reservedLen = this.snaphotBuffer.getInt(this.pos + 20);
                }
                keyOff = this.pos + Util.entryOffData(OffHeapChunkedMap.this.isFixedSize());
                this.pos += Util.allocLen(keyLen, reservedLen, OffHeapChunkedMap.this.isFixedSize());
                ++this.n;
            } while (removed);
            this.snaphotBuffer.position(keyOff);
            this.snaphotBuffer.limit(keyOff + keyLen);
            return this.snaphotBuffer;
        }
    }

    private final class Table {
        final int mask;
        final ByteBuffer table;
        private boolean released;
        static final int BUCKET_ENTRY_LEN = 4;

        private Table(ByteBuffer table, int hashTableSize) {
            this.table = table;
            this.mask = hashTableSize - 1;
            this.clear();
        }

        void clear() {
            this.table.clear();
            while (this.table.remaining() > 8) {
                this.table.putLong(0L);
            }
            while (this.table.remaining() > 0) {
                this.table.put((byte)0);
            }
        }

        void release() {
            Uns.free(this.table);
            this.released = true;
        }

        protected void finalize() throws Throwable {
            if (!this.released) {
                Uns.free(this.table);
            }
            super.finalize();
        }

        int getFirst(long hash) {
            return this.table.getInt(this.bucketOffset(hash));
        }

        void setFirst(long hash, int hashEntryOffset) {
            this.table.putInt(this.bucketOffset(hash), hashEntryOffset);
        }

        private int bucketOffset(long hash) {
            return this.bucketIndexForHash(hash) * 4;
        }

        private int bucketIndexForHash(long hash) {
            return (int)(hash & (long)this.mask);
        }

        void removeLink(long hash, int hashEntryOffset, int prevEntryOffset) {
            int next = OffHeapChunkedMap.this.getNext(hashEntryOffset);
            int head = this.getFirst(hash);
            if (head == hashEntryOffset) {
                this.setFirst(hash, next);
            } else if (prevEntryOffset != 0) {
                if (prevEntryOffset == -1) {
                    int offset = head;
                    while ((long)offset != 0L && offset != hashEntryOffset) {
                        prevEntryOffset = offset;
                        offset = OffHeapChunkedMap.this.getNext(offset);
                    }
                }
                OffHeapChunkedMap.this.setNext(prevEntryOffset, next);
            }
        }

        void addAsHead(long hash, int hashEntryOffset) {
            int head = this.getFirst(hash);
            OffHeapChunkedMap.this.setNext(hashEntryOffset, head);
            this.setFirst(hash, hashEntryOffset);
        }

        int size() {
            return this.mask + 1;
        }

        void updateBucketHistogram(EstimatedHistogram h) {
            for (int i = 0; i < this.size(); ++i) {
                int len = 0;
                int off = this.getFirst(i);
                while ((long)off != 0L) {
                    ++len;
                    off = OffHeapChunkedMap.this.getNext(off);
                }
                h.add(len + 1);
            }
        }
    }
}

