/*
 * Decompiled with CFR 0.152.
 */
package org.caffinitas.ohc.chunked;

import com.google.common.primitives.Ints;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.caffinitas.ohc.CacheLoader;
import org.caffinitas.ohc.CacheSerializer;
import org.caffinitas.ohc.CloseableIterator;
import org.caffinitas.ohc.DirectValueAccess;
import org.caffinitas.ohc.Eviction;
import org.caffinitas.ohc.OHCache;
import org.caffinitas.ohc.OHCacheBuilder;
import org.caffinitas.ohc.OHCacheStats;
import org.caffinitas.ohc.chunked.Hasher;
import org.caffinitas.ohc.chunked.KeyBuffer;
import org.caffinitas.ohc.chunked.OffHeapChunkedMap;
import org.caffinitas.ohc.chunked.Uns;
import org.caffinitas.ohc.chunked.Util;
import org.caffinitas.ohc.histo.EstimatedHistogram;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class OHCacheChunkedImpl<K, V>
implements OHCache<K, V> {
    private static final Logger LOGGER = LoggerFactory.getLogger(OHCacheChunkedImpl.class);
    private final CacheSerializer<K> keySerializer;
    private final CacheSerializer<V> valueSerializer;
    private final OffHeapChunkedMap[] maps;
    private final long segmentMask;
    private final int segmentShift;
    private final int maxEntrySize;
    private final int fixedKeySize;
    private final int fixedValueSize;
    private final int chunkSize;
    private long capacity;
    private volatile long putFailCount;
    private final Hasher hasher;

    public OHCacheChunkedImpl(OHCacheBuilder<K, V> builder) {
        long capacity = builder.getCapacity();
        if (capacity <= 0L) {
            throw new IllegalArgumentException("capacity:" + capacity);
        }
        if (Eviction.LRU != builder.getEviction()) {
            throw new IllegalArgumentException("Chunked implementation only available with LRU");
        }
        int segments = builder.getSegmentCount();
        if (segments <= 0) {
            segments = Math.min(16, Runtime.getRuntime().availableProcessors() * 2);
        }
        segments = Ints.checkedCast((long)Util.roundUpToPowerOf2(segments, 0x40000000L));
        this.chunkSize = builder.getChunkSize();
        if (this.chunkSize < 0 || (long)this.chunkSize > capacity / (long)segments / 2L) {
            throw new IllegalArgumentException("chunkSize:" + this.chunkSize);
        }
        this.fixedKeySize = Math.max(builder.getFixedKeySize(), 0);
        this.fixedValueSize = Math.max(builder.getFixedValueSize(), 0);
        if (!(this.fixedKeySize <= 0 && this.fixedValueSize <= 0 || this.fixedKeySize > 0 && this.fixedValueSize > 0)) {
            throw new IllegalArgumentException("fixedKeySize:" + this.fixedKeySize + ",fixedValueSize:" + this.fixedValueSize);
        }
        this.capacity = capacity;
        this.hasher = Hasher.create(builder.getHashAlgorighm());
        if (builder.getDefaultTTLmillis() > 0L) {
            throw new IllegalArgumentException("chunked implementation does not support expiring entries");
        }
        this.maps = new OffHeapChunkedMap[segments];
        for (int i = 0; i < segments; ++i) {
            try {
                this.maps[i] = new OffHeapChunkedMap(builder, capacity / (long)segments, this.chunkSize);
                continue;
            }
            catch (RuntimeException e) {
                while (i >= 0) {
                    if (this.maps[i] != null) {
                        this.maps[i].release();
                    }
                    --i;
                }
                throw e;
            }
        }
        int bitNum = Util.bitNum(segments) - 1;
        this.segmentShift = 64 - bitNum;
        this.segmentMask = (long)segments - 1L << this.segmentShift;
        long maxEntrySize = builder.getMaxEntrySize();
        if (maxEntrySize > capacity / (long)segments) {
            throw new IllegalArgumentException("Illegal max entry size " + maxEntrySize);
        }
        if (maxEntrySize <= 0L) {
            maxEntrySize = capacity / (long)segments;
        }
        this.maxEntrySize = (int)maxEntrySize;
        this.keySerializer = builder.getKeySerializer();
        if (this.keySerializer == null) {
            throw new NullPointerException("keySerializer == null");
        }
        this.valueSerializer = builder.getValueSerializer();
        if (this.valueSerializer == null) {
            throw new NullPointerException("valueSerializer == null");
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("OHC chunked instance with {} segments and capacity of {} created.", (Object)segments, (Object)capacity);
        }
    }

    private static UnsupportedOperationException unsupportedOp() {
        return new UnsupportedOperationException("Keeping external references to off-heap entries not supported");
    }

    @Override
    public DirectValueAccess getDirect(K key) {
        return this.getDirect(key, true);
    }

    @Override
    public DirectValueAccess getDirect(K key, boolean updateLRU) {
        throw OHCacheChunkedImpl.unsupportedOp();
    }

    @Override
    public V get(K key) {
        if (key == null) {
            throw new NullPointerException();
        }
        KeyBuffer keySource = this.keySource(key);
        OffHeapChunkedMap seg = this.segment(keySource.hash());
        return (V)seg.getEntry(keySource, this.valueSerializer);
    }

    @Override
    public boolean containsKey(K key) {
        if (key == null) {
            throw new NullPointerException();
        }
        KeyBuffer keySource = this.keySource(key);
        return this.segment(keySource.hash()).getEntry(keySource, null) == Boolean.TRUE;
    }

    @Override
    public boolean put(K key, V value) {
        return this.putInternal(key, value, false, null, Long.MAX_VALUE);
    }

    @Override
    public boolean put(K key, V value, long expireAt) {
        return this.putInternal(key, value, false, null, expireAt);
    }

    @Override
    public boolean addOrReplace(K key, V old, V value) {
        return this.putInternal(key, value, false, old, Long.MAX_VALUE);
    }

    @Override
    public boolean addOrReplace(K key, V old, V value, long expireAt) {
        return this.putInternal(key, value, false, old, expireAt);
    }

    @Override
    public boolean putIfAbsent(K key, V value) {
        return this.putInternal(key, value, true, null, Long.MAX_VALUE);
    }

    @Override
    public boolean putIfAbsent(K key, V value, long expireAt) {
        return this.putInternal(key, value, true, null, expireAt);
    }

    private boolean putInternal(K k, V v, boolean ifAbsent, V old, long expireAt) {
        if (expireAt != Long.MAX_VALUE) {
            throw new IllegalArgumentException("chunked implementation does not support expiring entries");
        }
        if (k == null || v == null) {
            throw new NullPointerException();
        }
        if (this.isFixedSize()) {
            return this.putInternalFixed(k, v, ifAbsent, old);
        }
        return this.putInternalVariable(k, v, ifAbsent, old);
    }

    private boolean putInternalFixed(K k, V v, boolean ifAbsent, V old) {
        int bytes;
        int keyLen = this.fixedKeySize;
        int valueLen = this.fixedValueSize;
        int entryBytes = bytes = Util.allocLen(keyLen, valueLen, this.isFixedSize());
        int oldValueLen = 0;
        if (old != null) {
            oldValueLen = valueLen;
            bytes += oldValueLen;
        }
        ByteBuffer hashEntry = ByteBuffer.allocate(bytes);
        hashEntry.position(Util.entryOffData(this.isFixedSize()));
        this.keySerializer.serialize(k, hashEntry);
        this.fillUntil(hashEntry, Util.entryOffData(this.isFixedSize()) + keyLen);
        this.valueSerializer.serialize(v, hashEntry);
        this.fillUntil(hashEntry, Util.entryOffData(this.isFixedSize()) + keyLen + valueLen);
        if (old != null) {
            this.valueSerializer.serialize(old, hashEntry);
            this.fillUntil(hashEntry, Util.entryOffData(this.isFixedSize()) + keyLen + valueLen * 2);
        }
        hashEntry.position(Util.entryOffData(this.isFixedSize()));
        hashEntry.limit(Util.entryOffData(this.isFixedSize()) + keyLen);
        long hash = this.hasher.hash(hashEntry);
        hashEntry.position(0);
        hashEntry.limit(bytes);
        this.initEntry(hash, keyLen, valueLen, hashEntry);
        return this.segment(hash).putEntry(hashEntry, hash, keyLen, entryBytes, ifAbsent, oldValueLen);
    }

    private boolean putInternalVariable(K k, V v, boolean ifAbsent, V old) {
        int sz = Util.entryOffData(this.isFixedSize()) + (this.isFixedSize() ? this.fixedKeySize + this.fixedValueSize + (old != null ? this.fixedValueSize : 0) : this.keySize(k) + this.valueSize(v) + (old != null ? this.valueSize(old) : 0));
        ByteBuffer hashEntry = ByteBuffer.allocate(sz);
        hashEntry.position(Util.entryOffData(this.isFixedSize()));
        this.keySerializer.serialize(k, hashEntry);
        int keyLen = hashEntry.position() - Util.entryOffData(this.isFixedSize());
        this.valueSerializer.serialize(v, hashEntry);
        int valueLen = hashEntry.position() - keyLen - Util.entryOffData(this.isFixedSize());
        int entryBytes = hashEntry.position();
        if ((long)this.maxEntrySize > 0L && entryBytes > this.maxEntrySize) {
            this.remove(k);
            return false;
        }
        int oldValueLen = 0;
        if (old != null) {
            this.valueSerializer.serialize(old, hashEntry);
            oldValueLen = hashEntry.position() - entryBytes;
        }
        int bytes = hashEntry.position();
        hashEntry.position(Util.entryOffData(this.isFixedSize()));
        hashEntry.limit(Util.entryOffData(this.isFixedSize()) + keyLen);
        long hash = this.hasher.hash(hashEntry);
        hashEntry.position(0);
        hashEntry.limit(bytes);
        this.initEntry(hash, keyLen, valueLen, hashEntry);
        return this.segment(hash).putEntry(hashEntry, hash, keyLen, entryBytes, ifAbsent, oldValueLen);
    }

    private int valueSize(V v) {
        int sz = this.valueSerializer.serializedSize(v);
        if (sz <= 0) {
            throw new IllegalArgumentException("Illegal value length " + sz);
        }
        return sz;
    }

    private int keySize(K k) {
        int sz = this.keySerializer.serializedSize(k);
        if (sz <= 0) {
            throw new IllegalArgumentException("Illegal key length " + sz);
        }
        return sz;
    }

    private boolean isFixedSize() {
        return this.fixedKeySize > 0;
    }

    @Override
    public boolean remove(K k) {
        if (k == null) {
            throw new NullPointerException();
        }
        KeyBuffer key = this.keySource(k);
        return this.segment(key.hash()).removeEntry(key);
    }

    @Override
    public V getWithLoader(K key, CacheLoader<K, V> loader) {
        throw OHCacheChunkedImpl.unsupportedOp();
    }

    @Override
    public V getWithLoader(K key, CacheLoader<K, V> loader, long timeout, TimeUnit unit) {
        throw OHCacheChunkedImpl.unsupportedOp();
    }

    @Override
    public Future<V> getWithLoaderAsync(K key, CacheLoader<K, V> loader) {
        throw OHCacheChunkedImpl.unsupportedOp();
    }

    @Override
    public Future<V> getWithLoaderAsync(K key, CacheLoader<K, V> loader, long expireAt) {
        throw OHCacheChunkedImpl.unsupportedOp();
    }

    private OffHeapChunkedMap segment(long hash) {
        int seg = (int)((hash & this.segmentMask) >>> this.segmentShift);
        return this.maps[seg];
    }

    private KeyBuffer keySource(K o) {
        int sz = this.isFixedSize() ? this.fixedKeySize : this.keySize(o);
        ByteBuffer keyBuffer = ByteBuffer.allocate(sz);
        this.keySerializer.serialize(o, keyBuffer);
        keyBuffer.flip();
        return this.keySource(keyBuffer);
    }

    private KeyBuffer keySource(ByteBuffer keyBuffer) {
        return new KeyBuffer(keyBuffer).finish(this.hasher);
    }

    private void fillUntil(ByteBuffer keyBuffer, int until) {
        while (until - keyBuffer.position() >= 8) {
            keyBuffer.putLong(0L);
        }
        while (until - keyBuffer.position() >= 4) {
            keyBuffer.putInt(0);
        }
        while (until - keyBuffer.position() > 0) {
            keyBuffer.put((byte)0);
        }
    }

    private void initEntry(long hash, int keyLen, int valueLen, ByteBuffer hashEntry) {
        hashEntry.putLong(0, hash);
        hashEntry.putInt(8, 0);
        if (this.fixedKeySize > 0) {
            return;
        }
        hashEntry.putInt(12, valueLen);
        hashEntry.putInt(16, keyLen);
        hashEntry.putInt(20, valueLen);
    }

    @Override
    public void clear() {
        for (OffHeapChunkedMap map : this.maps) {
            map.clear();
        }
    }

    @Override
    public void setCapacity(long capacity) {
        throw new UnsupportedOperationException("Changing capacity not supported");
    }

    @Override
    public void close() {
        this.clear();
        for (OffHeapChunkedMap map : this.maps) {
            map.release();
        }
        Arrays.fill(this.maps, null);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Closing OHC instance");
        }
    }

    @Override
    public void resetStatistics() {
        for (OffHeapChunkedMap map : this.maps) {
            map.resetStatistics();
        }
        this.putFailCount = 0L;
    }

    @Override
    public OHCacheStats stats() {
        long rehashes = 0L;
        for (OffHeapChunkedMap map : this.maps) {
            rehashes += map.rehashes();
        }
        return new OHCacheStats(this.hitCount(), this.missCount(), this.evictedEntries(), this.expiredEntries(), this.perSegmentSizes(), this.size(), this.capacity(), this.freeCapacity(), rehashes, this.putAddCount(), this.putReplaceCount(), this.putFailCount, this.removeCount(), Uns.getTotalAllocated(), 0L);
    }

    private long putAddCount() {
        long putAddCount = 0L;
        for (OffHeapChunkedMap map : this.maps) {
            putAddCount += map.putAddCount();
        }
        return putAddCount;
    }

    private long putReplaceCount() {
        long putReplaceCount = 0L;
        for (OffHeapChunkedMap map : this.maps) {
            putReplaceCount += map.putReplaceCount();
        }
        return putReplaceCount;
    }

    private long removeCount() {
        long removeCount = 0L;
        for (OffHeapChunkedMap map : this.maps) {
            removeCount += map.removeCount();
        }
        return removeCount;
    }

    private long hitCount() {
        long hitCount = 0L;
        for (OffHeapChunkedMap map : this.maps) {
            hitCount += map.hitCount();
        }
        return hitCount;
    }

    private long missCount() {
        long missCount = 0L;
        for (OffHeapChunkedMap map : this.maps) {
            missCount += map.missCount();
        }
        return missCount;
    }

    @Override
    public long capacity() {
        return this.capacity;
    }

    @Override
    public long freeCapacity() {
        long freeCapacity = 0L;
        for (OffHeapChunkedMap map : this.maps) {
            freeCapacity += map.freeCapacity();
        }
        return freeCapacity;
    }

    private long evictedEntries() {
        long evictedEntries = 0L;
        for (OffHeapChunkedMap map : this.maps) {
            evictedEntries += map.evictedEntries();
        }
        return evictedEntries;
    }

    private long expiredEntries() {
        long expiredEntries = 0L;
        for (OffHeapChunkedMap map : this.maps) {
            expiredEntries += map.expiredEntries();
        }
        return expiredEntries;
    }

    @Override
    public long size() {
        long size = 0L;
        for (OffHeapChunkedMap map : this.maps) {
            size += map.size();
        }
        return size;
    }

    @Override
    public int segments() {
        return this.maps.length;
    }

    @Override
    public float loadFactor() {
        return this.maps[0].loadFactor();
    }

    @Override
    public int[] hashTableSizes() {
        int[] r = new int[this.maps.length];
        for (int i = 0; i < this.maps.length; ++i) {
            r[i] = this.maps[i].hashTableSize();
        }
        return r;
    }

    @Override
    public long[] perSegmentSizes() {
        long[] r = new long[this.maps.length];
        for (int i = 0; i < this.maps.length; ++i) {
            r[i] = this.maps[i].size();
        }
        return r;
    }

    @Override
    public EstimatedHistogram getBucketHistogram() {
        int i;
        EstimatedHistogram hist = new EstimatedHistogram();
        for (OffHeapChunkedMap map : this.maps) {
            map.updateBucketHistogram(hist);
        }
        long[] offsets = hist.getBucketOffsets();
        long[] buckets = hist.getBuckets(false);
        for (i = buckets.length - 1; i > 0; --i) {
            if (buckets[i] == 0L) continue;
            offsets = Arrays.copyOf(offsets, i + 2);
            buckets = Arrays.copyOf(buckets, i + 3);
            System.arraycopy(offsets, 0, offsets, 1, i + 1);
            System.arraycopy(buckets, 0, buckets, 1, i + 2);
            offsets[0] = 0L;
            buckets[0] = 0L;
            break;
        }
        i = 0;
        while (i < offsets.length) {
            int n = i++;
            offsets[n] = offsets[n] - 1L;
        }
        return new EstimatedHistogram(offsets, buckets);
    }

    @Override
    public CloseableIterator<K> deserializeKeys(ReadableByteChannel channel) {
        throw OHCacheChunkedImpl.unsupportedOp();
    }

    @Override
    public boolean deserializeEntry(ReadableByteChannel channel) {
        throw OHCacheChunkedImpl.unsupportedOp();
    }

    @Override
    public boolean serializeEntry(K key, WritableByteChannel channel) {
        throw OHCacheChunkedImpl.unsupportedOp();
    }

    @Override
    public int deserializeEntries(ReadableByteChannel channel) {
        throw OHCacheChunkedImpl.unsupportedOp();
    }

    @Override
    public int serializeHotNEntries(int n, WritableByteChannel channel) {
        throw OHCacheChunkedImpl.unsupportedOp();
    }

    @Override
    public int serializeHotNKeys(int n, WritableByteChannel channel) {
        throw OHCacheChunkedImpl.unsupportedOp();
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> m) {
        for (Map.Entry<K, V> entry : m.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public void removeAll(Iterable<K> iterable) {
        for (K o : iterable) {
            this.remove(o);
        }
    }

    @Override
    public long memUsed() {
        return this.capacity();
    }

    @Override
    public CloseableIterator<K> hotKeyIterator(final int n) {
        return new CloseableIterator<K>(){
            private final CloseableIterator<ByteBuffer> wrapped;
            {
                this.wrapped = OHCacheChunkedImpl.this.hotKeyBufferIterator(n);
            }

            @Override
            public void close() throws IOException {
                this.wrapped.close();
            }

            @Override
            public boolean hasNext() {
                return this.wrapped.hasNext();
            }

            @Override
            public K next() {
                ByteBuffer bb = (ByteBuffer)this.wrapped.next();
                return OHCacheChunkedImpl.this.keySerializer.deserialize(bb);
            }

            @Override
            public void remove() {
                this.wrapped.remove();
            }
        };
    }

    @Override
    public CloseableIterator<ByteBuffer> hotKeyBufferIterator(int n) {
        return new SegmentIterator(n);
    }

    @Override
    public CloseableIterator<K> keyIterator() {
        return this.hotKeyIterator(Integer.MAX_VALUE);
    }

    @Override
    public CloseableIterator<ByteBuffer> keyBufferIterator() {
        return this.hotKeyBufferIterator(Integer.MAX_VALUE);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "(capacity=" + this.capacity() + " ,segments=" + this.maps.length + " ,chunkSize=" + this.chunkSize + " ,fixedKeySize=" + this.fixedKeySize + " ,fixedValueSize=" + this.fixedValueSize + " ,maxEntrySize=" + this.maxEntrySize;
    }

    private final class SegmentIterator
    implements CloseableIterator<ByteBuffer> {
        private final int keysPerChunk;
        private int seg;
        private Iterator<ByteBuffer> chunkIterator;
        private final ByteBuffer snaphotBuffer;
        private boolean eod;
        private ByteBuffer next;
        private ByteBuffer current;

        SegmentIterator(int nKeys) {
            this.keysPerChunk = nKeys / OHCacheChunkedImpl.this.segments() / OHCacheChunkedImpl.this.chunkSize + 1;
            this.snaphotBuffer = ByteBuffer.allocate(OHCacheChunkedImpl.this.chunkSize + 16);
        }

        @Override
        public void close() {
        }

        @Override
        public boolean hasNext() {
            if (this.eod) {
                return false;
            }
            if (this.next == null) {
                this.next = this.computeNext();
            }
            return this.next != null;
        }

        @Override
        public ByteBuffer next() {
            ByteBuffer r;
            if (this.eod) {
                throw new NoSuchElementException();
            }
            if (this.next == null) {
                r = this.computeNext();
            } else {
                r = this.next;
                this.next = null;
            }
            if (!this.eod && r != null) {
                this.current = r;
                return r.duplicate();
            }
            throw new NoSuchElementException();
        }

        @Override
        public void remove() {
            ByteBuffer c = this.current;
            if (this.eod || c == null) {
                throw new NoSuchElementException();
            }
            this.current = null;
            OHCacheChunkedImpl.this.maps[this.seg - 1].removeEntry(OHCacheChunkedImpl.this.keySource(c));
        }

        private ByteBuffer computeNext() {
            while (this.chunkIterator == null || !this.chunkIterator.hasNext()) {
                if (this.seg == OHCacheChunkedImpl.this.segments()) {
                    this.eod = true;
                    this.current = null;
                    return null;
                }
                this.chunkIterator = OHCacheChunkedImpl.this.maps[this.seg++].snapshotIterator(this.keysPerChunk, this.snaphotBuffer);
            }
            return this.chunkIterator.next();
        }
    }
}

