/*
 * Decompiled with CFR 0.152.
 */
package io.mxnet.caffetranslator.misc;

import io.mxnet.caffetranslator.CaffePrototxtBaseListener;
import io.mxnet.caffetranslator.CaffePrototxtParser;
import io.mxnet.caffetranslator.ParserHelper;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.TreeMap;
import java.util.TreeSet;

public class StatsListener
extends CaffePrototxtBaseListener {
    private final Stack<String> keys;
    private final Map<String, Set<String>> attrMap = new TreeMap<String, Set<String>>();
    private final ParserHelper parserHelper;
    private String layerType;
    private Set<String> curAttr;

    public StatsListener() {
        this.keys = new Stack();
        this.parserHelper = new ParserHelper();
    }

    @Override
    public void enterLayer(CaffePrototxtParser.LayerContext ctx) {
        this.keys.clear();
        this.curAttr = new TreeSet<String>();
    }

    @Override
    public void exitLayer(CaffePrototxtParser.LayerContext ctx) {
        if (!this.attrMap.containsKey(this.layerType)) {
            this.attrMap.put(this.layerType, new TreeSet());
        }
        Set<String> set = this.attrMap.get(this.layerType);
        set.addAll(this.curAttr);
    }

    @Override
    public void exitValueLeaf(CaffePrototxtParser.ValueLeafContext ctx) {
        String value = ctx.getText();
        value = this.parserHelper.removeQuotes(value);
        this.processKeyValue(this.getCurrentKey(), value);
    }

    private void processKeyValue(String key, String value) {
        if (key.equals("type")) {
            this.layerType = value;
        } else {
            this.curAttr.add(key);
        }
    }

    @Override
    public void enterPair(CaffePrototxtParser.PairContext ctx) {
        String key = ctx.getStart().getText();
        this.keys.push(key);
    }

    @Override
    public void exitPair(CaffePrototxtParser.PairContext ctx) {
        this.keys.pop();
    }

    private String getCurrentKey() {
        StringBuilder sb = new StringBuilder();
        for (String s : this.keys) {
            sb.append(s + ".");
        }
        return sb.substring(0, sb.length() - 1).toString();
    }

    public Map<String, Set<String>> getAttrMap() {
        return this.attrMap;
    }
}

