/*
 * Decompiled with CFR 0.152.
 */
package io.mxnet.caffetranslator.generators;

import io.mxnet.caffetranslator.GeneratorOutput;
import io.mxnet.caffetranslator.Layer;
import io.mxnet.caffetranslator.MLModel;
import io.mxnet.caffetranslator.generators.BaseGenerator;
import io.mxnet.caffetranslator.generators.PluginIntLayerGenerator;

public class ScaleGenerator
extends BaseGenerator {
    @Override
    public GeneratorOutput generate(Layer layer, MLModel model) {
        PluginIntLayerGenerator generator = new PluginIntLayerGenerator();
        boolean use_bias = layer.getAttr("scale_param.bias_term", "false").toLowerCase().equals("true");
        StringBuilder out = new StringBuilder();
        if (use_bias) {
            out.append(generator.generate((Layer)layer, (MLModel)model, (int)2).code);
        } else {
            out.append(generator.generate((Layer)layer, (MLModel)model, (int)1).code);
        }
        String fillerType = layer.getAttr("filler.type");
        String fillerValue = layer.getAttr("filler.value");
        if (fillerType == null && fillerValue == null) {
            fillerValue = "1";
        }
        out.append(this.gh.initializeParam(this.gh.getVarname(layer.getTop()), 1, this.gh.getInit(fillerType, fillerValue)));
        if (use_bias) {
            fillerType = layer.getAttr("bias_filler.type");
            fillerValue = layer.getAttr("bias_filler.value");
            if (fillerType == null && fillerValue == null) {
                fillerValue = "0";
            }
            out.append(this.gh.initializeParam(this.gh.getVarname(layer.getTop()), 2, this.gh.getInit(fillerType, fillerValue)));
        }
        return this.gh.makeGeneratorOutput(out.toString(), 1);
    }
}

