/*
 * Decompiled with CFR 0.152.
 */
package io.mxnet.caffetranslator.generators;

import io.mxnet.caffetranslator.GeneratorOutput;
import io.mxnet.caffetranslator.Layer;
import io.mxnet.caffetranslator.MLModel;
import io.mxnet.caffetranslator.generators.BaseGenerator;
import org.stringtemplate.v4.ST;

public class PoolingGenerator
extends BaseGenerator {
    @Override
    public GeneratorOutput generate(Layer layer, MLModel model) {
        String poolType;
        ST st = this.getTemplate("pooling");
        this.gh.fillNameDataAndVar(st, layer);
        boolean globalPooling = layer.getAttr("pooling_param.global_pooling", "false").toLowerCase().equals("true");
        if (globalPooling) {
            st.add("global_pool", "True");
            st.add("kernel_h", "1");
            st.add("kernel_w", "1");
        } else {
            this.gh.simpleFillTemplate(st, "kernel_h", layer, "pooling_param.kernel_h", null, "pooling_param.kernel_size");
            this.gh.simpleFillTemplate(st, "kernel_w", layer, "pooling_param.kernel_w", null, "pooling_param.kernel_size");
        }
        this.gh.simpleFillTemplate(st, "stride_h", layer, "pooling_param.stride_h", "1", "pooling_param.stride");
        this.gh.simpleFillTemplate(st, "stride_w", layer, "pooling_param.stride_w", "1", "pooling_param.stride");
        this.gh.simpleFillTemplate(st, "pad_h", layer, "pooling_param.pad_h", "0", "pooling_param.pad");
        this.gh.simpleFillTemplate(st, "pad_w", layer, "pooling_param.pad_w", "0", "pooling_param.pad");
        switch (poolType = layer.getAttr("pooling_param.pool")) {
            case "MAX": {
                st.add("type", "max");
                break;
            }
            case "AVE": {
                st.remove("type");
                st.add("type", "avg");
                break;
            }
            case "STOCHASTIC": {
                System.err.println("Stochastic pooling type not supported.");
                st.add("type", "???");
            }
        }
        return new GeneratorOutput(st.render(), 1);
    }
}

