/*
 * Decompiled with CFR 0.152.
 */
package io.mxnet.caffetranslator.generators;

import io.mxnet.caffetranslator.GeneratorOutput;
import io.mxnet.caffetranslator.Layer;
import io.mxnet.caffetranslator.MLModel;
import io.mxnet.caffetranslator.generators.BaseGenerator;
import io.mxnet.caffetranslator.generators.PluginLayerHelper;
import org.stringtemplate.v4.ST;

public class PluginIntLayerGenerator
extends BaseGenerator {
    private PluginLayerHelper helper = new PluginLayerHelper();

    @Override
    public GeneratorOutput generate(Layer layer, MLModel model) {
        return this.generate(layer, model, 0);
    }

    public GeneratorOutput generate(Layer layer, MLModel model, int num_weight) {
        ST st = this.getTemplate("CaffePluginIntLayer");
        st.add("name", layer.getName());
        if (layer.getBottoms().size() != 1) {
            st.add("num_data", layer.getBottoms().size());
        }
        if (layer.getTops().size() != 1) {
            st.add("num_out", layer.getTops().size());
        }
        if (num_weight != 0) {
            st.add("num_weight", num_weight);
        }
        String dataList = this.helper.getDataList(layer);
        st.add("data", dataList);
        String prototxt = this.helper.makeOneLine(layer.getPrototxt());
        st.add("prototxt", prototxt);
        if (layer.getTops().size() > 1) {
            st.add("tops", layer.getTops());
            st.add("var", "out");
        } else if (layer.getTops().size() == 1) {
            st.add("var", this.gh.getVarname(layer.getTop()));
        }
        return new GeneratorOutput(st.render(), 1);
    }
}

