/*
 * Decompiled with CFR 0.152.
 */
package io.mxnet.caffetranslator.generators;

import io.mxnet.caffetranslator.GeneratorOutput;
import io.mxnet.caffetranslator.Layer;
import io.mxnet.caffetranslator.MLModel;
import io.mxnet.caffetranslator.generators.BaseGenerator;
import java.util.List;
import org.stringtemplate.v4.ST;

public class EltwiseGenerator
extends BaseGenerator {
    @Override
    public GeneratorOutput generate(Layer layer, MLModel model) {
        ST st;
        String operation = layer.getAttr("eltwise_param.operation");
        if (operation == null) {
            operation = "SUM";
        }
        switch (operation) {
            case "SUM": {
                st = this.getTemplate("add");
                break;
            }
            case "PROD": {
                st = this.getTemplate("mul");
                break;
            }
            case "MAX": {
                st = this.getTemplate("maximum");
                break;
            }
            default: {
                String error = "Unrecognized operation " + operation + " in Eltwise" + System.lineSeparator();
                System.err.print(error);
                return new GeneratorOutput(error, 1);
            }
        }
        st.add("name", layer.getName());
        st.add("var", this.gh.getVarname(layer.getTop()));
        List<String> data = this.gh.getVarNames(layer.getBottoms());
        st.add("data1", data.get(0));
        st.add("data2", data.get(1));
        return new GeneratorOutput(st.render(), 1);
    }
}

