/*
 * Decompiled with CFR 0.152.
 */
package io.mxnet.caffetranslator.generators;

import io.mxnet.caffetranslator.GeneratorOutput;
import io.mxnet.caffetranslator.Layer;
import io.mxnet.caffetranslator.MLModel;
import io.mxnet.caffetranslator.generators.BaseGenerator;
import java.util.Map;
import org.stringtemplate.v4.ST;

public class ConvolutionGenerator
extends BaseGenerator {
    @Override
    public GeneratorOutput generate(Layer layer, MLModel model) {
        Map<String, String> param;
        StringBuilder out = new StringBuilder();
        ST st = this.getTemplate("convolution");
        this.gh.fillNameDataAndVar(st, layer);
        this.gh.simpleFillTemplate(st, "kernel_h", layer, "convolution_param.kernel_h", null, "convolution_param.kernel_size");
        this.gh.simpleFillTemplate(st, "kernel_w", layer, "convolution_param.kernel_w", null, "convolution_param.kernel_size");
        this.gh.simpleFillTemplate(st, "stride_h", layer, "convolution_param.stride_h", "1", "convolution_param.stride");
        this.gh.simpleFillTemplate(st, "stride_w", layer, "convolution_param.stride_w", "1", "convolution_param.stride");
        this.gh.simpleFillTemplate(st, "pad_h", layer, "convolution_param.pad_h", "0", "convolution_param.pad");
        this.gh.simpleFillTemplate(st, "pad_w", layer, "convolution_param.pad_w", "0", "convolution_param.pad");
        if (layer.attrEquals("convolution_param.bias_term", "false")) {
            st.add("no_bias", "NoBiasPlease");
        }
        this.gh.simpleFillTemplate(st, "num_filter", layer, "convolution_param.num_output", null, new String[0]);
        String weightInit = this.gh.getInit(layer.getAttr("convolution_param.weight_filler.type"), layer.getAttr("convolution_param.weight_filler.value"));
        String biasInit = this.gh.getInit(layer.getAttr("convolution_param.bias_filler.type"), layer.getAttr("convolution_param.bias_filler.value"));
        if (weightInit != null || layer.getParams().size() >= 1) {
            param = layer.getParams().get(0);
            out.append(this.generateVar("weight", layer.getName() + "_weight", param.get("param.lr_mult"), param.get("param.decay_mult"), weightInit, null));
            st.add("weight", "weight");
        }
        if (biasInit != null || layer.getParams().size() >= 2) {
            param = layer.getParams().get(1);
            out.append(this.generateVar("bias", layer.getName() + "_bias", param.get("param.lr_mult"), param.get("param.decay_mult"), biasInit, null));
            st.add("bias", "bias");
        }
        out.append(st.render());
        return new GeneratorOutput(out.toString(), 1);
    }
}

