/*
 * Decompiled with CFR 0.152.
 */
package io.mxnet.caffetranslator.generators;

import io.mxnet.caffetranslator.GeneratorOutput;
import io.mxnet.caffetranslator.Layer;
import io.mxnet.caffetranslator.MLModel;
import io.mxnet.caffetranslator.generators.BaseGenerator;
import org.stringtemplate.v4.ST;

public class BatchNormGenerator
extends BaseGenerator {
    @Override
    public GeneratorOutput generate(Layer layer, MLModel model) {
        ST st = this.getTemplate("batchnorm");
        this.gh.fillNameDataAndVar(st, layer);
        if (layer.attrEquals("batch_norm_param.use_global_stats", "true")) {
            st.add("use_global_stats", true);
        }
        int layerIndex = layer.getLayerIndex();
        Layer nextLayer = model.getLayerList().get(layerIndex + 1);
        boolean nextLayerIsScale = false;
        if (nextLayer.getType().toLowerCase().equals("scale")) {
            String biasTerm;
            String axis = nextLayer.getAttr("ScaleParameter.axis", "1");
            String numAxis = nextLayer.getAttr("ScaleParameter.num_axes", "1");
            if (axis.equals("1") && numAxis.equals("1") && (biasTerm = nextLayer.getAttr("ScaleParameter.bias_term", "false")).toLowerCase().equals("false")) {
                nextLayerIsScale = true;
            }
        }
        if (!nextLayerIsScale) {
            st.add("fix_beta", true);
            st.add("fix_gamma", true);
        }
        return new GeneratorOutput(st.render(), nextLayerIsScale ? 2 : 1);
    }
}

