/*
 * Decompiled with CFR 0.152.
 */
package io.mxnet.caffetranslator.generators;

import io.mxnet.caffetranslator.GenerationHelper;
import io.mxnet.caffetranslator.Layer;
import io.mxnet.caffetranslator.MLModel;
import java.util.HashMap;
import java.util.Map;
import org.stringtemplate.v4.ST;

public class AccuracyMetricsGenerator {
    private final Map<String, String> map = new HashMap<String, String>();
    private final GenerationHelper gh = new GenerationHelper();

    public String generate(MLModel model) {
        StringBuilder out = new StringBuilder();
        this.generateMap(model);
        for (Layer layer : model.getLayerList()) {
            ST st;
            if (!layer.getType().equals("Accuracy")) continue;
            if (layer.getAttr("accuracy_param.top_k", "1").equals("1")) {
                st = this.gh.getTemplate("accuracy");
            } else {
                st = this.gh.getTemplate("top_k_accuracy");
                st.add("k", layer.getAttr("accuracy_param.top_k"));
            }
            st.add("var", this.gh.getVarname(layer.getTop()));
            String outputName = this.map.get(layer.getBottoms().get(0)) + "_output";
            st.add("output_name", outputName);
            st.add("label_name", layer.getBottoms().get(1));
            st.add("name", layer.getName());
            out.append(st.render());
            out.append(System.lineSeparator());
        }
        return out.toString();
    }

    private void generateMap(MLModel model) {
        for (Layer layer : model.getLayerList()) {
            if (!layer.getType().equals("SoftmaxWithLoss")) continue;
            this.map.put(layer.getBottoms().get(0), layer.getName());
        }
    }
}

