/*
 * Decompiled with CFR 0.152.
 */
package io.mxnet.caffetranslator;

import io.mxnet.caffetranslator.CaffePrototxtLexer;
import io.mxnet.caffetranslator.CaffePrototxtParser;
import io.mxnet.caffetranslator.SolverListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.lang.reflect.Field;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CharStreams;
import org.antlr.v4.runtime.CommonTokenStream;

public class Solver {
    private final String solverPath;
    private boolean parseDone;
    private Map<String, List<String>> properties;
    private String base_lr;
    private String momentum;
    private String weight_decay;
    private String lr_policy;
    private String gamma;
    private String stepsize;
    private String stepvalue;
    private String max_iter;
    private String solver_mode;
    private String snapshot;
    private String snapshot_prefix;
    private String test_iter;
    private String test_interval;
    private String display;
    private String type;
    private String delta;
    private String momentum2;
    private String rms_decay;
    private String solver_type;

    public Solver(String solverPath) {
        this.solverPath = solverPath;
        this.properties = new HashMap<String, List<String>>();
    }

    public boolean parsePrototxt() {
        CharStream cs = null;
        try {
            FileInputStream fis = new FileInputStream(new File(this.solverPath));
            cs = CharStreams.fromStream(fis, StandardCharsets.UTF_8);
        }
        catch (IOException e) {
            System.err.println("Unable to read prototxt " + this.solverPath);
            return false;
        }
        CaffePrototxtLexer lexer = new CaffePrototxtLexer(cs);
        CommonTokenStream tokens = new CommonTokenStream(lexer);
        CaffePrototxtParser parser = new CaffePrototxtParser(tokens);
        SolverListener solverListener = new SolverListener();
        parser.addParseListener(solverListener);
        parser.solver();
        this.properties = solverListener.getProperties();
        this.setFields(this.properties);
        this.parseDone = true;
        return true;
    }

    private void setFields(Map<String, List<String>> properties) {
        Class<?> cls = this.getClass();
        for (Map.Entry<String, List<String>> entry : properties.entrySet()) {
            String key = entry.getKey();
            try {
                Field field = cls.getDeclaredField(key);
                field.set(this, entry.getValue().get(0));
            }
            catch (NoSuchFieldException field) {
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
        this.setDefaults();
    }

    private void setDefaults() {
        if (this.type == null) {
            this.type = "SGD";
        }
        if (this.delta == null) {
            this.delta = "1e-8";
        }
        if (this.momentum2 == null) {
            this.momentum2 = "0.999";
        }
        if (this.rms_decay == null) {
            this.rms_decay = "0.99";
        }
    }

    public String getProperty(String key) {
        List<String> list = this.getProperties(key);
        if (list == null) {
            return null;
        }
        return this.getProperties(key).get(0);
    }

    public List<String> getProperties(String key) {
        if (!this.parseDone) {
            this.parsePrototxt();
        }
        return this.properties.get(key);
    }

    public String getProperty(String key, String defaultValue) {
        String value = this.getProperty(key);
        if (value == null) {
            return defaultValue;
        }
        return value;
    }

    public String getBase_lr() {
        return this.base_lr;
    }

    public String getMomentum() {
        return this.momentum;
    }

    public String getWeight_decay() {
        return this.weight_decay;
    }

    public String getLr_policy() {
        return this.lr_policy;
    }

    public String getGamma() {
        return this.gamma;
    }

    public String getStepsize() {
        return this.stepsize;
    }

    public String getStepvalue() {
        return this.stepvalue;
    }

    public String getMax_iter() {
        return this.max_iter;
    }

    public String getSolver_mode() {
        return this.solver_mode;
    }

    public String getSnapshot() {
        return this.snapshot;
    }

    public String getSnapshot_prefix() {
        return this.snapshot_prefix;
    }

    public String getTest_iter() {
        return this.test_iter;
    }

    public String getTest_interval() {
        return this.test_interval;
    }

    public String getDisplay() {
        return this.display;
    }

    public String getType() {
        return this.type;
    }

    public String getDelta() {
        return this.delta;
    }

    public String getMomentum2() {
        return this.momentum2;
    }

    public String getRms_decay() {
        return this.rms_decay;
    }

    public String getSolver_type() {
        return this.solver_type;
    }
}

