/*
 * Decompiled with CFR 0.152.
 */
package io.mxnet.caffetranslator;

import io.mxnet.caffetranslator.Config;
import io.mxnet.caffetranslator.Layer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class MLModel {
    private String name;
    private List<Layer> layerList = new ArrayList<Layer>();
    private final Map<String, Map<String, Layer>> layerLookup = new HashMap<String, Map<String, Layer>>();
    private int layerIndex = 0;

    public void addLayer(Layer layer) {
        layer.setLayerIndex(this.layerIndex++);
        this.layerList.add(layer);
        String name = layer.getName();
        String includePhase = layer.getAttr("include.phase");
        String string = includePhase = includePhase == null ? "" : includePhase;
        if (this.layerLookup.containsKey(name)) {
            this.layerLookup.get(name).put(includePhase, layer);
        } else {
            HashMap<String, Layer> map = new HashMap<String, Layer>();
            map.put(includePhase, layer);
            this.layerLookup.put(name, map);
        }
        String type = layer.getAttr("type");
        Config config = Config.getInstance();
        if (type.equals("Data") || config.getCustomDataLayers().contains(type)) {
            layer.setKind(Layer.Kind.DATA);
        } else if (type.toLowerCase().endsWith("loss")) {
            layer.setKind(Layer.Kind.LOSS);
        } else {
            layer.setKind(Layer.Kind.INTERMEDIATE);
        }
    }

    public List<Layer> getDataLayers() {
        ArrayList<Layer> ret = new ArrayList<Layer>();
        for (Layer layer : this.layerList) {
            if (layer.getKind() != Layer.Kind.DATA) continue;
            ret.add(layer);
        }
        return ret;
    }

    public List<Layer> getNonDataLayers() {
        ArrayList<Layer> ret = new ArrayList<Layer>();
        for (Layer layer : this.layerList) {
            if (layer.getKind() == Layer.Kind.DATA) continue;
            ret.add(layer);
        }
        return ret;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public List<Layer> getLayerList() {
        return this.layerList;
    }

    public void setLayerList(List<Layer> layerList) {
        this.layerList = layerList;
    }
}

