/*
 * Decompiled with CFR 0.152.
 */
package io.mxnet.caffetranslator;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Layer {
    private String name;
    private int layerIndex;
    private Kind kind;
    private String prototxt;
    private final List<String> bottoms;
    private final List<String> tops = new ArrayList<String>();
    private List<Map<String, String>> params;
    private Map<String, List<String>> attr;

    public Layer() {
        this.bottoms = new ArrayList<String>();
        this.attr = new HashMap<String, List<String>>();
        this.params = new ArrayList<Map<String, String>>();
    }

    public Layer(int layerIndex) {
        this();
        this.layerIndex = layerIndex;
    }

    public void addAttr(String key, String value) {
        List<String> list = this.attr.get(key);
        if (list == null) {
            list = new ArrayList<String>();
            list.add(value);
            this.attr.put(key, list);
        } else {
            list.add(value);
        }
    }

    public String getAttr(String key) {
        List<String> list = this.attr.get(key);
        if (list == null) {
            return null;
        }
        return list.get(0);
    }

    public String getAttr(String key, String defaultValue) {
        String attr = this.getAttr(key);
        return attr != null ? attr : defaultValue;
    }

    public boolean hasAttr(String key) {
        return this.attr.containsKey(key);
    }

    public boolean attrEquals(String key, String value) {
        if (!this.attr.containsKey(key)) {
            return false;
        }
        return this.getAttr(key).equals(value);
    }

    public List<String> getAttrList(String key) {
        return this.attr.get(key);
    }

    public void addTop(String top) {
        this.tops.add(top);
    }

    public void addBottom(String bottom) {
        this.bottoms.add(bottom);
    }

    public String getBottom() {
        return this.bottoms.size() > 0 ? this.bottoms.get(0) : null;
    }

    public String getType() {
        return this.attr.get("type").get(0);
    }

    public String getTop() {
        return this.tops.size() > 0 ? this.tops.get(0) : null;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public int getLayerIndex() {
        return this.layerIndex;
    }

    public void setLayerIndex(int layerIndex) {
        this.layerIndex = layerIndex;
    }

    public Kind getKind() {
        return this.kind;
    }

    public void setKind(Kind kind) {
        this.kind = kind;
    }

    public String getPrototxt() {
        return this.prototxt;
    }

    public void setPrototxt(String prototxt) {
        this.prototxt = prototxt;
    }

    public List<String> getBottoms() {
        return this.bottoms;
    }

    public List<String> getTops() {
        return this.tops;
    }

    public void setParams(List<Map<String, String>> params) {
        this.params = params;
    }

    public List<Map<String, String>> getParams() {
        return this.params;
    }

    public void setAttr(Map<String, List<String>> attr) {
        this.attr = attr;
    }

    public static enum Kind {
        DATA,
        INTERMEDIATE,
        LOSS;

    }
}

