/*
 * Decompiled with CFR 0.152.
 */
package io.mxnet.caffetranslator;

import io.mxnet.caffetranslator.Config;
import io.mxnet.caffetranslator.Converter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.PrintWriter;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;

public class Launcher {
    private String trainingPrototextPath;
    private String solverPrototextPath;
    private String paramsFilePath;
    private File outFile;
    protected final String TRAINING_PROTOTXT = "training-prototxt";
    protected final String SOLVER_PROTOTXT = "solver";
    protected final String CUSTOM_DATA_LAYERS = "custom-data-layers";
    protected final String OUTPUT_FILE = "output-file";
    protected final String PARAMS_FILE = "params-file";
    protected final String GRAPH_FILE = "graph-file";

    public static void main(String[] args) {
        Launcher launcher = new Launcher();
        launcher.run(args);
    }

    public void run(String[] args) {
        this.parseCommandLine(args);
        Converter converter = new Converter(this.trainingPrototextPath, this.solverPrototextPath);
        if (this.paramsFilePath != null) {
            converter.setParamsFilePath(this.paramsFilePath);
        }
        String code = converter.generateMXNetCode();
        this.writeToOutFile(code);
        System.out.println("Translated code saved in " + this.outFile.getAbsolutePath());
    }

    private void writeToOutFile(String code) {
        PrintWriter out;
        try {
            out = new PrintWriter(this.outFile);
        }
        catch (FileNotFoundException e) {
            System.err.println(String.format("Unable to open %s for writing", this.outFile.getAbsoluteFile()));
            return;
        }
        out.print(code);
        out.flush();
    }

    public void parseCommandLine(String[] args) {
        String strOutFile;
        DefaultParser clParser = new DefaultParser();
        Options options = new Options();
        Option prototxtOption = Option.builder("t").longOpt("training-prototxt").hasArg().desc("training/validation prototxt").build();
        options.addOption(prototxtOption);
        Option solverOption = Option.builder("s").longOpt("solver").hasArg().desc("solver prototxt").build();
        options.addOption(solverOption);
        Option dataLayerOpt = Option.builder("c").longOpt("custom-data-layers").hasArg().desc("Comma separated custom data layers").build();
        options.addOption(dataLayerOpt);
        Option outfileOpt = Option.builder("o").longOpt("output-file").hasArg().desc("Output file").build();
        options.addOption(outfileOpt);
        Option paramsFileOpt = Option.builder("p").longOpt("params-file").hasArg().desc("Params file").build();
        options.addOption(paramsFileOpt);
        Option graphFileOpt = Option.builder("g").longOpt("graph-file").hasArg().desc("Image file to visualize computation graph").build();
        options.addOption(graphFileOpt);
        CommandLine line = null;
        try {
            line = clParser.parse(options, args);
        }
        catch (ParseException e) {
            System.out.println("Exception parsing commandline:" + e.getMessage());
            System.exit(1);
        }
        this.trainingPrototextPath = this.getOption(line, "training-prototxt");
        if (this.trainingPrototextPath == null) {
            this.bail("Command line argument training-prototxt missing");
        }
        if ((this.solverPrototextPath = this.getOption(line, "solver")) == null) {
            this.bail("Command line argument solver missing");
        }
        if ((strOutFile = this.getOption(line, "output-file")) == null) {
            this.bail("Command line argument output-file missing");
        }
        this.outFile = new File(strOutFile);
        this.paramsFilePath = this.getOption(line, "params-file");
        Config config = Config.getInstance();
        String dataLayers = this.getOption(line, "custom-data-layers");
        if (dataLayers != null) {
            for (String name : dataLayers.split(",")) {
                name = name.trim();
                config.addCustomDataLayer(name);
            }
        }
    }

    private String getOption(CommandLine line, String argName) {
        if (line.hasOption(argName)) {
            return line.getOptionValue(argName);
        }
        return null;
    }

    private void bail(String reason) {
        System.err.println(reason);
        System.exit(1);
    }
}

