/*
 * Decompiled with CFR 0.152.
 */
package io.mxnet.caffetranslator;

import io.mxnet.caffetranslator.CaffePrototxtBaseListener;
import io.mxnet.caffetranslator.CaffePrototxtParser;
import io.mxnet.caffetranslator.Layer;
import io.mxnet.caffetranslator.MLModel;
import io.mxnet.caffetranslator.ParserHelper;
import java.util.HashMap;
import java.util.Map;
import java.util.Stack;
import org.antlr.v4.runtime.Token;
import org.antlr.v4.runtime.TokenStream;

public class CreateModelListener
extends CaffePrototxtBaseListener {
    private final CaffePrototxtParser parser;
    private final MLModel mlModel;
    private final Stack<String> keys;
    private final ParserHelper parserHelper;
    private Layer currentLayer;
    private Map<String, String> currentParams;

    public CreateModelListener(CaffePrototxtParser parser, MLModel mlModel) {
        this.parser = parser;
        this.mlModel = mlModel;
        this.keys = new Stack();
        this.currentParams = new HashMap<String, String>();
        this.parserHelper = new ParserHelper();
    }

    @Override
    public void exitName(CaffePrototxtParser.NameContext ctx) {
        String name = ctx.STRING().toString();
        this.mlModel.setName(this.parserHelper.removeQuotes(name));
    }

    @Override
    public void enterLayer(CaffePrototxtParser.LayerContext ctx) {
        this.keys.clear();
        this.currentLayer = new Layer();
    }

    @Override
    public void exitLayer(CaffePrototxtParser.LayerContext ctx) {
        TokenStream tokens = this.parser.getTokenStream();
        String prototxt = this.getPrototxt(tokens, ctx.getStart().getTokenIndex(), ctx.getStop().getTokenIndex());
        if (this.currentLayer.getTops().size() == 1) {
            this.currentLayer.addAttr("top", this.currentLayer.getTops().get(0));
        }
        if (this.currentLayer.getBottoms().size() == 1) {
            this.currentLayer.addAttr("bottom", this.currentLayer.getBottoms().get(0));
        }
        this.currentLayer.setPrototxt(prototxt);
        this.mlModel.addLayer(this.currentLayer);
    }

    private String getPrototxt(TokenStream stream, int start, int end) {
        StringBuilder prototxt = new StringBuilder();
        for (int i = start; i <= end; ++i) {
            Token token = stream.get(i);
            prototxt.append(token.getText());
        }
        String strPrototxt = prototxt.toString();
        return strPrototxt.replaceAll(" +num_examples:.*\\s", "");
    }

    @Override
    public void enterPair(CaffePrototxtParser.PairContext ctx) {
        String key = ctx.getStart().getText();
        this.keys.push(key);
    }

    @Override
    public void exitPair(CaffePrototxtParser.PairContext ctx) {
        if (this.getCurrentKey().equals("param")) {
            this.currentLayer.getParams().add(this.currentParams);
            this.currentParams = new HashMap<String, String>();
        }
        this.keys.pop();
    }

    @Override
    public void exitValueLeaf(CaffePrototxtParser.ValueLeafContext ctx) {
        String value = ctx.getText();
        value = this.parserHelper.removeQuotes(value);
        this.processKeyValue(this.getCurrentKey(), value);
    }

    protected void processKeyValue(String key, String value) {
        switch (key) {
            case "name": {
                this.currentLayer.setName(value);
                break;
            }
            case "top": {
                this.currentLayer.addTop(value);
                return;
            }
            case "bottom": {
                this.currentLayer.addBottom(value);
                return;
            }
        }
        if (key.toLowerCase().startsWith("param.")) {
            this.currentParams.put(key, value);
        }
        this.currentLayer.addAttr(key, value);
    }

    private String getCurrentKey() {
        StringBuilder sb = new StringBuilder();
        for (String s : this.keys) {
            sb.append(s + ".");
        }
        return sb.substring(0, sb.length() - 1).toString();
    }

    public MLModel getMlModel() {
        return this.mlModel;
    }
}

