/*
 * Decompiled with CFR 0.152.
 */
package org.cadixdev.at;

import java.util.Objects;
import java.util.StringJoiner;
import org.cadixdev.at.AccessChange;
import org.cadixdev.at.ModifierChange;

public final class AccessTransform {
    public static final AccessTransform EMPTY = new AccessTransform(AccessChange.NONE, ModifierChange.NONE);
    public static final AccessTransform PUBLIC = AccessTransform.of(AccessChange.PUBLIC);
    private final AccessChange accessChange;
    private final ModifierChange finalChange;

    private AccessTransform(AccessChange accessChange, ModifierChange finalChange) {
        this.accessChange = Objects.requireNonNull(accessChange, "accessChange");
        this.finalChange = Objects.requireNonNull(finalChange, "finalChange");
    }

    public boolean isEmpty() {
        return this == EMPTY;
    }

    public AccessChange getAccess() {
        return this.accessChange;
    }

    public ModifierChange getFinal() {
        return this.finalChange;
    }

    public AccessTransform merge(AccessTransform other) {
        Objects.requireNonNull(other, "other");
        if (this.isEmpty()) {
            return other;
        }
        if (other.isEmpty()) {
            return this;
        }
        return AccessTransform.of(this.getAccess().merge(other.getAccess()), this.getFinal().merge(other.getFinal()));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof AccessTransform)) {
            return false;
        }
        AccessTransform other = (AccessTransform)o;
        return this.getAccess() == other.getAccess() && this.getFinal() == other.getFinal();
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.accessChange, this.finalChange});
    }

    public String toString() {
        if (this.isEmpty()) {
            return "AccessTransform.EMPTY";
        }
        StringJoiner joiner = new StringJoiner(", ", "AccessTransform{", "}");
        if (this.accessChange != AccessChange.NONE) {
            joiner.add("access=" + (Object)((Object)this.accessChange));
        }
        if (this.finalChange != ModifierChange.NONE) {
            joiner.add("final=" + (Object)((Object)this.finalChange));
        }
        return joiner.toString();
    }

    public static AccessTransform of(AccessChange accessChange) {
        return AccessTransform.of(accessChange, ModifierChange.NONE);
    }

    public static AccessTransform of(ModifierChange finalChange) {
        return AccessTransform.of(AccessChange.NONE, finalChange);
    }

    public static AccessTransform of(AccessChange accessChange, ModifierChange finalChange) {
        if (accessChange == AccessChange.NONE && finalChange == ModifierChange.NONE) {
            return EMPTY;
        }
        return new AccessTransform(accessChange, finalChange);
    }
}

