/*
 * Decompiled with CFR 0.152.
 */
package org.cache2k.ee.impl;

import java.lang.management.ManagementFactory;
import java.util.Map;
import java.util.WeakHashMap;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.cache2k.Cache;
import org.cache2k.CacheManager;
import org.cache2k.core.CacheLifeCycleListener;
import org.cache2k.core.CacheManagerImpl;
import org.cache2k.core.CacheManagerLifeCycleListener;
import org.cache2k.core.InternalCache;
import org.cache2k.ee.impl.CacheMXBeanImpl;
import org.cache2k.ee.impl.ManagerMXBeanImpl;

public class JmxSupport
implements CacheLifeCycleListener,
CacheManagerLifeCycleListener {
    int seenClassLoaderCount = 1;
    Map<ClassLoader, Integer> classLoader2Integer = new WeakHashMap<ClassLoader, Integer>();

    @Override
    public void cacheCreated(CacheManager cm, Cache c) {
        MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
        if (c instanceof InternalCache) {
            String _name = this.standardName(cm, c);
            try {
                mbs.registerMBean(new CacheMXBeanImpl((InternalCache)c), new ObjectName(_name));
            }
            catch (Exception e) {
                throw new IllegalStateException("Error registering JMX bean, name='" + _name + "'", e);
            }
        }
    }

    @Override
    public void cacheDestroyed(CacheManager cm, Cache c) {
        MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
        if (c instanceof InternalCache) {
            String _name = this.standardName(cm, c);
            try {
                mbs.unregisterMBean(new ObjectName(_name));
            }
            catch (InstanceNotFoundException instanceNotFoundException) {
            }
            catch (Exception e) {
                throw new IllegalStateException("Error deregistering JMX bean, name='" + _name + "'", e);
            }
        }
    }

    @Override
    public void managerCreated(CacheManager m) {
        MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
        String _name = this.cacheManagerNameWithClassLoader(m);
        try {
            mbs.registerMBean(new ManagerMXBeanImpl((CacheManagerImpl)m), new ObjectName(_name));
        }
        catch (Exception e) {
            throw new IllegalStateException("Error register JMX bean, name='" + _name + "'", e);
        }
    }

    @Override
    public void managerDestroyed(CacheManager m) {
        MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
        String _name = this.cacheManagerNameWithClassLoader(m);
        try {
            mbs.unregisterMBean(new ObjectName(_name));
        }
        catch (InstanceNotFoundException instanceNotFoundException) {
        }
        catch (Exception e) {
            throw new IllegalStateException("Error unregister JMX bean, name='" + _name + "'", e);
        }
    }

    private static String cacheManagerName(CacheManager cm) {
        return "org.cache2k:type=CacheManager,name=" + cm.getName();
    }

    private static String cacheManagerNameWithClassLoaderNumber(CacheManager cm, int _classLoaderNumber) {
        return "org.cache2k:type=CacheManager,name=" + cm.getName() + ",uniqueClassLoaderNumber=" + _classLoaderNumber;
    }

    private synchronized int getUniqueClassLoaderNumber(ClassLoader _classLoader) {
        Integer no = this.classLoader2Integer.get(_classLoader);
        if (no == null) {
            no = this.seenClassLoaderCount++;
            this.classLoader2Integer.put(_classLoader, no);
        }
        return no;
    }

    private synchronized String cacheManagerNameWithClassLoader(CacheManager cm) {
        ClassLoader _classLoader = cm.getClassLoader();
        int no = this.getUniqueClassLoaderNumber(_classLoader);
        if (no == 1) {
            return JmxSupport.cacheManagerName(cm);
        }
        return JmxSupport.cacheManagerNameWithClassLoaderNumber(cm, no);
    }

    private synchronized String standardName(CacheManager cm, Cache c) {
        int _classLoaderNumber = this.getUniqueClassLoaderNumber(cm.getClassLoader());
        if (_classLoaderNumber == 1) {
            return "org.cache2k:type=Cache,manager=" + cm.getName() + ",name=" + c.getName();
        }
        return "org.cache2k:type=Cache,manager=" + cm.getName() + ",uniqueClassLoaderNumber=" + _classLoaderNumber + ",name=" + c.getName();
    }
}

