/*
 * Decompiled with CFR 0.152.
 */
package org.cache2k.core.event;

import java.util.LinkedList;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import org.cache2k.core.InternalCache;
import org.cache2k.core.event.AsyncEvent;

public class AsyncDispatcher<K> {
    static final int KEY_LOCKS_LEN = Runtime.getRuntime().availableProcessors() * 3;
    static Object[] KEY_LOCKS = new Object[KEY_LOCKS_LEN];
    Map<K, Queue<AsyncEvent<K>>> keyQueue = new ConcurrentHashMap<K, Queue<AsyncEvent<K>>>();
    Executor executor;
    InternalCache cache;

    static Object getLockObject(Object key) {
        return KEY_LOCKS[key.hashCode() % KEY_LOCKS_LEN];
    }

    public AsyncDispatcher(InternalCache _cache, Executor _executor) {
        this.cache = _cache;
        this.executor = _executor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void queue(final AsyncEvent<K> _event) {
        K key = _event.getKey();
        Object object = AsyncDispatcher.getLockObject(key);
        synchronized (object) {
            Queue<AsyncEvent<K>> q = this.keyQueue.get(key);
            if (q != null) {
                q.add(_event);
                return;
            }
            q = new LinkedList<AsyncEvent<K>>();
            this.keyQueue.put(key, q);
        }
        Runnable r = new Runnable(){

            @Override
            public void run() {
                AsyncDispatcher.this.runMoreOrStop(_event);
            }
        };
        this.executor.execute(r);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runMoreOrStop(AsyncEvent<K> _event) {
        while (true) {
            try {
                _event.execute();
            }
            catch (Throwable t) {
                this.cache.getLog().warn("Async event exception", t);
            }
            K key = _event.getKey();
            Object object = AsyncDispatcher.getLockObject(key);
            synchronized (object) {
                Queue<AsyncEvent<K>> q = this.keyQueue.get(key);
                if (q.isEmpty()) {
                    this.keyQueue.remove(key);
                    return;
                }
                _event = q.remove();
            }
        }
    }

    static {
        for (int i = 0; i < KEY_LOCKS_LEN; ++i) {
            AsyncDispatcher.KEY_LOCKS[i] = new Object();
        }
    }
}

