/*
 * Decompiled with CFR 0.152.
 */
package org.cache2k.core.concurrency;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class Futures {

    public static abstract class BusyWaitFuture<V>
    implements Future<V> {
        private int spinMillis = 123;
        private V result = null;

        protected BusyWaitFuture() {
        }

        protected BusyWaitFuture(V _defaultResult) {
            this.result = _defaultResult;
        }

        protected BusyWaitFuture(int spinMillis, V _defaultResult) {
            this.spinMillis = spinMillis;
            this.result = _defaultResult;
        }

        protected V getResult() {
            return this.result;
        }

        @Override
        public boolean cancel(boolean mayInterruptIfRunning) {
            return false;
        }

        @Override
        public boolean isCancelled() {
            return false;
        }

        @Override
        public abstract boolean isDone();

        @Override
        public V get() throws InterruptedException, ExecutionException {
            while (!this.isDone()) {
                Thread.sleep(this.spinMillis);
            }
            return this.getResult();
        }

        @Override
        public V get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
            long _maxMillis = unit.toMillis(timeout) + System.currentTimeMillis();
            if (_maxMillis < 0L) {
                return this.get();
            }
            while (!this.isDone() && System.currentTimeMillis() < _maxMillis) {
                Thread.sleep(this.spinMillis);
            }
            if (!this.isDone()) {
                throw new TimeoutException();
            }
            return this.getResult();
        }
    }

    public static class ExceptionFuture<V>
    implements Future<V> {
        private Throwable exception;

        public ExceptionFuture(Throwable exception) {
            this.exception = exception;
        }

        @Override
        public boolean cancel(boolean mayInterruptIfRunning) {
            return false;
        }

        @Override
        public boolean isCancelled() {
            return false;
        }

        @Override
        public boolean isDone() {
            return true;
        }

        @Override
        public V get() throws ExecutionException {
            throw new ExecutionException(this.exception);
        }

        @Override
        public V get(long timeout, TimeUnit unit) throws ExecutionException {
            throw new ExecutionException(this.exception);
        }
    }

    public static class FinishedFuture<V>
    implements Future<V> {
        V result;

        public FinishedFuture() {
        }

        public FinishedFuture(V result) {
            this.result = result;
        }

        @Override
        public boolean cancel(boolean mayInterruptIfRunning) {
            return false;
        }

        @Override
        public boolean isCancelled() {
            return false;
        }

        @Override
        public boolean isDone() {
            return true;
        }

        @Override
        public V get() {
            return this.result;
        }

        @Override
        public V get(long timeout, TimeUnit unit) {
            return this.result;
        }
    }

    public static class WaitForAllFuture<V>
    implements Future<V> {
        List<Future<V>> futureList = new LinkedList<Future<V>>();

        public WaitForAllFuture(Future<V> _top) {
            this.add(_top);
        }

        @SafeVarargs
        public WaitForAllFuture(Future<V> ... _top) {
            for (Future<V> f : _top) {
                this.add(f);
            }
        }

        public synchronized void add(Future<V> f) {
            if (f == null) {
                return;
            }
            this.futureList.add(f);
        }

        @Override
        public synchronized boolean cancel(boolean mayInterruptIfRunning) {
            if (this.futureList.isEmpty()) {
                return false;
            }
            boolean _flag = true;
            for (Future<V> f : this.futureList) {
                if (f.isCancelled()) continue;
                f.cancel(mayInterruptIfRunning);
                _flag &= f.isCancelled();
            }
            return _flag;
        }

        @Override
        public boolean isCancelled() {
            throw new UnsupportedOperationException();
        }

        @Override
        public synchronized boolean isDone() {
            boolean _flag = true;
            for (Future<V> f : this.futureList) {
                _flag &= f.isDone();
            }
            return _flag;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public V get() throws InterruptedException, ExecutionException {
            while (true) {
                Future<V> _needsGet = null;
                WaitForAllFuture waitForAllFuture = this;
                synchronized (waitForAllFuture) {
                    Iterator<Future<V>> it = this.futureList.iterator();
                    while (it.hasNext()) {
                        Future<V> f = it.next();
                        if (!f.isDone()) {
                            _needsGet = f;
                            break;
                        }
                        f.get();
                        it.remove();
                    }
                }
                if (_needsGet == null) break;
                _needsGet.get();
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public V get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
            long _maxTime = System.currentTimeMillis() + unit.toMillis(timeout);
            if (_maxTime < 0L) {
                return this.get();
            }
            while (true) {
                Future<V> _needsGet = null;
                WaitForAllFuture waitForAllFuture = this;
                synchronized (waitForAllFuture) {
                    Iterator<Future<V>> it = this.futureList.iterator();
                    while (it.hasNext()) {
                        Future<V> f = it.next();
                        if (!f.isDone()) {
                            _needsGet = f;
                            break;
                        }
                        f.get();
                        it.remove();
                    }
                }
                if (_needsGet == null) break;
                long now = System.currentTimeMillis();
                long _waitTime = _maxTime - now;
                if (_waitTime <= 0L) {
                    throw new TimeoutException();
                }
                _needsGet.get(_maxTime - now, TimeUnit.MILLISECONDS);
            }
            return null;
        }
    }
}

