/*
 * Decompiled with CFR 0.152.
 */
package org.cache2k;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.concurrent.TimeUnit;
import org.cache2k.Cache;
import org.cache2k.CacheManager;
import org.cache2k.configuration.Cache2kConfiguration;
import org.cache2k.configuration.CacheType;
import org.cache2k.configuration.CacheTypeCapture;
import org.cache2k.configuration.ConfigurationSection;
import org.cache2k.configuration.ConfigurationSectionBuilder;
import org.cache2k.event.CacheEntryOperationListener;
import org.cache2k.expiry.ExpiryPolicy;
import org.cache2k.integration.AdvancedCacheLoader;
import org.cache2k.integration.CacheLoader;
import org.cache2k.integration.CacheWriter;
import org.cache2k.integration.ExceptionPropagator;
import org.cache2k.integration.ResiliencePolicy;
import org.cache2k.spi.Cache2kCoreProvider;
import org.cache2k.spi.SingleProviderResolver;

public class Cache2kBuilder<K, V>
implements Cloneable {
    private static final Cache2kCoreProvider CORE_PROVIDER = SingleProviderResolver.getInstance().resolve(Cache2kCoreProvider.class);
    private static final String MSG_NO_TYPES = "Use Cache2kBuilder.forUnknownTypes(), to construct a builder with no key and value types";
    Cache2kConfiguration<K, V> config;
    private CacheManager manager;

    public static Cache2kBuilder forUnknownTypes() {
        return Cache2kBuilder.of(new Cache2kConfiguration());
    }

    public static <K, T> Cache2kBuilder<K, T> of(Class<K> _keyType, Class<T> _valueType) {
        return Cache2kBuilder.of(Cache2kConfiguration.of(_keyType, _valueType));
    }

    public static <K, T> Cache2kBuilder<K, T> of(Cache2kConfiguration<K, T> c) {
        Cache2kBuilder<K, T> cb = new Cache2kBuilder<K, T>(c);
        return cb;
    }

    private Cache2kBuilder(Cache2kConfiguration<K, V> cfg) {
        this.config = cfg;
    }

    protected Cache2kBuilder() {
        Type t = this.getClass().getGenericSuperclass();
        if (!(t instanceof ParameterizedType)) {
            throw new IllegalArgumentException(MSG_NO_TYPES);
        }
        Type[] _types = ((ParameterizedType)t).getActualTypeArguments();
        CacheType _keyType = CacheTypeCapture.of(_types[0]).getBeanRepresentation();
        CacheType _valueType = CacheTypeCapture.of(_types[1]).getBeanRepresentation();
        if (Object.class.equals(_keyType.getType()) && Object.class.equals(_valueType.getType())) {
            throw new IllegalArgumentException(MSG_NO_TYPES);
        }
        this.config = Cache2kConfiguration.of(_keyType, _valueType);
    }

    public final <K2> Cache2kBuilder<K2, V> keyType(Class<K2> t) {
        this.config.setKeyType(t);
        return this;
    }

    public final <T2> Cache2kBuilder<K, T2> valueType(Class<T2> t) {
        this.config.setValueType(t);
        return this;
    }

    public final <K2> Cache2kBuilder<K2, V> keyType(CacheType<K2> t) {
        this.config.setKeyType(t);
        return this;
    }

    public final <T2> Cache2kBuilder<K, T2> valueType(CacheType<T2> t) {
        this.config.setValueType(t);
        return this;
    }

    public final Cache2kBuilder<K, V> name(Class<?> _class, String _fieldName) {
        this.config.setName(_class.getName() + "." + _fieldName);
        return this;
    }

    public final Cache2kBuilder<K, V> name(Class<?> _class) {
        this.config.setName(_class.getName());
        return this;
    }

    public final Cache2kBuilder<K, V> manager(CacheManager m) {
        this.manager = m;
        return this;
    }

    public final Cache2kBuilder<K, V> name(String v) {
        this.config.setName(v);
        return this;
    }

    public final Cache2kBuilder<K, V> keepDataAfterExpired(boolean v) {
        this.config.setKeepDataAfterExpired(v);
        return this;
    }

    public final Cache2kBuilder<K, V> entryCapacity(long v) {
        this.config.setEntryCapacity(v);
        return this;
    }

    public final Cache2kBuilder<K, V> eternal(boolean v) {
        this.config.setEternal(v);
        return this;
    }

    public final Cache2kBuilder<K, V> suppressExceptions(boolean v) {
        this.config.setSuppressExceptions(v);
        return this;
    }

    public final Cache2kBuilder<K, V> expireAfterWrite(long v, TimeUnit u) {
        this.config.setExpireAfterWriteMillis(u.toMillis(v));
        return this;
    }

    public final Cache2kBuilder<K, V> exceptionPropagator(ExceptionPropagator<K> ep) {
        this.config.setExceptionPropagator(ep);
        return this;
    }

    public final Cache2kBuilder<K, V> loader(CacheLoader<K, V> l) {
        this.config.setLoader(l);
        return this;
    }

    public final Cache2kBuilder<K, V> loader(AdvancedCacheLoader<K, V> l) {
        this.config.setAdvancedLoader(l);
        return this;
    }

    public final Cache2kBuilder<K, V> writer(CacheWriter<K, V> w) {
        this.config.setWriter(w);
        return this;
    }

    public final Cache2kBuilder<K, V> addListener(CacheEntryOperationListener<K, V> listener) {
        boolean _inserted = this.config.getListeners().add(listener);
        if (!_inserted) {
            throw new IllegalArgumentException("Listener already added");
        }
        return this;
    }

    public final Cache2kBuilder<K, V> addAsyncListener(CacheEntryOperationListener<K, V> listener) {
        boolean _inserted = this.config.getAsyncListeners().add(listener);
        if (!_inserted) {
            throw new IllegalArgumentException("Listener already added");
        }
        return this;
    }

    public final Cache2kBuilder<K, V> expiryPolicy(ExpiryPolicy<K, V> c) {
        this.config.setExpiryPolicy(c);
        return this;
    }

    public final Cache2kBuilder<K, V> refreshAhead(boolean f) {
        this.config.setRefreshAhead(f);
        return this;
    }

    public final Cache2kBuilder<K, V> sharpExpiry(boolean f) {
        this.config.setSharpExpiry(f);
        return this;
    }

    public final Cache2kBuilder<K, V> loaderThreadCount(int v) {
        this.config.setLoaderThreadCount(v);
        return this;
    }

    public final Cache2kBuilder<K, V> storeByReference(boolean v) {
        this.config.setStoreByReference(v);
        return this;
    }

    public final Cache2kBuilder<K, V> retryInterval(long v, TimeUnit u) {
        this.config.setRetryIntervalMillis(u.toMillis(v));
        return this;
    }

    public final Cache2kBuilder<K, V> maxRetryInterval(long v, TimeUnit u) {
        this.config.setMaxRetryIntervalMillis(u.toMillis(v));
        return this;
    }

    public final Cache2kBuilder<K, V> resilienceDuration(long v, TimeUnit u) {
        this.config.setResilienceDurationMillis(u.toMillis(v));
        return this;
    }

    public final Cache2kBuilder<K, V> resiliencePolicy(ResiliencePolicy<K, V> v) {
        this.config.setResiliencePolicy(v);
        return this;
    }

    public final Cache2kBuilder<K, V> with(ConfigurationSectionBuilder<? extends ConfigurationSection> ... sectionBuilders) {
        for (ConfigurationSectionBuilder<? extends ConfigurationSection> b : sectionBuilders) {
            this.config.getSections().add(b.buildConfigurationSection());
        }
        return this;
    }

    public final Cache2kBuilder<K, V> strictEviction(boolean flag) {
        this.config.setStrictEviction(flag);
        return this;
    }

    public final Cache2kBuilder<K, V> permitNullValues(boolean flag) {
        this.config.setPermitNullValues(flag);
        return this;
    }

    public final Cache2kBuilder<K, V> disableStatistics(boolean flag) {
        this.config.setDisableStatistics(flag);
        return this;
    }

    public final Cache2kBuilder<K, V> evictionSegmentCount(int v) {
        this.config.setEvictionSegmentCount(v);
        return this;
    }

    public final Cache2kConfiguration<K, V> toConfiguration() {
        return this.config;
    }

    public final Cache<K, V> build() {
        return CORE_PROVIDER.createCache(this.manager, this.config);
    }
}

