/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.core.checkout.service;

import java.util.HashMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.annotation.Resource;
import org.broadleafcommerce.core.checkout.service.CheckoutService;
import org.broadleafcommerce.core.checkout.service.exception.CheckoutException;
import org.broadleafcommerce.core.checkout.service.workflow.CheckoutResponse;
import org.broadleafcommerce.core.checkout.service.workflow.CheckoutSeed;
import org.broadleafcommerce.core.order.domain.Order;
import org.broadleafcommerce.core.order.service.OrderService;
import org.broadleafcommerce.core.order.service.exception.RequiredAttributeNotProvidedException;
import org.broadleafcommerce.core.order.service.type.OrderStatus;
import org.broadleafcommerce.core.pricing.service.exception.PricingException;
import org.broadleafcommerce.core.workflow.ActivityMessages;
import org.broadleafcommerce.core.workflow.ProcessContext;
import org.broadleafcommerce.core.workflow.Processor;
import org.broadleafcommerce.core.workflow.WorkflowException;
import org.springframework.stereotype.Service;

@Service(value="blCheckoutService")
public class CheckoutServiceImpl
implements CheckoutService {
    @Resource(name="blCheckoutWorkflow")
    protected Processor checkoutWorkflow;
    @Resource(name="blOrderService")
    protected OrderService orderService;
    protected static ConcurrentMap<Long, Object> lockMap = new ConcurrentHashMap<Long, Object>();

    @Override
    public CheckoutResponse performCheckout(Order order) throws CheckoutException {
        Object lockObject = this.putLock(order.getId());
        if (lockObject != null) {
            throw new CheckoutException("This order is already in the process of being submitted, unable to checkout order -- id: " + order.getId(), new CheckoutSeed(order, new HashMap<String, Object>()));
        }
        if (this.hasOrderBeenCompleted(order)) {
            throw new CheckoutException("This order has already been submitted, unable to checkout order -- id: " + order.getId(), new CheckoutSeed(order, new HashMap<String, Object>()));
        }
        CheckoutSeed seed = null;
        try {
            order = this.orderService.save(order, false);
            seed = new CheckoutSeed(order, new HashMap<String, Object>());
            ProcessContext<?> context = this.checkoutWorkflow.doActivities(seed);
            order = this.orderService.save(seed.getOrder(), false);
            order.getOrderMessages().addAll(((ActivityMessages)((Object)context)).getActivityMessages());
            seed.setOrder(order);
            CheckoutSeed checkoutSeed = seed;
            return checkoutSeed;
        }
        catch (PricingException e) {
            throw new CheckoutException("Unable to checkout order -- id: " + order.getId(), e, seed);
        }
        catch (WorkflowException e) {
            throw new CheckoutException("Unable to checkout order -- id: " + order.getId(), e.getRootCause(), seed);
        }
        catch (RequiredAttributeNotProvidedException e) {
            throw new CheckoutException("Unable to checkout order -- id: " + order.getId(), e.getCause(), seed);
        }
        finally {
            this.removeLock(order.getId());
        }
    }

    protected boolean hasOrderBeenCompleted(Order order) {
        return OrderStatus.SUBMITTED.equals(order.getStatus());
    }

    protected Object putLock(Long orderId) {
        return lockMap.putIfAbsent(orderId, new Object());
    }

    protected void removeLock(Long orderId) {
        lockMap.remove(orderId);
    }
}

