/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.core.pricing.service;

import javax.annotation.Resource;
import org.broadleafcommerce.core.order.domain.Order;
import org.broadleafcommerce.core.pricing.service.PricingService;
import org.broadleafcommerce.core.pricing.service.exception.PricingException;
import org.broadleafcommerce.core.workflow.ProcessContext;
import org.broadleafcommerce.core.workflow.Processor;
import org.broadleafcommerce.core.workflow.WorkflowException;
import org.springframework.stereotype.Service;

@Service(value="blPricingService")
public class PricingServiceImpl
implements PricingService {
    @Resource(name="blPricingWorkflow")
    protected Processor pricingWorkflow;

    @Override
    public Order executePricing(Order order) throws PricingException {
        try {
            ProcessContext<?> context = this.pricingWorkflow.doActivities(order);
            Order response = (Order)context.getSeedData();
            return response;
        }
        catch (WorkflowException e) {
            throw new PricingException("Unable to execute pricing for order -- id: " + order.getId(), (Throwable)((Object)e));
        }
    }
}

