/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.core.catalog.service;

import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.broadleafcommerce.common.file.service.BroadleafFileUtils;
import org.broadleafcommerce.common.sitemap.domain.SiteMapGeneratorConfiguration;
import org.broadleafcommerce.common.sitemap.service.SiteMapBuilder;
import org.broadleafcommerce.common.sitemap.service.SiteMapGenerator;
import org.broadleafcommerce.common.sitemap.service.type.SiteMapGeneratorType;
import org.broadleafcommerce.common.sitemap.wrapper.SiteMapURLWrapper;
import org.broadleafcommerce.core.catalog.dao.CategoryDao;
import org.broadleafcommerce.core.catalog.domain.Category;
import org.broadleafcommerce.core.catalog.domain.CategorySiteMapGeneratorConfiguration;
import org.hibernate.tool.hbm2x.StringUtils;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component(value="blCategorySiteMapGenerator")
public class CategorySiteMapGenerator
implements SiteMapGenerator {
    @Resource(name="blCategoryDao")
    protected CategoryDao categoryDao;
    @Value(value="${category.site.map.generator.row.limit}")
    protected int rowLimit;

    public boolean canHandleSiteMapConfiguration(SiteMapGeneratorConfiguration siteMapGeneratorConfiguration) {
        return SiteMapGeneratorType.CATEGORY.equals((Object)siteMapGeneratorConfiguration.getSiteMapGeneratorType());
    }

    public void addSiteMapEntries(SiteMapGeneratorConfiguration smgc, SiteMapBuilder siteMapBuilder) {
        CategorySiteMapGeneratorConfiguration categorySMGC = (CategorySiteMapGeneratorConfiguration)smgc;
        this.addCategorySiteMapEntries(categorySMGC.getRootCategory(), 1, categorySMGC, siteMapBuilder);
    }

    protected void addCategorySiteMapEntries(Category parentCategory, int currentDepth, CategorySiteMapGeneratorConfiguration categorySMGC, SiteMapBuilder siteMapBuilder) {
        List<Category> categories;
        int rowOffset = 0;
        do {
            categories = this.categoryDao.readActiveSubCategoriesByCategory(parentCategory, this.rowLimit, rowOffset);
            rowOffset += categories.size();
            for (Category category : categories) {
                if (StringUtils.isEmpty((String)category.getUrl())) continue;
                if (currentDepth < categorySMGC.getEndingDepth()) {
                    this.addCategorySiteMapEntries(category, currentDepth + 1, categorySMGC, siteMapBuilder);
                }
                if (currentDepth < categorySMGC.getStartingDepth()) continue;
                SiteMapURLWrapper siteMapUrl = new SiteMapURLWrapper();
                siteMapUrl.setLoc(this.generateUri(siteMapBuilder, category));
                siteMapUrl.setChangeFreqType(categorySMGC.getSiteMapChangeFreq());
                siteMapUrl.setPriorityType(categorySMGC.getSiteMapPriority());
                siteMapUrl.setLastModDate(this.generateDate(category));
                siteMapBuilder.addUrl(siteMapUrl);
            }
        } while (categories.size() == this.rowLimit);
    }

    protected String generateUri(SiteMapBuilder siteMapBuilder, Category category) {
        return BroadleafFileUtils.appendUnixPaths((String)siteMapBuilder.getBaseUrl(), (String)category.getUrl());
    }

    protected Date generateDate(Category category) {
        return new Date();
    }

    public CategoryDao getCategoryDao() {
        return this.categoryDao;
    }

    public void setCategoryDao(CategoryDao categoryDao) {
        this.categoryDao = categoryDao;
    }

    public int getRowLimit() {
        return this.rowLimit;
    }

    public void setRowLimit(int rowLimit) {
        this.rowLimit = rowLimit;
    }
}

