/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.core.checkout.service.workflow;

import javax.annotation.Resource;
import org.broadleafcommerce.core.checkout.service.workflow.CheckoutSeed;
import org.broadleafcommerce.core.order.domain.Order;
import org.broadleafcommerce.core.pricing.service.TaxService;
import org.broadleafcommerce.core.workflow.BaseActivity;
import org.broadleafcommerce.core.workflow.ProcessContext;

public class CommitTaxActivity
extends BaseActivity<ProcessContext<CheckoutSeed>> {
    @Resource(name="blTaxService")
    protected TaxService taxService;

    public CommitTaxActivity() {
        super.setAutomaticallyRegisterRollbackHandler(true);
    }

    @Override
    public ProcessContext<CheckoutSeed> execute(ProcessContext<CheckoutSeed> context) throws Exception {
        Order order = context.getSeedData().getOrder();
        if (!order.getTaxOverride().booleanValue()) {
            order = this.taxService.commitTaxForOrder(order);
            context.getSeedData().setOrder(order);
        }
        return context;
    }
}

