/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.core.rating.service.type;

import java.util.HashMap;
import java.util.Map;

public class ReviewStatusType {
    private static final long serialVersionUID = 1L;
    private static final Map<String, ReviewStatusType> TYPES = new HashMap<String, ReviewStatusType>();
    public static final ReviewStatusType PENDING = new ReviewStatusType("PENDING");
    public static final ReviewStatusType APPROVED = new ReviewStatusType("APPROVED");
    public static final ReviewStatusType REJECTED = new ReviewStatusType("REJECTED");
    private String type;

    public static ReviewStatusType getInstance(String type) {
        return TYPES.get(type);
    }

    public ReviewStatusType() {
    }

    public ReviewStatusType(String type) {
        this.setType(type);
    }

    public String getType() {
        return this.type;
    }

    private void setType(String type) {
        this.type = type;
        if (!TYPES.containsKey(type)) {
            TYPES.put(type, this);
        }
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!this.getClass().isAssignableFrom(obj.getClass())) {
            return false;
        }
        ReviewStatusType other = (ReviewStatusType)obj;
        return !(this.type == null ? other.type != null : !this.type.equals(other.type));
    }
}

