/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.core.catalog.service.type;

import java.io.Serializable;
import java.util.LinkedHashMap;
import java.util.Map;
import org.broadleafcommerce.common.BroadleafEnumerationType;

public class ProductOptionValidationType
implements Serializable,
BroadleafEnumerationType {
    private static final long serialVersionUID = 1L;
    private static final Map<String, ProductOptionValidationType> TYPES = new LinkedHashMap<String, ProductOptionValidationType>();
    public static final ProductOptionValidationType REGEX = new ProductOptionValidationType("REGEX", "Regular Expression");
    private String type;
    private String friendlyType;

    public static ProductOptionValidationType getInstance(String type) {
        return TYPES.get(type);
    }

    public ProductOptionValidationType() {
    }

    public ProductOptionValidationType(String type, String friendlyType) {
        this.friendlyType = friendlyType;
        this.setType(type);
    }

    public String getType() {
        return this.type;
    }

    public String getFriendlyType() {
        return this.friendlyType;
    }

    private void setType(String type) {
        this.type = type;
        if (!TYPES.containsKey(type)) {
            TYPES.put(type, this);
        }
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!this.getClass().isAssignableFrom(obj.getClass())) {
            return false;
        }
        ProductOptionValidationType other = (ProductOptionValidationType)obj;
        return !(this.type == null ? other.type != null : !this.type.equals(other.type));
    }
}

