/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.core.order.service;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.broadleafcommerce.common.rule.AbstractRuleProcessor;
import org.broadleafcommerce.common.structure.dto.ItemCriteriaDTO;
import org.broadleafcommerce.core.order.dao.OrderDao;
import org.broadleafcommerce.core.order.domain.Order;
import org.broadleafcommerce.core.order.domain.OrderItem;
import org.broadleafcommerce.profile.core.domain.Customer;

public abstract class AbstractCartRuleProcessor<T>
extends AbstractRuleProcessor<T> {
    protected OrderDao orderDao;

    protected Order lookupOrderForCustomer(Customer c) {
        Order o = null;
        if (c != null) {
            o = this.orderDao.readCartForCustomer(c);
        }
        return o;
    }

    protected boolean checkItemCriteria(ItemCriteriaDTO itemCriteria, List<OrderItem> orderItems) {
        HashMap<String, OrderItem> vars = new HashMap<String, OrderItem>();
        int foundCount = 0;
        Iterator<OrderItem> items = orderItems.iterator();
        while (foundCount < itemCriteria.getQty() && items.hasNext()) {
            OrderItem currentItem = items.next();
            vars.put("discreteOrderItem", currentItem);
            vars.put("orderItem", currentItem);
            boolean match = this.executeExpression(itemCriteria.getMatchRule(), vars);
            if (!match) continue;
            foundCount += currentItem.getQuantity();
        }
        return foundCount >= itemCriteria.getQty();
    }

    public void setOrderDao(OrderDao orderDao) {
        this.orderDao = orderDao;
    }

    public OrderDao getOrderDao() {
        return this.orderDao;
    }
}

