/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.core.payment.domain;

import java.math.BigDecimal;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.persistence.CollectionTable;
import javax.persistence.Column;
import javax.persistence.ElementCollection;
import javax.persistence.Embedded;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;
import javax.persistence.JoinColumn;
import javax.persistence.Lob;
import javax.persistence.ManyToOne;
import javax.persistence.MapKeyColumn;
import javax.persistence.Table;
import org.broadleafcommerce.common.currency.domain.BroadleafCurrency;
import org.broadleafcommerce.common.currency.util.BroadleafCurrencyUtils;
import org.broadleafcommerce.common.money.Money;
import org.broadleafcommerce.common.payment.PaymentTransactionType;
import org.broadleafcommerce.common.persistence.ArchiveStatus;
import org.broadleafcommerce.common.presentation.AdminPresentation;
import org.broadleafcommerce.common.presentation.AdminPresentationMap;
import org.broadleafcommerce.common.presentation.AdminPresentationToOneLookup;
import org.broadleafcommerce.common.presentation.client.SupportedFieldType;
import org.broadleafcommerce.common.presentation.override.AdminPresentationMergeEntry;
import org.broadleafcommerce.common.presentation.override.AdminPresentationMergeOverride;
import org.broadleafcommerce.common.presentation.override.AdminPresentationMergeOverrides;
import org.broadleafcommerce.core.payment.domain.OrderPayment;
import org.broadleafcommerce.core.payment.domain.OrderPaymentImpl;
import org.broadleafcommerce.core.payment.domain.PaymentTransaction;
import org.hibernate.annotations.BatchSize;
import org.hibernate.annotations.GenericGenerator;
import org.hibernate.annotations.MapKeyType;
import org.hibernate.annotations.Parameter;
import org.hibernate.annotations.SQLDelete;
import org.hibernate.annotations.Type;

@Entity
@Inheritance(strategy=InheritanceType.JOINED)
@Table(name="BLC_ORDER_PAYMENT_TRANSACTION")
@SQLDelete(sql="UPDATE BLC_ORDER_PAYMENT_TRANSACTION SET ARCHIVED = 'Y' WHERE PAYMENT_TRANSACTION_ID = ?")
@AdminPresentationMergeOverrides(value={@AdminPresentationMergeOverride(name="", mergeEntries={@AdminPresentationMergeEntry(propertyType="readOnly", booleanOverrideValue=true)})})
public class PaymentTransactionImpl
implements PaymentTransaction {
    private static final long serialVersionUID = 1L;
    @Id
    @GeneratedValue(generator="PaymentTransactionId")
    @GenericGenerator(name="PaymentTransactionId", strategy="org.broadleafcommerce.common.persistence.IdOverrideTableGenerator", parameters={@Parameter(name="segment_value", value="PaymentTransactionImpl"), @Parameter(name="entity_name", value="org.broadleafcommerce.core.payment.domain.PaymentTransactionImpl")})
    @Column(name="PAYMENT_TRANSACTION_ID")
    protected Long id;
    @Column(name="TRANSACTION_TYPE")
    @AdminPresentation(friendlyName="PaymentTransactionImpl_Type", fieldType=SupportedFieldType.BROADLEAF_ENUMERATION, broadleafEnumeration="org.broadleafcommerce.common.payment.PaymentTransactionType", prominent=true, gridOrder=1000)
    protected String type;
    @Column(name="TRANSACTION_AMOUNT")
    @AdminPresentation(friendlyName="PaymentTransactionImpl_Amount", fieldType=SupportedFieldType.MONEY, prominent=true, gridOrder=2000)
    protected BigDecimal amount;
    @Column(name="DATE_RECORDED")
    @AdminPresentation(friendlyName="PaymentTransactionImpl_Date", prominent=true, gridOrder=3000)
    protected Date date;
    @Column(name="CUSTOMER_IP_ADDRESS", nullable=true)
    @AdminPresentation(friendlyName="PaymentTransactionImpl_Payment_IP_Address", order=4000)
    protected String customerIpAddress;
    @Column(name="RAW_RESPONSE", length=0x7FFFFFFE)
    @Lob
    @Type(type="org.hibernate.type.StringClobType")
    @AdminPresentation(friendlyName="PaymentTransactionImpl_Raw_Response")
    protected String rawResponse;
    @Column(name="SUCCESS")
    @AdminPresentation(friendlyName="PaymentTransactionImpl_Success")
    protected Boolean success = true;
    @Embedded
    protected ArchiveStatus archiveStatus = new ArchiveStatus();
    @ManyToOne(targetEntity=OrderPaymentImpl.class, optional=false)
    @JoinColumn(name="ORDER_PAYMENT")
    @AdminPresentation(excluded=true)
    protected OrderPayment orderPayment;
    @ManyToOne(targetEntity=PaymentTransactionImpl.class)
    @JoinColumn(name="PARENT_TRANSACTION")
    @AdminPresentation(friendlyName="Parent Transaction")
    @AdminPresentationToOneLookup
    protected PaymentTransaction parentTransaction;
    @ElementCollection
    @MapKeyColumn(name="FIELD_NAME")
    @MapKeyType(value=@Type(type="java.lang.String"))
    @Lob
    @Type(type="org.hibernate.type.StringClobType")
    @Column(name="FIELD_VALUE", length=0x7FFFFFFE)
    @CollectionTable(name="BLC_TRANS_ADDITNL_FIELDS", joinColumns={@JoinColumn(name="PAYMENT_TRANSACTION_ID")})
    @BatchSize(size=50)
    @AdminPresentationMap(friendlyName="PaymentTransactionImpl_Additional_Fields", forceFreeFormKeys=true, keyPropertyFriendlyName="PaymentTransactionImpl_Additional_Fields_Name")
    protected Map<String, String> additionalFields = new HashMap<String, String>();

    @Override
    public Long getId() {
        return this.id;
    }

    @Override
    public void setId(Long id) {
        this.id = id;
    }

    @Override
    public OrderPayment getOrderPayment() {
        if (this.orderPayment == null && this.parentTransaction != null) {
            return this.parentTransaction.getOrderPayment();
        }
        return this.orderPayment;
    }

    @Override
    public void setOrderPayment(OrderPayment orderPayment) {
        this.orderPayment = orderPayment;
    }

    @Override
    public PaymentTransaction getParentTransaction() {
        return this.parentTransaction;
    }

    @Override
    public void setParentTransaction(PaymentTransaction parentTransaction) {
        this.parentTransaction = parentTransaction;
    }

    @Override
    public PaymentTransactionType getType() {
        return PaymentTransactionType.getInstance((String)this.type);
    }

    @Override
    public void setType(PaymentTransactionType type) {
        this.type = type == null ? null : type.getType();
    }

    @Override
    public Money getAmount() {
        return this.amount == null ? BroadleafCurrencyUtils.getMoney((BigDecimal)BigDecimal.ZERO, (BroadleafCurrency)this.getOrderPayment().getCurrency()) : BroadleafCurrencyUtils.getMoney((BigDecimal)this.amount, (BroadleafCurrency)this.getOrderPayment().getCurrency());
    }

    @Override
    public void setAmount(Money amount) {
        if (amount != null) {
            this.amount = amount.getAmount();
        }
    }

    @Override
    public Date getDate() {
        return this.date;
    }

    @Override
    public void setDate(Date date) {
        this.date = date;
    }

    @Override
    public String getCustomerIpAddress() {
        return this.customerIpAddress;
    }

    @Override
    public void setCustomerIpAddress(String customerIpAddress) {
        this.customerIpAddress = customerIpAddress;
    }

    @Override
    public String getRawResponse() {
        return this.rawResponse;
    }

    @Override
    public void setRawResponse(String rawResponse) {
        this.rawResponse = rawResponse;
    }

    @Override
    public Boolean getSuccess() {
        return this.success;
    }

    @Override
    public void setSuccess(Boolean success) {
        this.success = success;
    }

    @Override
    public Map<String, String> getAdditionalFields() {
        return this.additionalFields;
    }

    @Override
    public void setAdditionalFields(Map<String, String> additionalFields) {
        this.additionalFields = additionalFields;
    }

    public Character getArchived() {
        ArchiveStatus temp = this.archiveStatus == null ? new ArchiveStatus() : this.archiveStatus;
        return temp.getArchived();
    }

    public void setArchived(Character archived) {
        if (this.archiveStatus == null) {
            this.archiveStatus = new ArchiveStatus();
        }
        this.archiveStatus.setArchived(archived);
    }

    public boolean isActive() {
        return 'Y' != this.getArchived().charValue();
    }
}

