/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.core.order.service.call;

import java.util.HashMap;
import java.util.Map;
import org.broadleafcommerce.common.money.Money;
import org.broadleafcommerce.core.catalog.domain.Category;
import org.broadleafcommerce.core.catalog.domain.Product;
import org.broadleafcommerce.core.catalog.domain.Sku;
import org.broadleafcommerce.core.order.domain.Order;
import org.broadleafcommerce.core.order.domain.PersonalMessage;

public abstract class AbstractOrderItemRequest {
    protected Sku sku;
    protected Category category;
    protected Product product;
    protected Order order;
    protected int quantity;
    protected Money salePriceOverride;
    protected Money retailPriceOverride;
    protected PersonalMessage personalMessage;
    protected Map<String, String> itemAttributes = new HashMap<String, String>();

    public Sku getSku() {
        return this.sku;
    }

    public void setSku(Sku sku) {
        this.sku = sku;
    }

    public Category getCategory() {
        return this.category;
    }

    public void setCategory(Category category) {
        this.category = category;
    }

    public Product getProduct() {
        return this.product;
    }

    public void setProduct(Product product) {
        this.product = product;
    }

    public void setOrder(Order order) {
        this.order = order;
    }

    public Order getOrder() {
        return this.order;
    }

    public int getQuantity() {
        return this.quantity;
    }

    public void setQuantity(int quantity) {
        this.quantity = quantity;
    }

    public Map<String, String> getItemAttributes() {
        return this.itemAttributes;
    }

    public void setItemAttributes(Map<String, String> itemAttributes) {
        this.itemAttributes = itemAttributes;
    }

    public Money getSalePriceOverride() {
        return this.salePriceOverride;
    }

    public void setSalePriceOverride(Money salePriceOverride) {
        this.salePriceOverride = salePriceOverride;
    }

    public Money getRetailPriceOverride() {
        return this.retailPriceOverride;
    }

    public void setRetailPriceOverride(Money retailPriceOverride) {
        this.retailPriceOverride = retailPriceOverride;
    }

    protected void copyProperties(AbstractOrderItemRequest newRequest) {
        newRequest.setCategory(this.category);
        newRequest.setItemAttributes(this.itemAttributes);
        newRequest.setPersonalMessage(this.personalMessage);
        newRequest.setProduct(this.product);
        newRequest.setQuantity(this.quantity);
        newRequest.setSku(this.sku);
        newRequest.setOrder(this.order);
        newRequest.setSalePriceOverride(this.salePriceOverride);
        newRequest.setRetailPriceOverride(this.retailPriceOverride);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (!this.getClass().isAssignableFrom(o.getClass())) {
            return false;
        }
        AbstractOrderItemRequest that = (AbstractOrderItemRequest)o;
        if (this.quantity != that.quantity) {
            return false;
        }
        if (this.category != null ? !this.category.equals(that.category) : that.category != null) {
            return false;
        }
        if (this.product != null ? !this.product.equals(that.product) : that.product != null) {
            return false;
        }
        if (this.salePriceOverride != null ? !this.salePriceOverride.equals((Object)that.salePriceOverride) : that.salePriceOverride != null) {
            return false;
        }
        if (this.sku != null ? !this.sku.equals(that.sku) : that.sku != null) {
            return false;
        }
        return !(this.order != null ? !this.order.equals(that.order) : that.order != null);
    }

    public int hashCode() {
        int result = this.sku != null ? this.sku.hashCode() : 0;
        result = 31 * result + (this.category != null ? this.category.hashCode() : 0);
        result = 31 * result + (this.product != null ? this.product.hashCode() : 0);
        result = 31 * result + (this.order != null ? this.order.hashCode() : 0);
        result = 31 * result + this.quantity;
        result = 31 * result + (this.salePriceOverride != null ? this.salePriceOverride.hashCode() : 0);
        return result;
    }

    public PersonalMessage getPersonalMessage() {
        return this.personalMessage;
    }

    public void setPersonalMessage(PersonalMessage personalMessage) {
        this.personalMessage = personalMessage;
    }
}

