/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.core.checkout.service.workflow;

import java.util.ArrayList;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.lang.StringUtils;
import org.broadleafcommerce.core.catalog.domain.Product;
import org.broadleafcommerce.core.catalog.domain.ProductOption;
import org.broadleafcommerce.core.catalog.service.type.ProductOptionValidationStrategyType;
import org.broadleafcommerce.core.checkout.service.workflow.CheckoutSeed;
import org.broadleafcommerce.core.order.domain.BundleOrderItem;
import org.broadleafcommerce.core.order.domain.DiscreteOrderItem;
import org.broadleafcommerce.core.order.domain.Order;
import org.broadleafcommerce.core.order.domain.OrderItem;
import org.broadleafcommerce.core.order.domain.OrderItemAttribute;
import org.broadleafcommerce.core.order.service.ProductOptionValidationService;
import org.broadleafcommerce.core.order.service.call.ActivityMessageDTO;
import org.broadleafcommerce.core.order.service.exception.ProductOptionValidationException;
import org.broadleafcommerce.core.order.service.exception.RequiredAttributeNotProvidedException;
import org.broadleafcommerce.core.order.service.type.MessageType;
import org.broadleafcommerce.core.workflow.ActivityMessages;
import org.broadleafcommerce.core.workflow.BaseActivity;
import org.broadleafcommerce.core.workflow.ProcessContext;

public class ValidateProductOptionsActivity
extends BaseActivity<ProcessContext<CheckoutSeed>> {
    @Resource(name="blProductOptionValidationService")
    protected ProductOptionValidationService productOptionValidationService;

    @Override
    public ProcessContext<CheckoutSeed> execute(ProcessContext<CheckoutSeed> context) throws Exception {
        Order order = context.getSeedData().getOrder();
        ArrayList<DiscreteOrderItem> orderItems = new ArrayList<DiscreteOrderItem>();
        for (OrderItem orderItem : order.getOrderItems()) {
            if (orderItem instanceof DiscreteOrderItem) {
                orderItems.add((DiscreteOrderItem)orderItem);
                continue;
            }
            if (!(orderItem instanceof BundleOrderItem)) continue;
            orderItems.addAll(((BundleOrderItem)orderItem).getDiscreteOrderItems());
        }
        for (DiscreteOrderItem discreteOrderItem : orderItems) {
            Map<String, OrderItemAttribute> attributeValues = discreteOrderItem.getOrderItemAttributes();
            Product product = discreteOrderItem.getProduct();
            if (product == null || product.getProductOptions() == null || product.getProductOptions().size() <= 0) continue;
            for (ProductOption productOption : product.getProductOptions()) {
                if (productOption.getRequired().booleanValue() && (productOption.getProductOptionValidationStrategyType() == null || productOption.getProductOptionValidationStrategyType().getRank() <= this.getProductOptionValidationStrategyType().getRank()) && (attributeValues.get(productOption.getAttributeName()) == null || StringUtils.isEmpty((String)((String)((Object)attributeValues.get(productOption.getAttributeName()).getValue()))))) {
                    throw new RequiredAttributeNotProvidedException("Unable to validate cart, product  (" + product.getId() + ") required attribute was not provided: " + productOption.getAttributeName(), productOption.getAttributeName());
                }
                if (productOption.getProductOptionValidationType() != null && (productOption.getProductOptionValidationStrategyType() == null || productOption.getProductOptionValidationStrategyType().getRank() <= this.getProductOptionValidationStrategyType().getRank())) {
                    this.productOptionValidationService.validate(productOption, (String)((Object)attributeValues.get(productOption.getAttributeName()).getValue()));
                }
                if (productOption.getProductOptionValidationStrategyType() == null || productOption.getProductOptionValidationStrategyType().getRank() <= this.getProductOptionValidationStrategyType().getRank()) continue;
                try {
                    this.productOptionValidationService.validate(productOption, attributeValues.get(productOption.getAttributeName()) != null ? (String)((Object)attributeValues.get(productOption.getAttributeName()).getValue()) : null);
                }
                catch (ProductOptionValidationException e) {
                    ActivityMessageDTO msg = new ActivityMessageDTO(MessageType.PRODUCT_OPTION.getType(), 1, e.getMessage());
                    msg.setErrorCode(productOption.getErrorCode());
                    ((ActivityMessages)((Object)context)).getActivityMessages().add(msg);
                }
            }
        }
        return context;
    }

    public ProductOptionValidationStrategyType getProductOptionValidationStrategyType() {
        return ProductOptionValidationStrategyType.SUBMIT_ORDER;
    }
}

