/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.core.offer.domain;

import java.lang.reflect.Method;
import java.math.BigDecimal;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.broadleafcommerce.common.currency.domain.BroadleafCurrency;
import org.broadleafcommerce.common.currency.util.BroadleafCurrencyUtils;
import org.broadleafcommerce.common.money.Money;
import org.broadleafcommerce.core.offer.domain.CandidateItemOffer;
import org.broadleafcommerce.core.offer.domain.Offer;
import org.broadleafcommerce.core.offer.domain.OfferImpl;
import org.broadleafcommerce.core.order.domain.OrderItem;
import org.broadleafcommerce.core.order.domain.OrderItemImpl;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.hibernate.annotations.GenericGenerator;
import org.hibernate.annotations.Index;
import org.hibernate.annotations.Parameter;

@Entity
@Table(name="BLC_CANDIDATE_ITEM_OFFER")
@Inheritance(strategy=InheritanceType.JOINED)
@Cache(usage=CacheConcurrencyStrategy.NONSTRICT_READ_WRITE, region="blOrderElements")
public class CandidateItemOfferImpl
implements CandidateItemOffer,
Cloneable {
    public static final Log LOG = LogFactory.getLog(CandidateItemOfferImpl.class);
    public static final long serialVersionUID = 1L;
    @Id
    @GeneratedValue(generator="CandidateItemOfferId")
    @GenericGenerator(name="CandidateItemOfferId", strategy="org.broadleafcommerce.common.persistence.IdOverrideTableGenerator", parameters={@Parameter(name="segment_value", value="CandidateItemOfferImpl"), @Parameter(name="entity_name", value="org.broadleafcommerce.core.offer.domain.CandidateItemOfferImpl")})
    @Column(name="CANDIDATE_ITEM_OFFER_ID")
    protected Long id;
    @ManyToOne(targetEntity=OrderItemImpl.class)
    @JoinColumn(name="ORDER_ITEM_ID")
    @Index(name="CANDIDATE_ITEM_INDEX", columnNames={"ORDER_ITEM_ID"})
    protected OrderItem orderItem;
    @ManyToOne(targetEntity=OfferImpl.class, optional=false)
    @JoinColumn(name="OFFER_ID")
    @Index(name="CANDIDATE_ITEMOFFER_INDEX", columnNames={"OFFER_ID"})
    protected Offer offer;
    @Column(name="DISCOUNTED_PRICE", precision=19, scale=5)
    private BigDecimal discountedPrice;

    @Override
    public Long getId() {
        return this.id;
    }

    @Override
    public void setId(Long id) {
        this.id = id;
    }

    @Override
    public OrderItem getOrderItem() {
        return this.orderItem;
    }

    @Override
    public void setOrderItem(OrderItem orderItem) {
        this.orderItem = orderItem;
    }

    @Override
    public void setOffer(Offer offer) {
        this.offer = offer;
    }

    @Override
    public int getPriority() {
        return this.offer.getPriority();
    }

    @Override
    public Offer getOffer() {
        return this.offer;
    }

    @Override
    public Money getDiscountedPrice() {
        return this.discountedPrice == null ? null : BroadleafCurrencyUtils.getMoney((BigDecimal)this.discountedPrice, (BroadleafCurrency)this.getOrderItem().getOrder().getCurrency());
    }

    @Override
    public void setDiscountedPrice(Money discountedPrice) {
        this.discountedPrice = discountedPrice.getAmount();
    }

    public void checkCloneable(CandidateItemOffer itemOffer) throws CloneNotSupportedException, SecurityException, NoSuchMethodException {
        Method cloneMethod = itemOffer.getClass().getMethod("clone", new Class[0]);
        if (cloneMethod.getDeclaringClass().getName().startsWith("org.broadleafcommerce") && !itemOffer.getClass().getName().startsWith("org.broadleafcommerce")) {
            throw new CloneNotSupportedException("Custom extensions and implementations should implement clone in order to guarantee split and merge operations are performed accurately");
        }
    }

    @Override
    public CandidateItemOffer clone() {
        CandidateItemOffer candidateItemOffer;
        try {
            candidateItemOffer = (CandidateItemOffer)Class.forName(this.getClass().getName()).newInstance();
            try {
                this.checkCloneable(candidateItemOffer);
            }
            catch (CloneNotSupportedException e) {
                LOG.warn((Object)("Clone implementation missing in inheritance hierarchy outside of Broadleaf: " + candidateItemOffer.getClass().getName()), (Throwable)e);
            }
            candidateItemOffer.setOffer(this.offer);
            candidateItemOffer.setOrderItem(this.orderItem);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return candidateItemOffer;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.discountedPrice == null ? 0 : this.discountedPrice.hashCode());
        result = 31 * result + (this.offer == null ? 0 : this.offer.hashCode());
        result = 31 * result + (this.orderItem == null ? 0 : this.orderItem.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!this.getClass().isAssignableFrom(obj.getClass())) {
            return false;
        }
        CandidateItemOfferImpl other = (CandidateItemOfferImpl)obj;
        if (this.id != null && other.id != null) {
            return this.id.equals(other.id);
        }
        if (this.discountedPrice == null ? other.discountedPrice != null : !this.discountedPrice.equals(other.discountedPrice)) {
            return false;
        }
        if (this.offer == null ? other.offer != null : !this.offer.equals(other.offer)) {
            return false;
        }
        return !(this.orderItem == null ? other.orderItem != null : !this.orderItem.equals(other.orderItem));
    }
}

