/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.core.order.service.workflow.add;

import java.util.HashMap;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.lang.StringUtils;
import org.broadleafcommerce.core.catalog.domain.Product;
import org.broadleafcommerce.core.catalog.domain.ProductOption;
import org.broadleafcommerce.core.catalog.domain.ProductOptionValue;
import org.broadleafcommerce.core.catalog.domain.Sku;
import org.broadleafcommerce.core.catalog.service.CatalogService;
import org.broadleafcommerce.core.catalog.service.type.ProductOptionValidationStrategyType;
import org.broadleafcommerce.core.order.domain.OrderItem;
import org.broadleafcommerce.core.order.service.OrderItemService;
import org.broadleafcommerce.core.order.service.OrderService;
import org.broadleafcommerce.core.order.service.ProductOptionValidationService;
import org.broadleafcommerce.core.order.service.call.ActivityMessageDTO;
import org.broadleafcommerce.core.order.service.call.NonDiscreteOrderItemRequestDTO;
import org.broadleafcommerce.core.order.service.call.OrderItemRequestDTO;
import org.broadleafcommerce.core.order.service.exception.ProductOptionValidationException;
import org.broadleafcommerce.core.order.service.exception.RequiredAttributeNotProvidedException;
import org.broadleafcommerce.core.order.service.type.MessageType;
import org.broadleafcommerce.core.order.service.workflow.CartOperationRequest;
import org.broadleafcommerce.core.workflow.ActivityMessages;
import org.broadleafcommerce.core.workflow.BaseActivity;
import org.broadleafcommerce.core.workflow.ProcessContext;

public class ValidateAddRequestActivity
extends BaseActivity<ProcessContext<CartOperationRequest>> {
    @Resource(name="blOrderService")
    protected OrderService orderService;
    @Resource(name="blCatalogService")
    protected CatalogService catalogService;
    @Resource(name="blProductOptionValidationService")
    protected ProductOptionValidationService productOptionValidationService;
    @Resource(name="blOrderItemService")
    protected OrderItemService orderItemService;

    @Override
    public ProcessContext<CartOperationRequest> execute(ProcessContext<CartOperationRequest> context) throws Exception {
        OrderItem parent;
        CartOperationRequest request = context.getSeedData();
        OrderItemRequestDTO orderItemRequestDTO = request.getItemRequest();
        if (orderItemRequestDTO.getQuantity() == null || orderItemRequestDTO.getQuantity() == 0) {
            context.stopProcess();
            return context;
        }
        if (orderItemRequestDTO.getQuantity() < 0) {
            throw new IllegalArgumentException("Quantity cannot be negative");
        }
        if (request.getOrder() == null) {
            throw new IllegalArgumentException("Order is required when adding item to order");
        }
        Product product = null;
        if (orderItemRequestDTO.getProductId() != null && (product = this.catalogService.findProductById(orderItemRequestDTO.getProductId())) == null) {
            throw new IllegalArgumentException("Product was specified but no matching product was found for productId " + orderItemRequestDTO.getProductId());
        }
        Sku sku = this.determineSku(product, orderItemRequestDTO.getSkuId(), orderItemRequestDTO.getItemAttributes(), (ActivityMessages)((Object)context));
        if (sku == null && !(orderItemRequestDTO instanceof NonDiscreteOrderItemRequestDTO)) {
            StringBuilder sb = new StringBuilder();
            for (Map.Entry<String, String> entry : orderItemRequestDTO.getItemAttributes().entrySet()) {
                sb.append(entry.toString());
            }
            throw new IllegalArgumentException("Could not find SKU for : productId: " + (product == null ? "null" : product.getId()) + " skuId: " + orderItemRequestDTO.getSkuId() + " attributes: " + sb.toString());
        }
        if (sku == null) {
            NonDiscreteOrderItemRequestDTO ndr = (NonDiscreteOrderItemRequestDTO)orderItemRequestDTO;
            if (StringUtils.isBlank((String)ndr.getItemName())) {
                throw new IllegalArgumentException("Item name is required for non discrete order item add requests");
            }
            if (ndr.getOverrideRetailPrice() == null && ndr.getOverrideSalePrice() == null) {
                throw new IllegalArgumentException("At least one override price is required for non discrete order item add requests");
            }
        } else {
            if (!sku.isActive()) {
                throw new IllegalArgumentException("The requested skuId of " + sku.getId() + " is no longer active");
            }
            request.getItemRequest().setSkuId(sku.getId());
        }
        if (!(orderItemRequestDTO instanceof NonDiscreteOrderItemRequestDTO) && request.getOrder().getCurrency() != null && sku.getCurrency() != null && !request.getOrder().getCurrency().equals(sku.getCurrency())) {
            throw new IllegalArgumentException("Cannot have items with differing currencies in one cart");
        }
        if (orderItemRequestDTO.getParentOrderItemId() != null && (parent = this.orderItemService.readOrderItemById(orderItemRequestDTO.getParentOrderItemId())) == null) {
            throw new IllegalArgumentException("Could not find parent order item by the given id");
        }
        return context;
    }

    protected Sku determineSku(Product product, Long skuId, Map<String, String> attributeValues, ActivityMessages messages) {
        Sku sku = this.findMatchingSku(product, attributeValues, messages);
        if (sku == null && skuId != null) {
            sku = this.catalogService.findSkuById(skuId);
        }
        if (sku == null && product != null) {
            if (product.getAdditionalSkus() != null && product.getAdditionalSkus().size() > 0 && !product.getCanSellWithoutOptions().booleanValue()) {
                throw new RequiredAttributeNotProvidedException("Unable to find non-default sku matching given options and cannot sell default sku", null);
            }
            sku = product.getDefaultSku();
        }
        return sku;
    }

    protected Sku findMatchingSku(Product product, Map<String, String> attributeValues, ActivityMessages messages) {
        HashMap<String, String> attributeValuesForSku = new HashMap<String, String>();
        if (product != null && product.getProductOptions() != null && product.getProductOptions().size() > 0) {
            for (ProductOption productOption : product.getProductOptions()) {
                if (productOption.getRequired().booleanValue() && (productOption.getProductOptionValidationStrategyType() == null || productOption.getProductOptionValidationStrategyType().getRank() <= ProductOptionValidationStrategyType.ADD_ITEM.getRank())) {
                    if (StringUtils.isEmpty((String)attributeValues.get(productOption.getAttributeName()))) {
                        throw new RequiredAttributeNotProvidedException("Unable to add to product (" + product.getId() + ") cart. Required attribute was not provided: " + productOption.getAttributeName());
                    }
                    if (productOption.getUseInSkuGeneration().booleanValue()) {
                        attributeValuesForSku.put(productOption.getAttributeName(), attributeValues.get(productOption.getAttributeName()));
                    }
                }
                if (!(!productOption.getRequired().booleanValue() && StringUtils.isEmpty((String)attributeValues.get(productOption.getAttributeName())) || productOption.getProductOptionValidationType() == null || productOption.getProductOptionValidationStrategyType() != null && productOption.getProductOptionValidationStrategyType().getRank() > ProductOptionValidationStrategyType.ADD_ITEM.getRank())) {
                    this.productOptionValidationService.validate(productOption, attributeValues.get(productOption.getAttributeName()));
                }
                if (productOption.getProductOptionValidationStrategyType() == null || productOption.getProductOptionValidationStrategyType().getRank() <= ProductOptionValidationStrategyType.ADD_ITEM.getRank()) continue;
                try {
                    this.productOptionValidationService.validate(productOption, attributeValues.get(productOption.getAttributeName()));
                }
                catch (ProductOptionValidationException e) {
                    ActivityMessageDTO msg = new ActivityMessageDTO(MessageType.PRODUCT_OPTION.getType(), 1, e.getMessage());
                    msg.setErrorCode(productOption.getErrorCode());
                    messages.getActivityMessages().add(msg);
                }
            }
            if (product != null && product.getSkus() != null) {
                for (Sku sku : product.getSkus()) {
                    if (!this.checkSkuForMatch(sku, attributeValuesForSku)) continue;
                    return sku;
                }
            }
        }
        return null;
    }

    protected boolean checkSkuForMatch(Sku sku, Map<String, String> attributeValues) {
        if (attributeValues == null || attributeValues.size() == 0) {
            return false;
        }
        for (String attributeName : attributeValues.keySet()) {
            boolean optionValueMatchFound = false;
            for (ProductOptionValue productOptionValue : sku.getProductOptionValues()) {
                if (!productOptionValue.getProductOption().getAttributeName().equals(attributeName)) continue;
                if (productOptionValue.getAttributeValue().equals(attributeValues.get(attributeName))) {
                    optionValueMatchFound = true;
                    break;
                }
                return false;
            }
            if (optionValueMatchFound) continue;
            return false;
        }
        return true;
    }
}

