/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.core.offer.service;

import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.broadleafcommerce.core.offer.domain.Offer;
import org.broadleafcommerce.core.offer.domain.OfferItemCriteria;
import org.broadleafcommerce.core.offer.domain.OrderItemPriceDetailAdjustment;
import org.broadleafcommerce.core.offer.service.discount.domain.PromotableCandidateItemOffer;
import org.broadleafcommerce.core.offer.service.discount.domain.PromotableOrder;
import org.broadleafcommerce.core.offer.service.discount.domain.PromotableOrderItem;
import org.broadleafcommerce.core.offer.service.discount.domain.PromotableOrderItemPriceDetail;
import org.broadleafcommerce.core.offer.service.processor.ItemOfferMarkTargets;
import org.broadleafcommerce.core.order.domain.Order;
import org.broadleafcommerce.core.order.domain.OrderItem;
import org.broadleafcommerce.core.order.domain.OrderItemPriceDetail;
import org.broadleafcommerce.core.order.domain.OrderItemQualifier;
import org.broadleafcommerce.core.order.domain.dto.OrderItemHolder;

public interface OfferServiceUtilities {
    public void sortTargetItemDetails(List<PromotableOrderItemPriceDetail> var1, boolean var2);

    public void sortQualifierItemDetails(List<PromotableOrderItemPriceDetail> var1, boolean var2);

    public OrderItem findRelatedQualifierRoot(OrderItem var1);

    public boolean itemOfferCanBeApplied(PromotableCandidateItemOffer var1, List<PromotableOrderItemPriceDetail> var2);

    public int markQualifiersForCriteria(PromotableCandidateItemOffer var1, OfferItemCriteria var2, List<PromotableOrderItemPriceDetail> var3);

    public int markTargetsForCriteria(PromotableCandidateItemOffer var1, OrderItem var2, boolean var3, Offer var4, OrderItem var5, OfferItemCriteria var6, List<PromotableOrderItemPriceDetail> var7, int var8);

    public int markRelatedQualifiersAndTargetsForItemCriteria(PromotableCandidateItemOffer var1, PromotableOrder var2, OrderItemHolder var3, OfferItemCriteria var4, List<PromotableOrderItemPriceDetail> var5, ItemOfferMarkTargets var6);

    public void applyAdjustmentsForItemPriceDetails(PromotableCandidateItemOffer var1, List<PromotableOrderItemPriceDetail> var2);

    public void applyOrderItemAdjustment(PromotableCandidateItemOffer var1, PromotableOrderItemPriceDetail var2);

    public List<OrderItem> buildOrderItemList(Order var1);

    public Map<OrderItem, PromotableOrderItem> buildPromotableItemMap(PromotableOrder var1);

    public Map<Long, OrderItemPriceDetailAdjustment> buildItemDetailAdjustmentMap(OrderItemPriceDetail var1);

    public void updatePriceDetail(OrderItemPriceDetail var1, PromotableOrderItemPriceDetail var2);

    public void removeUnmatchedPriceDetails(Map<Long, ? extends OrderItemPriceDetail> var1, Iterator<? extends OrderItemPriceDetail> var2);

    public void removeUnmatchedQualifiers(Map<Long, ? extends OrderItemQualifier> var1, Iterator<? extends OrderItemQualifier> var2);
}

