/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.core.order.domain;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.persistence.CascadeType;
import javax.persistence.CollectionTable;
import javax.persistence.Column;
import javax.persistence.ElementCollection;
import javax.persistence.Entity;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.MapKeyColumn;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import org.broadleafcommerce.common.currency.domain.BroadleafCurrency;
import org.broadleafcommerce.common.currency.util.BroadleafCurrencyUtils;
import org.broadleafcommerce.common.money.Money;
import org.broadleafcommerce.common.presentation.AdminPresentation;
import org.broadleafcommerce.common.presentation.AdminPresentationClass;
import org.broadleafcommerce.common.presentation.AdminPresentationToOneLookup;
import org.broadleafcommerce.common.presentation.client.SupportedFieldType;
import org.broadleafcommerce.core.catalog.domain.Product;
import org.broadleafcommerce.core.catalog.domain.ProductImpl;
import org.broadleafcommerce.core.catalog.domain.Sku;
import org.broadleafcommerce.core.catalog.domain.SkuBundleItem;
import org.broadleafcommerce.core.catalog.domain.SkuBundleItemImpl;
import org.broadleafcommerce.core.catalog.domain.SkuImpl;
import org.broadleafcommerce.core.order.domain.BundleOrderItem;
import org.broadleafcommerce.core.order.domain.BundleOrderItemImpl;
import org.broadleafcommerce.core.order.domain.DiscreteOrderItem;
import org.broadleafcommerce.core.order.domain.DiscreteOrderItemFeePrice;
import org.broadleafcommerce.core.order.domain.DiscreteOrderItemFeePriceImpl;
import org.broadleafcommerce.core.order.domain.Order;
import org.broadleafcommerce.core.order.domain.OrderItem;
import org.broadleafcommerce.core.order.domain.OrderItemImpl;
import org.hibernate.annotations.BatchSize;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.hibernate.annotations.Index;
import org.hibernate.annotations.NotFound;
import org.hibernate.annotations.NotFoundAction;

@Entity
@Inheritance(strategy=InheritanceType.JOINED)
@Table(name="BLC_DISCRETE_ORDER_ITEM")
@Cache(usage=CacheConcurrencyStrategy.NONSTRICT_READ_WRITE, region="blOrderElements")
@AdminPresentationClass(friendlyName="DiscreteOrderItemImpl_discreteOrderItem")
public class DiscreteOrderItemImpl
extends OrderItemImpl
implements DiscreteOrderItem {
    private static final long serialVersionUID = 1L;
    @Column(name="BASE_RETAIL_PRICE", precision=19, scale=5)
    @AdminPresentation(excluded=true, friendlyName="DiscreteOrderItemImpl_Base_Retail_Price", order=2, group="DiscreteOrderItemImpl_Pricing", fieldType=SupportedFieldType.MONEY)
    protected BigDecimal baseRetailPrice;
    @Column(name="BASE_SALE_PRICE", precision=19, scale=5)
    @AdminPresentation(excluded=true, friendlyName="DiscreteOrderItemImpl_Base_Sale_Price", order=2, group="DiscreteOrderItemImpl_Pricing", fieldType=SupportedFieldType.MONEY)
    protected BigDecimal baseSalePrice;
    @ManyToOne(targetEntity=SkuImpl.class, optional=false)
    @JoinColumn(name="SKU_ID", nullable=false)
    @Index(name="DISCRETE_SKU_INDEX", columnNames={"SKU_ID"})
    @AdminPresentation(friendlyName="DiscreteOrderItemImpl_Sku", order=3000, group="OrderItemImpl_Catalog", groupOrder=3000)
    @AdminPresentationToOneLookup
    protected Sku sku;
    @ManyToOne(targetEntity=ProductImpl.class)
    @JoinColumn(name="PRODUCT_ID")
    @Index(name="DISCRETE_PRODUCT_INDEX", columnNames={"PRODUCT_ID"})
    @NotFound(action=NotFoundAction.IGNORE)
    @AdminPresentation(friendlyName="DiscreteOrderItemImpl_Product", order=2000, group="OrderItemImpl_Catalog", groupOrder=3000)
    @AdminPresentationToOneLookup
    protected Product product;
    @ManyToOne(targetEntity=BundleOrderItemImpl.class)
    @JoinColumn(name="BUNDLE_ORDER_ITEM_ID")
    @AdminPresentation(excluded=true)
    protected BundleOrderItem bundleOrderItem;
    @ManyToOne(targetEntity=SkuBundleItemImpl.class)
    @JoinColumn(name="SKU_BUNDLE_ITEM_ID")
    @AdminPresentation(excluded=true)
    protected SkuBundleItem skuBundleItem;
    @ElementCollection
    @MapKeyColumn(name="NAME")
    @Column(name="VALUE")
    @CollectionTable(name="BLC_ORDER_ITEM_ADD_ATTR", joinColumns={@JoinColumn(name="ORDER_ITEM_ID")})
    @BatchSize(size=50)
    @Deprecated
    protected Map<String, String> additionalAttributes = new HashMap<String, String>();
    @OneToMany(mappedBy="discreteOrderItem", targetEntity=DiscreteOrderItemFeePriceImpl.class, cascade={CascadeType.ALL}, orphanRemoval=true)
    @Cache(usage=CacheConcurrencyStrategy.NONSTRICT_READ_WRITE, region="blOrderElements")
    protected List<DiscreteOrderItemFeePrice> discreteOrderItemFeePrices = new ArrayList<DiscreteOrderItemFeePrice>();

    @Override
    public Sku getSku() {
        return this.sku;
    }

    @Override
    public void setSku(Sku sku) {
        this.sku = sku;
        if (sku.hasRetailPrice()) {
            this.baseRetailPrice = sku.getRetailPrice().getAmount();
        }
        if (sku.hasSalePrice()) {
            this.baseSalePrice = sku.getSalePrice().getAmount();
        }
        this.itemTaxable = sku.isTaxable();
        this.setName(sku.getName());
    }

    @Override
    public Boolean isTaxable() {
        return this.sku == null || this.sku.isTaxable() == null || this.sku.isTaxable() != false;
    }

    @Override
    public Product getProduct() {
        return this.product;
    }

    @Override
    public void setProduct(Product product) {
        this.product = product;
    }

    @Override
    public BundleOrderItem getBundleOrderItem() {
        return this.bundleOrderItem;
    }

    @Override
    public void setBundleOrderItem(BundleOrderItem bundleOrderItem) {
        if (this.order != null && bundleOrderItem != null) {
            throw new IllegalStateException("Cannot set a BundleOrderItem on a DiscreteOrderItem that is already associated with an Order");
        }
        this.bundleOrderItem = bundleOrderItem;
    }

    @Override
    public void setOrder(Order order) {
        if (order != null && this.bundleOrderItem != null) {
            throw new IllegalStateException("Cannot set an Order on a DiscreteOrderItem that is already associated with a BundleOrderItem");
        }
        this.order = order;
    }

    @Override
    public SkuBundleItem getSkuBundleItem() {
        return this.skuBundleItem;
    }

    @Override
    public void setSkuBundleItem(SkuBundleItem SkuBundleItem2) {
        this.skuBundleItem = SkuBundleItem2;
    }

    @Override
    public String getName() {
        String name = super.getName();
        if (name == null) {
            return this.sku.getName();
        }
        return name;
    }

    @Override
    public Order getOrder() {
        if (this.order == null && this.getBundleOrderItem() != null) {
            return this.getBundleOrderItem().getOrder();
        }
        return this.order;
    }

    private boolean updateSalePrice() {
        Money skuSalePrice;
        if (this.isSalePriceOverride()) {
            return false;
        }
        Money money = skuSalePrice = this.getSku().getSalePrice() == null ? null : this.getSku().getSalePrice();
        if (this.skuBundleItem != null && this.skuBundleItem.getSalePrice() != null) {
            skuSalePrice = this.skuBundleItem.getSalePrice();
        }
        boolean updated = false;
        if (skuSalePrice != null && !skuSalePrice.getAmount().equals(this.salePrice)) {
            this.baseSalePrice = skuSalePrice.getAmount();
            this.salePrice = skuSalePrice.getAmount();
            updated = true;
        }
        if (this.getDiscreteOrderItemFeePrices() != null) {
            for (DiscreteOrderItemFeePrice fee : this.getDiscreteOrderItemFeePrices()) {
                Money returnPrice = this.convertToMoney(this.salePrice);
                this.salePrice = returnPrice.add(fee.getAmount()).getAmount();
            }
        }
        return updated;
    }

    private boolean updateRetailPrice() {
        if (this.isRetailPriceOverride()) {
            return false;
        }
        Money skuRetailPrice = this.getSku().getRetailPrice();
        if (this.skuBundleItem != null && this.skuBundleItem.getRetailPrice() != null) {
            skuRetailPrice = this.skuBundleItem.getRetailPrice();
        }
        boolean updated = false;
        if (!skuRetailPrice.getAmount().equals(this.retailPrice)) {
            this.baseRetailPrice = skuRetailPrice.getAmount();
            this.retailPrice = skuRetailPrice.getAmount();
            updated = true;
        }
        if (this.getDiscreteOrderItemFeePrices() != null) {
            for (DiscreteOrderItemFeePrice fee : this.getDiscreteOrderItemFeePrices()) {
                Money returnPrice = this.convertToMoney(this.retailPrice);
                this.retailPrice = returnPrice.add(fee.getAmount()).getAmount();
            }
        }
        return updated;
    }

    @Override
    public boolean updateSaleAndRetailPrices() {
        boolean salePriceUpdated = this.updateSalePrice();
        boolean retailPriceUpdated = this.updateRetailPrice();
        if (!this.isRetailPriceOverride() && !this.isSalePriceOverride()) {
            this.price = this.salePrice != null && this.salePrice.compareTo(this.retailPrice) <= 0 ? this.salePrice : this.retailPrice;
        }
        return salePriceUpdated || retailPriceUpdated;
    }

    @Override
    public Map<String, String> getAdditionalAttributes() {
        return this.additionalAttributes;
    }

    @Override
    public void setAdditionalAttributes(Map<String, String> additionalAttributes) {
        this.additionalAttributes = additionalAttributes;
    }

    @Override
    public Money getBaseRetailPrice() {
        return this.convertToMoney(this.baseRetailPrice);
    }

    @Override
    public void setBaseRetailPrice(Money baseRetailPrice) {
        this.baseRetailPrice = baseRetailPrice.getAmount();
    }

    @Override
    public Money getBaseSalePrice() {
        return this.convertToMoney(this.baseSalePrice);
    }

    @Override
    public void setBaseSalePrice(Money baseSalePrice) {
        this.baseSalePrice = baseSalePrice == null ? null : baseSalePrice.getAmount();
    }

    @Override
    public List<DiscreteOrderItemFeePrice> getDiscreteOrderItemFeePrices() {
        return this.discreteOrderItemFeePrices;
    }

    @Override
    public void setDiscreteOrderItemFeePrices(List<DiscreteOrderItemFeePrice> discreteOrderItemFeePrices) {
        this.discreteOrderItemFeePrices = discreteOrderItemFeePrices;
    }

    @Override
    protected Money convertToMoney(BigDecimal amount) {
        return amount == null ? null : BroadleafCurrencyUtils.getMoney((BigDecimal)amount, (BroadleafCurrency)this.getOrder().getCurrency());
    }

    @Override
    public OrderItem clone() {
        DiscreteOrderItem orderItem = (DiscreteOrderItem)super.clone();
        if (this.discreteOrderItemFeePrices != null) {
            for (DiscreteOrderItemFeePrice feePrice : this.discreteOrderItemFeePrices) {
                DiscreteOrderItemFeePrice cloneFeePrice = feePrice.clone();
                cloneFeePrice.setDiscreteOrderItem(orderItem);
                orderItem.getDiscreteOrderItemFeePrices().add(cloneFeePrice);
            }
        }
        if (this.additionalAttributes != null) {
            orderItem.getAdditionalAttributes().putAll(this.additionalAttributes);
        }
        orderItem.setBaseRetailPrice(this.convertToMoney(this.baseRetailPrice));
        orderItem.setBaseSalePrice(this.convertToMoney(this.baseSalePrice));
        orderItem.setBundleOrderItem(this.bundleOrderItem);
        orderItem.setProduct(this.product);
        orderItem.setSku(this.sku);
        if (orderItem.getOrder() == null) {
            throw new IllegalStateException("Either an Order or a BundleOrderItem must be set on the DiscreteOrderItem");
        }
        return orderItem;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DiscreteOrderItemImpl other = (DiscreteOrderItemImpl)obj;
        if (!super.equals(obj)) {
            return false;
        }
        if (this.id != null && other.id != null) {
            return this.id.equals(other.id);
        }
        if (this.bundleOrderItem == null ? other.bundleOrderItem != null : !this.bundleOrderItem.equals(other.bundleOrderItem)) {
            return false;
        }
        return !(this.sku == null ? other.sku != null : !this.sku.equals(other.sku));
    }

    @Override
    public int hashCode() {
        int prime = super.hashCode();
        int result = 1;
        result = prime * result + (this.bundleOrderItem == null ? 0 : this.bundleOrderItem.hashCode());
        result = prime * result + (this.sku == null ? 0 : this.sku.hashCode());
        return result;
    }

    @Override
    public boolean isDiscountingAllowed() {
        if (this.discountsAllowed == null) {
            return this.sku.isDiscountable();
        }
        return this.discountsAllowed;
    }

    @Override
    public BundleOrderItem findParentItem() {
        for (OrderItem orderItem : this.getOrder().getOrderItems()) {
            if (!(orderItem instanceof BundleOrderItem)) continue;
            BundleOrderItem bundleItem = (BundleOrderItem)orderItem;
            for (OrderItem orderItem2 : bundleItem.getOrderItems()) {
                if (!orderItem2.equals(this)) continue;
                return bundleItem;
            }
        }
        return null;
    }

    @Override
    public boolean isSkuActive() {
        return this.sku.isActive();
    }

    public static class Presentation {

        public static class FieldOrder {
            public static final int PRODUCT = 2000;
            public static final int SKU = 3000;
        }

        public static class Group {

            public static class Order {
            }

            public static class Name {
            }
        }

        public static class Tab {

            public static class Order {
                public static final int OrderItems = 2000;
            }

            public static class Name {
                public static final String OrderItems = "OrderImpl_Order_Items_Tab";
            }
        }
    }
}

