/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.core.payment.domain.secure;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;
import javax.persistence.Table;
import javax.persistence.Transient;
import org.broadleafcommerce.common.encryption.EncryptionModule;
import org.broadleafcommerce.core.payment.domain.secure.CreditCardPayment;
import org.hibernate.annotations.GenericGenerator;
import org.hibernate.annotations.Index;
import org.hibernate.annotations.Parameter;

@Entity
@Inheritance(strategy=InheritanceType.JOINED)
@Table(name="BLC_CREDIT_CARD_PAYMENT")
public class CreditCardPaymentInfoImpl
implements CreditCardPayment {
    private static final long serialVersionUID = 1L;
    @Transient
    protected EncryptionModule encryptionModule;
    @Id
    @GeneratedValue(generator="CreditCardPaymentId")
    @GenericGenerator(name="CreditCardPaymentId", strategy="org.broadleafcommerce.common.persistence.IdOverrideTableGenerator", parameters={@Parameter(name="segment_value", value="CreditCardPaymentInfoImpl"), @Parameter(name="entity_name", value="org.broadleafcommerce.core.payment.domain.CreditCardPaymentInfoImpl")})
    @Column(name="PAYMENT_ID")
    protected Long id;
    @Column(name="REFERENCE_NUMBER", nullable=false)
    @Index(name="CREDITCARD_INDEX", columnNames={"REFERENCE_NUMBER"})
    protected String referenceNumber;
    @Column(name="PAN", nullable=false)
    protected String pan;
    @Column(name="EXPIRATION_MONTH", nullable=false)
    protected Integer expirationMonth;
    @Column(name="EXPIRATION_YEAR", nullable=false)
    protected Integer expirationYear;
    @Column(name="NAME_ON_CARD", nullable=false)
    protected String nameOnCard;
    @Transient
    protected String cvvCode;

    protected CreditCardPaymentInfoImpl() {
    }

    @Override
    public Long getId() {
        return this.id;
    }

    @Override
    public void setId(Long id) {
        this.id = id;
    }

    @Override
    public String getReferenceNumber() {
        return this.referenceNumber;
    }

    @Override
    public void setReferenceNumber(String referenceNumber) {
        this.referenceNumber = referenceNumber;
    }

    @Override
    public String getPan() {
        return this.encryptionModule.decrypt(this.pan);
    }

    @Override
    public void setPan(String pan) {
        this.pan = this.encryptionModule.encrypt(pan);
    }

    @Override
    public Integer getExpirationMonth() {
        return this.expirationMonth;
    }

    @Override
    public void setExpirationMonth(Integer expirationMonth) {
        this.expirationMonth = expirationMonth;
    }

    @Override
    public Integer getExpirationYear() {
        return this.expirationYear;
    }

    @Override
    public void setExpirationYear(Integer expirationYear) {
        this.expirationYear = expirationYear;
    }

    @Override
    public String getNameOnCard() {
        return this.nameOnCard;
    }

    @Override
    public void setNameOnCard(String nameOnCard) {
        this.nameOnCard = nameOnCard;
    }

    @Override
    public String getCvvCode() {
        return this.cvvCode;
    }

    @Override
    public void setCvvCode(String cvvCode) {
        this.cvvCode = cvvCode;
    }

    @Override
    public EncryptionModule getEncryptionModule() {
        return this.encryptionModule;
    }

    @Override
    public void setEncryptionModule(EncryptionModule encryptionModule) {
        this.encryptionModule = encryptionModule;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.expirationMonth == null ? 0 : this.expirationMonth.hashCode());
        result = 31 * result + (this.expirationYear == null ? 0 : this.expirationYear.hashCode());
        result = 31 * result + (this.pan == null ? 0 : this.pan.hashCode());
        result = 31 * result + (this.referenceNumber == null ? 0 : this.referenceNumber.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CreditCardPaymentInfoImpl other = (CreditCardPaymentInfoImpl)obj;
        if (this.id != null && other.id != null) {
            return this.id.equals(other.id);
        }
        if (this.expirationMonth == null ? other.expirationMonth != null : !this.expirationMonth.equals(other.expirationMonth)) {
            return false;
        }
        if (this.expirationYear == null ? other.expirationYear != null : !this.expirationYear.equals(other.expirationYear)) {
            return false;
        }
        if (this.pan == null ? other.pan != null : !this.pan.equals(other.pan)) {
            return false;
        }
        return !(this.referenceNumber == null ? other.referenceNumber != null : !this.referenceNumber.equals(other.referenceNumber));
    }
}

