/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.core.offer.domain;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Embedded;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.Lob;
import javax.persistence.ManyToMany;
import javax.persistence.MapKeyColumn;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.broadleafcommerce.common.admin.domain.AdminMainEntity;
import org.broadleafcommerce.common.currency.util.BroadleafCurrencyUtils;
import org.broadleafcommerce.common.extensibility.jpa.clone.ClonePolicyCollection;
import org.broadleafcommerce.common.extensibility.jpa.clone.ClonePolicyMap;
import org.broadleafcommerce.common.extensibility.jpa.copy.DirectCopyTransform;
import org.broadleafcommerce.common.extensibility.jpa.copy.DirectCopyTransformMember;
import org.broadleafcommerce.common.i18n.service.DynamicTranslationProvider;
import org.broadleafcommerce.common.money.Money;
import org.broadleafcommerce.common.persistence.ArchiveStatus;
import org.broadleafcommerce.common.presentation.AdminPresentation;
import org.broadleafcommerce.common.presentation.AdminPresentationClass;
import org.broadleafcommerce.common.presentation.AdminPresentationCollection;
import org.broadleafcommerce.common.presentation.AdminPresentationMapField;
import org.broadleafcommerce.common.presentation.AdminPresentationMapFields;
import org.broadleafcommerce.common.presentation.PopulateToOneFieldsEnum;
import org.broadleafcommerce.common.presentation.RequiredOverride;
import org.broadleafcommerce.common.presentation.client.AddMethodType;
import org.broadleafcommerce.common.presentation.client.SupportedFieldType;
import org.broadleafcommerce.common.presentation.client.VisibilityEnum;
import org.broadleafcommerce.common.util.DateUtil;
import org.broadleafcommerce.core.offer.domain.Offer;
import org.broadleafcommerce.core.offer.domain.OfferCode;
import org.broadleafcommerce.core.offer.domain.OfferCodeImpl;
import org.broadleafcommerce.core.offer.domain.OfferItemCriteria;
import org.broadleafcommerce.core.offer.domain.OfferItemCriteriaImpl;
import org.broadleafcommerce.core.offer.domain.OfferRule;
import org.broadleafcommerce.core.offer.domain.OfferRuleImpl;
import org.broadleafcommerce.core.offer.service.type.OfferDeliveryType;
import org.broadleafcommerce.core.offer.service.type.OfferDiscountType;
import org.broadleafcommerce.core.offer.service.type.OfferItemRestrictionRuleType;
import org.broadleafcommerce.core.offer.service.type.OfferType;
import org.codehaus.jackson.annotate.JsonIgnore;
import org.hibernate.annotations.BatchSize;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.hibernate.annotations.GenericGenerator;
import org.hibernate.annotations.Index;
import org.hibernate.annotations.Parameter;
import org.hibernate.annotations.SQLDelete;
import org.hibernate.annotations.Type;

@Entity
@Table(name="BLC_OFFER")
@Inheritance(strategy=InheritanceType.JOINED)
@Cache(usage=CacheConcurrencyStrategy.READ_WRITE, region="blOffers")
@AdminPresentationClass(populateToOneFields=PopulateToOneFieldsEnum.TRUE, friendlyName="OfferImpl_baseOffer")
@SQLDelete(sql="UPDATE BLC_OFFER SET ARCHIVED = 'Y' WHERE OFFER_ID = ?")
@DirectCopyTransform(value={@DirectCopyTransformMember(templateTokens={"sandbox"}, skipOverlaps=true), @DirectCopyTransformMember(templateTokens={"sandboxOfferInvocation"}), @DirectCopyTransformMember(templateTokens={"multiTenantCatalog"}), @DirectCopyTransformMember(templateTokens={"multiTenantSite"})})
public class OfferImpl
implements Offer,
AdminMainEntity {
    public static final long serialVersionUID = 1L;
    @Id
    @GeneratedValue(generator="OfferId")
    @GenericGenerator(name="OfferId", strategy="org.broadleafcommerce.common.persistence.IdOverrideTableGenerator", parameters={@Parameter(name="segment_value", value="OfferImpl"), @Parameter(name="entity_name", value="org.broadleafcommerce.core.offer.domain.OfferImpl")})
    @Column(name="OFFER_ID")
    @AdminPresentation(friendlyName="OfferImpl_Offer_Id", visibility=VisibilityEnum.HIDDEN_ALL)
    protected Long id;
    @OneToMany(mappedBy="offer", targetEntity=OfferCodeImpl.class, cascade={CascadeType.ALL}, orphanRemoval=true)
    @Cache(usage=CacheConcurrencyStrategy.READ_WRITE, region="blOffers")
    @BatchSize(size=50)
    @AdminPresentationCollection(addType=AddMethodType.PERSIST, friendlyName="offerCodeTitle", order=1, tab="OfferImpl_Codes_Tab", tabOrder=1000)
    @ClonePolicyCollection(unowned=true)
    protected List<OfferCode> offerCodes = new ArrayList<OfferCode>(100);
    @Column(name="OFFER_NAME", nullable=false)
    @Index(name="OFFER_NAME_INDEX", columnNames={"OFFER_NAME"})
    @AdminPresentation(friendlyName="OfferImpl_Offer_Name", order=1000, group="OfferImpl_Description", groupOrder=1000, prominent=true, gridOrder=1)
    protected String name;
    @Column(name="OFFER_DESCRIPTION")
    @AdminPresentation(friendlyName="OfferImpl_Offer_Description", order=2000, group="OfferImpl_Description", groupOrder=1000, prominent=true, gridOrder=2, largeEntry=true)
    protected String description;
    @Column(name="MARKETING_MESSASGE")
    @Index(name="OFFER_MARKETING_MESSAGE_INDEX", columnNames={"MARKETING_MESSASGE"})
    @AdminPresentation(friendlyName="OfferImpl_marketingMessage", order=6000, group="OfferImpl_Description", groupOrder=1000, translatable=true)
    protected String marketingMessage;
    @Column(name="OFFER_TYPE", nullable=false)
    @Index(name="OFFER_TYPE_INDEX", columnNames={"OFFER_TYPE"})
    @AdminPresentation(friendlyName="OfferImpl_Offer_Type", order=3000, group="OfferImpl_Description", groupOrder=1000, prominent=true, gridOrder=3, fieldType=SupportedFieldType.BROADLEAF_ENUMERATION, broadleafEnumeration="org.broadleafcommerce.core.offer.service.type.OfferType")
    protected String type;
    @Column(name="OFFER_DISCOUNT_TYPE")
    @Index(name="OFFER_DISCOUNT_INDEX", columnNames={"OFFER_DISCOUNT_TYPE"})
    @AdminPresentation(friendlyName="OfferImpl_Offer_Discount_Type", order=1000, group="OfferImpl_Amount", groupOrder=2000, requiredOverride=RequiredOverride.REQUIRED, fieldType=SupportedFieldType.BROADLEAF_ENUMERATION, broadleafEnumeration="org.broadleafcommerce.core.offer.service.type.OfferDiscountType")
    protected String discountType;
    @Column(name="OFFER_VALUE", nullable=false, precision=19, scale=5)
    @AdminPresentation(friendlyName="OfferImpl_Offer_Value", order=2000, group="OfferImpl_Amount", groupOrder=2000, prominent=true, gridOrder=4)
    protected BigDecimal value;
    @Column(name="OFFER_PRIORITY")
    @AdminPresentation(friendlyName="OfferImpl_Offer_Priority", order=7, tab="OfferImpl_Advanced_Tab", tabOrder=2000, group="OfferImpl_Advanced", groupOrder=1000)
    protected Integer priority;
    @Column(name="START_DATE")
    @AdminPresentation(friendlyName="OfferImpl_Offer_Start_Date", order=1, group="OfferImpl_Activity_Range", groupOrder=3000)
    protected Date startDate;
    @Column(name="END_DATE")
    @AdminPresentation(friendlyName="OfferImpl_Offer_End_Date", order=2, group="OfferImpl_Activity_Range", groupOrder=3000)
    protected Date endDate;
    @Column(name="STACKABLE")
    protected Boolean stackable = true;
    @Column(name="TARGET_SYSTEM")
    @AdminPresentation(friendlyName="OfferImpl_Offer_Target_System", tab="OfferImpl_Advanced_Tab", tabOrder=2000, group="OfferImpl_Advanced", groupOrder=1000)
    protected String targetSystem;
    @Column(name="APPLY_TO_SALE_PRICE")
    @AdminPresentation(friendlyName="OfferImpl_Apply_To_Sale_Price", tab="OfferImpl_Advanced_Tab", tabOrder=2000, group="OfferImpl_Advanced", groupOrder=1000)
    protected Boolean applyToSalePrice = false;
    @Column(name="APPLIES_TO_RULES", length=0x7FFFFFFE)
    @AdminPresentation(excluded=true)
    @Lob
    @Type(type="org.hibernate.type.StringClobType")
    @Deprecated
    protected String appliesToOrderRules;
    @Column(name="APPLIES_WHEN_RULES", length=0x7FFFFFFE)
    @AdminPresentation(excluded=true)
    @Lob
    @Type(type="org.hibernate.type.StringClobType")
    @Deprecated
    protected String appliesToCustomerRules;
    @Column(name="APPLY_OFFER_TO_MARKED_ITEMS")
    @AdminPresentation(excluded=true)
    @Deprecated
    protected boolean applyDiscountToMarkedItems;
    @Column(name="COMBINABLE_WITH_OTHER_OFFERS")
    @AdminPresentation(friendlyName="OfferImpl_Offer_Combinable", tab="OfferImpl_Advanced_Tab", tabOrder=2000, group="OfferImpl_Advanced", groupOrder=1000)
    protected Boolean combinableWithOtherOffers = true;
    @Column(name="OFFER_DELIVERY_TYPE")
    @AdminPresentation(excluded=true)
    protected String deliveryType;
    @Column(name="AUTOMATICALLY_ADDED")
    @AdminPresentation(friendlyName="OfferImpl_Offer_Automatically_Added", order=5000, group="OfferImpl_Description", groupOrder=1000, fieldType=SupportedFieldType.BOOLEAN)
    protected Boolean automaticallyAdded = false;
    @Column(name="MAX_USES")
    @AdminPresentation(friendlyName="OfferImpl_Offer_Max_Uses_Per_Order", order=7, tab="OfferImpl_Advanced_Tab", tabOrder=2000, group="OfferImpl_Advanced", groupOrder=1000)
    protected Integer maxUsesPerOrder;
    @Column(name="MAX_USES_PER_CUSTOMER")
    @AdminPresentation(friendlyName="OfferImpl_Max_Uses_Per_Customer", order=8, tab="OfferImpl_Advanced_Tab", tabOrder=2000, group="OfferImpl_Advanced", groupOrder=1000)
    protected Long maxUsesPerCustomer;
    @Column(name="USES")
    @AdminPresentation(friendlyName="OfferImpl_Offer_Current_Uses", visibility=VisibilityEnum.HIDDEN_ALL)
    @Deprecated
    protected int uses;
    @Column(name="OFFER_ITEM_QUALIFIER_RULE")
    @AdminPresentation(friendlyName="OfferImpl_Item_Qualifier_Rule", tab="OfferImpl_Advanced_Tab", tabOrder=2000, group="OfferImpl_Advanced", groupOrder=1000, fieldType=SupportedFieldType.BROADLEAF_ENUMERATION, broadleafEnumeration="org.broadleafcommerce.core.offer.service.type.OfferItemRestrictionRuleType")
    protected String offerItemQualifierRuleType;
    @Column(name="OFFER_ITEM_TARGET_RULE")
    @AdminPresentation(friendlyName="OfferImpl_Item_Target_Rule", tab="OfferImpl_Advanced_Tab", tabOrder=2000, group="OfferImpl_Advanced", groupOrder=1000, fieldType=SupportedFieldType.BROADLEAF_ENUMERATION, broadleafEnumeration="org.broadleafcommerce.core.offer.service.type.OfferItemRestrictionRuleType")
    protected String offerItemTargetRuleType;
    @OneToMany(fetch=FetchType.LAZY, targetEntity=OfferItemCriteriaImpl.class, cascade={CascadeType.MERGE, CascadeType.PERSIST})
    @JoinTable(name="BLC_QUAL_CRIT_OFFER_XREF", joinColumns={@JoinColumn(name="OFFER_ID")}, inverseJoinColumns={@JoinColumn(name="OFFER_ITEM_CRITERIA_ID")})
    @Cache(usage=CacheConcurrencyStrategy.READ_WRITE, region="blOffers")
    @AdminPresentation(friendlyName="OfferImpl_Qualifying_Item_Rule", group="OfferImpl_Qualifiers", groupOrder=4000, fieldType=SupportedFieldType.RULE_WITH_QUANTITY, ruleIdentifier="ORDER_ITEM_FIELDS")
    @ClonePolicyCollection
    protected Set<OfferItemCriteria> qualifyingItemCriteria = new HashSet<OfferItemCriteria>();
    @OneToMany(fetch=FetchType.LAZY, targetEntity=OfferItemCriteriaImpl.class, cascade={CascadeType.MERGE, CascadeType.PERSIST})
    @JoinTable(name="BLC_TAR_CRIT_OFFER_XREF", joinColumns={@JoinColumn(name="OFFER_ID")}, inverseJoinColumns={@JoinColumn(name="OFFER_ITEM_CRITERIA_ID")})
    @Cache(usage=CacheConcurrencyStrategy.READ_WRITE, region="blOffers")
    @AdminPresentation(friendlyName="OfferImpl_Target_Item_Rule", group="OfferImpl_Item_Target", groupOrder=5000, fieldType=SupportedFieldType.RULE_WITH_QUANTITY, ruleIdentifier="ORDER_ITEM_FIELDS")
    @ClonePolicyCollection
    protected Set<OfferItemCriteria> targetItemCriteria = new HashSet<OfferItemCriteria>();
    @Column(name="TOTALITARIAN_OFFER")
    @AdminPresentation(friendlyName="OfferImpl_Totalitarian_Offer", tab="OfferImpl_Advanced_Tab", tabOrder=2000, group="OfferImpl_Advanced", groupOrder=1000, visibility=VisibilityEnum.HIDDEN_ALL)
    protected Boolean totalitarianOffer = false;
    @Column(name="REQUIRES_RELATED_TAR_QUAL")
    @AdminPresentation(friendlyName="OfferImpl_Requires_Related_Target_And_Qualifiers", tab="OfferImpl_Advanced_Tab", tabOrder=2000, group="OfferImpl_Advanced", groupOrder=1000, visibility=VisibilityEnum.VISIBLE_ALL)
    protected Boolean requiresRelatedTargetAndQualifiers = false;
    @ManyToMany(targetEntity=OfferRuleImpl.class, cascade={CascadeType.MERGE, CascadeType.PERSIST})
    @JoinTable(name="BLC_OFFER_RULE_MAP", inverseJoinColumns={@JoinColumn(name="OFFER_RULE_ID", referencedColumnName="OFFER_RULE_ID")})
    @MapKeyColumn(name="MAP_KEY", nullable=false)
    @Cache(usage=CacheConcurrencyStrategy.READ_WRITE, region="blOffers")
    @AdminPresentationMapFields(mapDisplayFields={@AdminPresentationMapField(fieldName="CUSTOMER", fieldPresentation=@AdminPresentation(fieldType=SupportedFieldType.RULE_SIMPLE, group="OfferImpl_Qualifiers", groupOrder=4000, ruleIdentifier="CUSTOMER_FIELDS", friendlyName="OfferImpl_Customer_Rule")), @AdminPresentationMapField(fieldName="TIME", fieldPresentation=@AdminPresentation(fieldType=SupportedFieldType.RULE_SIMPLE, group="OfferImpl_Activity_Range", groupOrder=3000, ruleIdentifier="TIME_FIELDS", friendlyName="OfferImpl_Time_Rule")), @AdminPresentationMapField(fieldName="ORDER", fieldPresentation=@AdminPresentation(fieldType=SupportedFieldType.RULE_SIMPLE, group="OfferImpl_Qualifiers", groupOrder=4000, ruleIdentifier="ORDER_FIELDS", friendlyName="OfferImpl_Order_Rule")), @AdminPresentationMapField(fieldName="FULFILLMENT_GROUP", fieldPresentation=@AdminPresentation(fieldType=SupportedFieldType.RULE_SIMPLE, group="OfferImpl_Qualifiers", groupOrder=4000, ruleIdentifier="FULFILLMENT_GROUP_FIELDS", friendlyName="OfferImpl_FG_Rule"))})
    @ClonePolicyMap
    Map<String, OfferRule> offerMatchRules = new HashMap<String, OfferRule>();
    @Column(name="USE_NEW_FORMAT")
    @AdminPresentation(friendlyName="OfferImpl_Treat_As_New_Format", tab="OfferImpl_Advanced_Tab", tabOrder=2000, group="OfferImpl_Advanced", groupOrder=1000, visibility=VisibilityEnum.HIDDEN_ALL)
    protected Boolean treatAsNewFormat = false;
    @Column(name="QUALIFYING_ITEM_MIN_TOTAL", precision=19, scale=5)
    @AdminPresentation(friendlyName="OfferImpl_Qualifying_Item_Subtotal", tab="OfferImpl_Advanced_Tab", tabOrder=2000, group="OfferImpl_Advanced", groupOrder=1000)
    protected BigDecimal qualifyingItemSubTotal;
    @Embedded
    protected ArchiveStatus archiveStatus = new ArchiveStatus();

    @Override
    public Long getId() {
        return this.id;
    }

    @Override
    public void setId(Long id) {
        this.id = id;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public void setDescription(String description) {
        this.description = description;
    }

    @Override
    public OfferType getType() {
        return OfferType.getInstance(this.type);
    }

    @Override
    public void setType(OfferType type) {
        this.type = type.getType();
    }

    @Override
    public OfferDiscountType getDiscountType() {
        return OfferDiscountType.getInstance(this.discountType);
    }

    @Override
    public void setDiscountType(OfferDiscountType discountType) {
        this.discountType = discountType.getType();
    }

    @Override
    public OfferItemRestrictionRuleType getOfferItemQualifierRuleType() {
        OfferItemRestrictionRuleType returnType = OfferItemRestrictionRuleType.getInstance(this.offerItemQualifierRuleType);
        if (returnType == null) {
            return OfferItemRestrictionRuleType.NONE;
        }
        return returnType;
    }

    @Override
    public void setOfferItemQualifierRuleType(OfferItemRestrictionRuleType restrictionRuleType) {
        this.offerItemQualifierRuleType = restrictionRuleType.getType();
    }

    @Override
    public OfferItemRestrictionRuleType getOfferItemTargetRuleType() {
        OfferItemRestrictionRuleType returnType = OfferItemRestrictionRuleType.getInstance(this.offerItemTargetRuleType);
        if (returnType == null) {
            return OfferItemRestrictionRuleType.NONE;
        }
        return returnType;
    }

    @Override
    public void setOfferItemTargetRuleType(OfferItemRestrictionRuleType restrictionRuleType) {
        this.offerItemTargetRuleType = restrictionRuleType.getType();
    }

    @Override
    public BigDecimal getValue() {
        return this.value;
    }

    @Override
    public void setValue(BigDecimal value) {
        this.value = value;
    }

    @Override
    public int getPriority() {
        return this.priority == null ? 0x7FFFFFFE : this.priority;
    }

    @Override
    public void setPriority(int priority) {
        this.priority = priority;
    }

    @Override
    public Date getStartDate() {
        if ('Y' == this.getArchived().charValue()) {
            return null;
        }
        return this.startDate;
    }

    @Override
    public void setStartDate(Date startDate) {
        this.startDate = startDate;
    }

    @Override
    public Date getEndDate() {
        return this.endDate;
    }

    @Override
    public void setEndDate(Date endDate) {
        this.endDate = endDate;
    }

    @Override
    public boolean isStackable() {
        return this.stackable == null ? false : this.stackable;
    }

    @Override
    public void setStackable(boolean stackable) {
        this.stackable = stackable;
    }

    @Deprecated
    @JsonIgnore
    public boolean getStackable() {
        return this.stackable;
    }

    @Override
    public String getTargetSystem() {
        return this.targetSystem;
    }

    @Override
    public void setTargetSystem(String targetSystem) {
        this.targetSystem = targetSystem;
    }

    @Override
    public boolean getApplyDiscountToSalePrice() {
        return this.applyToSalePrice == null ? false : this.applyToSalePrice;
    }

    @Override
    public void setApplyDiscountToSalePrice(boolean applyToSalePrice) {
        this.applyToSalePrice = applyToSalePrice;
    }

    @Override
    @Deprecated
    public String getAppliesToOrderRules() {
        return this.appliesToOrderRules;
    }

    @Override
    @Deprecated
    public void setAppliesToOrderRules(String appliesToOrderRules) {
        this.appliesToOrderRules = appliesToOrderRules;
    }

    @Override
    @Deprecated
    public String getAppliesToCustomerRules() {
        return this.appliesToCustomerRules;
    }

    @Override
    @Deprecated
    public void setAppliesToCustomerRules(String appliesToCustomerRules) {
        this.appliesToCustomerRules = appliesToCustomerRules;
    }

    @Override
    @Deprecated
    public boolean isApplyDiscountToMarkedItems() {
        return this.applyDiscountToMarkedItems;
    }

    @Deprecated
    @JsonIgnore
    public boolean getApplyDiscountToMarkedItems() {
        return this.applyDiscountToMarkedItems;
    }

    @Override
    @Deprecated
    public void setApplyDiscountToMarkedItems(boolean applyDiscountToMarkedItems) {
        this.applyDiscountToMarkedItems = applyDiscountToMarkedItems;
    }

    @Override
    public boolean isCombinableWithOtherOffers() {
        return this.combinableWithOtherOffers == null ? false : this.combinableWithOtherOffers;
    }

    @Override
    public void setCombinableWithOtherOffers(boolean combinableWithOtherOffers) {
        this.combinableWithOtherOffers = combinableWithOtherOffers;
    }

    @Deprecated
    @JsonIgnore
    public boolean getCombinableWithOtherOffers() {
        return this.combinableWithOtherOffers;
    }

    @Override
    public boolean isAutomaticallyAdded() {
        if (this.automaticallyAdded == null) {
            if (this.deliveryType != null) {
                OfferDeliveryType offerDeliveryType = OfferDeliveryType.getInstance(this.deliveryType);
                return OfferDeliveryType.AUTOMATIC.equals(offerDeliveryType);
            }
            return false;
        }
        return this.automaticallyAdded;
    }

    @Override
    public void setAutomaticallyAdded(boolean automaticallyAdded) {
        this.automaticallyAdded = automaticallyAdded;
    }

    @Override
    @Deprecated
    @JsonIgnore
    public OfferDeliveryType getDeliveryType() {
        if (this.deliveryType == null) {
            if (this.isAutomaticallyAdded()) {
                return OfferDeliveryType.AUTOMATIC;
            }
            return OfferDeliveryType.MANUAL;
        }
        return OfferDeliveryType.getInstance(this.deliveryType);
    }

    @Override
    public void setDeliveryType(OfferDeliveryType deliveryType) {
        this.deliveryType = deliveryType.getType();
    }

    @Override
    public Long getMaxUsesPerCustomer() {
        return this.maxUsesPerCustomer == null ? 0L : this.maxUsesPerCustomer;
    }

    @Override
    public void setMaxUsesPerCustomer(Long maxUsesPerCustomer) {
        this.maxUsesPerCustomer = maxUsesPerCustomer;
    }

    @Override
    public boolean isUnlimitedUsePerCustomer() {
        return this.getMaxUsesPerCustomer() == 0L;
    }

    @Override
    public boolean isLimitedUsePerCustomer() {
        return this.getMaxUsesPerCustomer() > 0L;
    }

    @Override
    public int getMaxUsesPerOrder() {
        return this.maxUsesPerOrder == null ? 0 : this.maxUsesPerOrder;
    }

    @Override
    public void setMaxUsesPerOrder(int maxUsesPerOrder) {
        this.maxUsesPerOrder = maxUsesPerOrder;
    }

    @Override
    public boolean isUnlimitedUsePerOrder() {
        return this.getMaxUsesPerOrder() == 0;
    }

    @Override
    public boolean isLimitedUsePerOrder() {
        return this.getMaxUsesPerOrder() > 0;
    }

    @Override
    @Deprecated
    public int getMaxUses() {
        return this.getMaxUsesPerOrder();
    }

    @Override
    public void setMaxUses(int maxUses) {
        this.setMaxUsesPerOrder(maxUses);
    }

    @Override
    @Deprecated
    public int getUses() {
        return this.uses;
    }

    @Override
    public String getMarketingMessage() {
        return DynamicTranslationProvider.getValue((Object)this, (String)"marketingMessage", (String)this.marketingMessage);
    }

    @Override
    public void setMarketingMessage(String marketingMessage) {
        this.marketingMessage = marketingMessage;
    }

    @Override
    @Deprecated
    public void setUses(int uses) {
        this.uses = uses;
    }

    @Override
    public Set<OfferItemCriteria> getQualifyingItemCriteria() {
        return this.qualifyingItemCriteria;
    }

    @Override
    public void setQualifyingItemCriteria(Set<OfferItemCriteria> qualifyingItemCriteria) {
        this.qualifyingItemCriteria = qualifyingItemCriteria;
    }

    @Override
    public Set<OfferItemCriteria> getTargetItemCriteria() {
        return this.targetItemCriteria;
    }

    @Override
    public void setTargetItemCriteria(Set<OfferItemCriteria> targetItemCriteria) {
        this.targetItemCriteria = targetItemCriteria;
    }

    @Override
    public Boolean isTotalitarianOffer() {
        if (this.totalitarianOffer == null) {
            return false;
        }
        return (boolean)this.totalitarianOffer;
    }

    @Override
    public void setTotalitarianOffer(Boolean totalitarianOffer) {
        this.totalitarianOffer = totalitarianOffer == null ? Boolean.valueOf(false) : totalitarianOffer;
    }

    @Override
    public Map<String, OfferRule> getOfferMatchRules() {
        if (this.offerMatchRules == null) {
            this.offerMatchRules = new HashMap<String, OfferRule>();
        }
        return this.offerMatchRules;
    }

    @Override
    public void setOfferMatchRules(Map<String, OfferRule> offerMatchRules) {
        this.offerMatchRules = offerMatchRules;
    }

    @Override
    public Boolean getTreatAsNewFormat() {
        return this.treatAsNewFormat;
    }

    @Override
    public void setTreatAsNewFormat(Boolean treatAsNewFormat) {
        this.treatAsNewFormat = treatAsNewFormat;
    }

    public Character getArchived() {
        if (this.archiveStatus == null) {
            this.archiveStatus = new ArchiveStatus();
        }
        return this.archiveStatus.getArchived();
    }

    public void setArchived(Character archived) {
        if (this.archiveStatus == null) {
            this.archiveStatus = new ArchiveStatus();
        }
        this.archiveStatus.setArchived(archived);
    }

    public boolean isActive() {
        return DateUtil.isActive((Date)this.startDate, (Date)this.endDate, (boolean)true) && 'Y' != this.getArchived().charValue();
    }

    @Override
    public Money getQualifyingItemSubTotal() {
        return this.qualifyingItemSubTotal == null ? null : BroadleafCurrencyUtils.getMoney((BigDecimal)this.qualifyingItemSubTotal, null);
    }

    @Override
    public void setQualifyingItemSubTotal(Money qualifyingItemSubTotal) {
        this.qualifyingItemSubTotal = Money.toAmount((Money)qualifyingItemSubTotal);
    }

    @Override
    public List<OfferCode> getOfferCodes() {
        return this.offerCodes;
    }

    @Override
    public void setOfferCodes(List<OfferCode> offerCodes) {
        this.offerCodes = offerCodes;
    }

    @Override
    public Boolean getRequiresRelatedTargetAndQualifiers() {
        return this.requiresRelatedTargetAndQualifiers == null ? false : this.requiresRelatedTargetAndQualifiers;
    }

    @Override
    public void setRequiresRelatedTargetAndQualifiers(Boolean requiresRelatedTargetAndQualifiers) {
        this.requiresRelatedTargetAndQualifiers = requiresRelatedTargetAndQualifiers;
    }

    public String getMainEntityName() {
        return this.getName();
    }

    public int hashCode() {
        return new HashCodeBuilder().append((Object)this.name).append((Object)this.startDate).append((Object)this.type).append((Object)this.value).build();
    }

    public boolean equals(Object o) {
        if (o instanceof OfferImpl) {
            OfferImpl that = (OfferImpl)o;
            return new EqualsBuilder().append((Object)this.id, (Object)that.id).append((Object)this.name, (Object)that.name).append((Object)this.startDate, (Object)that.startDate).append((Object)this.type, (Object)that.type).append((Object)this.value, (Object)that.value).build();
        }
        return false;
    }

    public static class Presentation {

        public static class Group {

            public static class Order {
                public static final int Description = 1000;
                public static final int Amount = 2000;
                public static final int ActivityRange = 3000;
                public static final int Qualifiers = 4000;
                public static final int ItemTarget = 5000;
                public static final int Advanced = 1000;
            }

            public static class Name {
                public static final String Description = "OfferImpl_Description";
                public static final String Amount = "OfferImpl_Amount";
                public static final String ActivityRange = "OfferImpl_Activity_Range";
                public static final String Qualifiers = "OfferImpl_Qualifiers";
                public static final String ItemTarget = "OfferImpl_Item_Target";
                public static final String Advanced = "OfferImpl_Advanced";
            }
        }

        public static class Tab {

            public static class Order {
                public static final int Codes = 1000;
                public static final int Advanced = 2000;
            }

            public static class Name {
                public static final String Codes = "OfferImpl_Codes_Tab";
                public static final String Advanced = "OfferImpl_Advanced_Tab";
            }
        }
    }
}

