/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.core.catalog.service;

import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.broadleafcommerce.common.file.service.BroadleafFileUtils;
import org.broadleafcommerce.common.sitemap.domain.SiteMapGeneratorConfiguration;
import org.broadleafcommerce.common.sitemap.service.SiteMapBuilder;
import org.broadleafcommerce.common.sitemap.service.SiteMapGenerator;
import org.broadleafcommerce.common.sitemap.service.type.SiteMapGeneratorType;
import org.broadleafcommerce.common.sitemap.wrapper.SiteMapURLWrapper;
import org.broadleafcommerce.core.catalog.dao.ProductDao;
import org.broadleafcommerce.core.catalog.domain.Product;
import org.hibernate.tool.hbm2x.StringUtils;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component(value="blProductSiteMapGenerator")
public class ProductSiteMapGenerator
implements SiteMapGenerator {
    @Resource(name="blProductDao")
    protected ProductDao productDao;
    @Value(value="${product.site.map.generator.row.limit}")
    protected int pageSize;

    public boolean canHandleSiteMapConfiguration(SiteMapGeneratorConfiguration siteMapGeneratorConfiguration) {
        return SiteMapGeneratorType.PRODUCT.equals((Object)siteMapGeneratorConfiguration.getSiteMapGeneratorType());
    }

    public void addSiteMapEntries(SiteMapGeneratorConfiguration smgc, SiteMapBuilder siteMapBuilder) {
        List<Product> products;
        int pageNum = 0;
        do {
            products = this.productDao.readAllActiveProducts(pageNum++, this.pageSize);
            for (Product product : products) {
                if (StringUtils.isEmpty((String)product.getUrl())) continue;
                SiteMapURLWrapper siteMapUrl = new SiteMapURLWrapper();
                siteMapUrl.setLoc(this.generateUri(siteMapBuilder, product));
                siteMapUrl.setChangeFreqType(smgc.getSiteMapChangeFreq());
                siteMapUrl.setPriorityType(smgc.getSiteMapPriority());
                siteMapUrl.setLastModDate(this.generateDate(product));
                siteMapBuilder.addUrl(siteMapUrl);
            }
        } while (products.size() == this.pageSize);
    }

    protected String generateUri(SiteMapBuilder smb, Product product) {
        return BroadleafFileUtils.buildFilePath((String)smb.getBaseUrl(), (String)product.getUrl());
    }

    protected Date generateDate(Product product) {
        return new Date();
    }

    public ProductDao getProductDao() {
        return this.productDao;
    }

    public void setProductDao(ProductDao productDao) {
        this.productDao = productDao;
    }

    public int getPageSize() {
        return this.pageSize;
    }

    public void setPageSize(int pageSize) {
        this.pageSize = pageSize;
    }
}

