/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.core.search.service.solr;

import java.lang.reflect.InvocationTargetException;
import java.util.List;
import java.util.Map;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import org.apache.commons.beanutils.PropertyUtils;
import org.broadleafcommerce.common.i18n.service.TranslationConsiderationContext;
import org.broadleafcommerce.common.i18n.service.TranslationService;
import org.broadleafcommerce.common.locale.domain.Locale;
import org.broadleafcommerce.common.web.BroadleafRequestContext;
import org.broadleafcommerce.core.catalog.domain.Product;
import org.broadleafcommerce.core.extension.ExtensionResultStatusType;
import org.broadleafcommerce.core.search.domain.Field;
import org.broadleafcommerce.core.search.domain.solr.FieldType;
import org.broadleafcommerce.core.search.service.solr.AbstractSolrSearchServiceExtensionHandler;
import org.broadleafcommerce.core.search.service.solr.SolrHelperService;
import org.broadleafcommerce.core.search.service.solr.SolrIndexServiceImpl;
import org.broadleafcommerce.core.search.service.solr.SolrSearchServiceExtensionHandler;
import org.broadleafcommerce.core.search.service.solr.SolrSearchServiceExtensionManager;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service(value="blI18nSolrSearchServiceExtensionHandler")
public class I18nSolrSearchServiceExtensionHandler
extends AbstractSolrSearchServiceExtensionHandler
implements SolrSearchServiceExtensionHandler {
    @Resource(name="blSolrHelperService")
    protected SolrHelperService shs;
    @Resource(name="blSolrSearchServiceExtensionManager")
    protected SolrSearchServiceExtensionManager extensionManager;
    @Resource(name="blTranslationService")
    protected TranslationService translationService;
    @Value(value="${i18n.translation.enabled}")
    protected boolean translationEnabled = false;
    private static String ATTR_MAP = SolrIndexServiceImpl.ATTR_MAP;

    @PostConstruct
    public void init() {
        this.extensionManager.getHandlers().add(this);
    }

    @Override
    public ExtensionResultStatusType buildPrefixListForSearchableFacet(Field field, List<String> prefixList) {
        return this.getLocalePrefix(field, prefixList);
    }

    @Override
    public ExtensionResultStatusType buildPrefixListForSearchableField(Field field, FieldType searchableFieldType, List<String> prefixList) {
        return this.getLocalePrefix(field, prefixList);
    }

    @Override
    public ExtensionResultStatusType addPropertyValues(Product product, Field field, FieldType fieldType, Map<String, Object> values, String propertyName, List<Locale> locales) throws NoSuchMethodException, InvocationTargetException, IllegalAccessException {
        ExtensionResultStatusType result = ExtensionResultStatusType.NOT_HANDLED;
        if (field.getTranslatable().booleanValue()) {
            result = ExtensionResultStatusType.HANDLED;
            for (Locale locale : locales) {
                String localeCode = locale.getLocaleCode();
                TranslationConsiderationContext.setTranslationConsiderationContext((Boolean)this.translationEnabled);
                TranslationConsiderationContext.setTranslationService((TranslationService)this.translationService);
                BroadleafRequestContext tempContext = BroadleafRequestContext.getBroadleafRequestContext();
                if (tempContext == null) {
                    tempContext = new BroadleafRequestContext();
                }
                tempContext.setLocale(locale);
                BroadleafRequestContext.setBroadleafRequestContext((BroadleafRequestContext)tempContext);
                Object propertyValue = propertyName.contains(ATTR_MAP) ? PropertyUtils.getMappedProperty((Object)product, (String)ATTR_MAP, (String)propertyName.substring(ATTR_MAP.length() + 1)) : PropertyUtils.getProperty((Object)product, (String)propertyName);
                values.put(localeCode, propertyValue);
            }
        }
        return result;
    }

    protected ExtensionResultStatusType getLocalePrefix(Field field, List<String> prefixList) {
        Locale locale;
        if (field.getTranslatable().booleanValue() && BroadleafRequestContext.getBroadleafRequestContext() != null && (locale = BroadleafRequestContext.getBroadleafRequestContext().getLocale()) != null) {
            prefixList.add(locale.getLocaleCode());
            return ExtensionResultStatusType.HANDLED_CONTINUE;
        }
        return ExtensionResultStatusType.NOT_HANDLED;
    }

    @Override
    public int getPriority() {
        return 1000;
    }
}

