/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.core.offer.service.discount.domain;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.broadleafcommerce.common.currency.domain.BroadleafCurrency;
import org.broadleafcommerce.common.money.Money;
import org.broadleafcommerce.core.offer.domain.Offer;
import org.broadleafcommerce.core.offer.domain.OfferItemCriteria;
import org.broadleafcommerce.core.offer.service.discount.domain.AbstractPromotionRounding;
import org.broadleafcommerce.core.offer.service.discount.domain.OfferHolder;
import org.broadleafcommerce.core.offer.service.discount.domain.PromotableCandidateItemOffer;
import org.broadleafcommerce.core.offer.service.discount.domain.PromotableOfferUtility;
import org.broadleafcommerce.core.offer.service.discount.domain.PromotableOrder;
import org.broadleafcommerce.core.offer.service.discount.domain.PromotableOrderItem;

public class PromotableCandidateItemOfferImpl
extends AbstractPromotionRounding
implements PromotableCandidateItemOffer,
OfferHolder {
    private static final long serialVersionUID = 1L;
    protected Offer offer;
    protected PromotableOrder promotableOrder;
    protected Money potentialSavings;
    protected int uses = 0;
    protected HashMap<OfferItemCriteria, List<PromotableOrderItem>> candidateQualifiersMap = new HashMap();
    protected List<PromotableOrderItem> candidateTargets = new ArrayList<PromotableOrderItem>();

    public PromotableCandidateItemOfferImpl(PromotableOrder promotableOrder, Offer offer) {
        assert (offer != null);
        assert (promotableOrder != null);
        this.offer = offer;
        this.promotableOrder = promotableOrder;
    }

    public Money calculatePotentialSavings() {
        Money savings = new Money(0.0);
        int maxUses = this.calculateMaximumNumberOfUses();
        int appliedCount = 0;
        for (PromotableOrderItem chgItem : this.candidateTargets) {
            int qtyToReceiveSavings = Math.min(chgItem.getQuantity(), maxUses);
            savings = savings.add(this.calculateSavingsForOrderItem(chgItem, qtyToReceiveSavings));
            if ((appliedCount += qtyToReceiveSavings) < maxUses) continue;
            return savings;
        }
        return savings;
    }

    @Override
    public BroadleafCurrency getCurrency() {
        return this.promotableOrder.getOrderCurrency();
    }

    @Override
    public Money calculateSavingsForOrderItem(PromotableOrderItem orderItem, int qtyToReceiveSavings) {
        Money savings = new Money(this.promotableOrder.getOrderCurrency());
        Money price = orderItem.getPriceBeforeAdjustments(this.getOffer().getApplyDiscountToSalePrice());
        BigDecimal offerUnitValue = PromotableOfferUtility.determineOfferUnitValue(this.offer, this);
        savings = PromotableOfferUtility.computeAdjustmentValue(price, offerUnitValue, this, this);
        return savings.multiply(qtyToReceiveSavings);
    }

    @Override
    public int calculateTargetQuantityForTieredOffer() {
        int returnQty = 0;
        for (PromotableOrderItem promotableOrderItem : this.candidateTargets) {
            returnQty += promotableOrderItem.getQuantity();
        }
        return returnQty;
    }

    @Override
    public Money getPotentialSavings() {
        if (this.potentialSavings == null) {
            return new Money(this.promotableOrder.getOrderCurrency());
        }
        return this.potentialSavings;
    }

    @Override
    public void setPotentialSavings(Money potentialSavings) {
        this.potentialSavings = potentialSavings;
    }

    @Override
    public boolean hasQualifyingItemCriteria() {
        return this.offer.getQualifyingItemCriteria() != null && !this.offer.getQualifyingItemCriteria().isEmpty();
    }

    @Override
    public int calculateMaximumNumberOfUses() {
        int maxMatchesFound;
        int numberOfUsesForThisItemCriteria = maxMatchesFound = 9999;
        for (OfferItemCriteria targetCriteria : this.getOffer().getTargetItemCriteria()) {
            int temp = this.calculateMaxUsesForItemCriteria(targetCriteria, this.getOffer());
            numberOfUsesForThisItemCriteria = Math.min(numberOfUsesForThisItemCriteria, temp);
        }
        maxMatchesFound = Math.min(maxMatchesFound, numberOfUsesForThisItemCriteria);
        int offerMaxUses = this.getOffer().getMaxUses() == 0 ? maxMatchesFound : this.getOffer().getMaxUses();
        return Math.min(maxMatchesFound, offerMaxUses);
    }

    @Override
    public int calculateMaxUsesForItemCriteria(OfferItemCriteria itemCriteria, Offer promotion) {
        int numberOfTargets = 0;
        int numberOfUsesForThisItemCriteria = 9999;
        if (itemCriteria != null) {
            for (PromotableOrderItem potentialTarget : this.candidateTargets) {
                numberOfTargets += potentialTarget.getQuantity();
            }
            numberOfUsesForThisItemCriteria = numberOfTargets / itemCriteria.getQuantity();
        }
        return numberOfUsesForThisItemCriteria;
    }

    @Override
    public HashMap<OfferItemCriteria, List<PromotableOrderItem>> getCandidateQualifiersMap() {
        return this.candidateQualifiersMap;
    }

    @Override
    public void setCandidateQualifiersMap(HashMap<OfferItemCriteria, List<PromotableOrderItem>> candidateItemsMap) {
        this.candidateQualifiersMap = candidateItemsMap;
    }

    @Override
    public List<PromotableOrderItem> getCandidateTargets() {
        return this.candidateTargets;
    }

    @Override
    public void setCandidateTargets(List<PromotableOrderItem> candidateTargets) {
        this.candidateTargets = candidateTargets;
    }

    @Override
    public int getPriority() {
        return this.offer.getPriority();
    }

    @Override
    public Offer getOffer() {
        return this.offer;
    }

    @Override
    public int getUses() {
        return this.uses;
    }

    @Override
    public void addUse() {
        ++this.uses;
    }

    @Override
    public boolean isLegacyOffer() {
        return this.offer.getQualifyingItemCriteria().isEmpty() && this.offer.getTargetItemCriteria().isEmpty();
    }
}

