/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.core.extension;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.beanutils.BeanComparator;
import org.broadleafcommerce.core.extension.ExtensionHandler;
import org.broadleafcommerce.core.extension.ExtensionResultStatusType;

public abstract class ExtensionManager<T extends ExtensionHandler>
implements InvocationHandler {
    protected boolean handlersSorted = false;
    protected static String LOCK_OBJECT = new String("EM_LOCK");
    protected T extensionHandler;
    protected List<T> handlers = new ArrayList<T>();

    public ExtensionManager(Class<T> _clazz) {
        this.extensionHandler = (ExtensionHandler)Proxy.newProxyInstance(_clazz.getClassLoader(), new Class[]{_clazz}, (InvocationHandler)this);
    }

    public T getProxy() {
        return this.extensionHandler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<T> getHandlers() {
        if (!this.handlersSorted) {
            String string = LOCK_OBJECT;
            synchronized (string) {
                if (!this.handlersSorted) {
                    BeanComparator fieldCompare = new BeanComparator("priority");
                    Collections.sort(this.handlers, fieldCompare);
                    this.handlersSorted = true;
                }
            }
        }
        return this.handlers;
    }

    public void setHandlers(List<T> handlers) {
        this.handlers = handlers;
    }

    public boolean shouldContinue(ExtensionResultStatusType result, ExtensionHandler handler, Method method, Object[] args) {
        if (result != null) {
            if (ExtensionResultStatusType.HANDLED_STOP.equals((Object)result)) {
                return false;
            }
            if (ExtensionResultStatusType.HANDLED.equals((Object)result) && !this.continueOnHandled()) {
                return false;
            }
        }
        return true;
    }

    public boolean continueOnHandled() {
        return false;
    }

    public int getPriority() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        boolean notHandled = true;
        for (ExtensionHandler handler : this.getHandlers()) {
            ExtensionResultStatusType result = (ExtensionResultStatusType)((Object)method.invoke((Object)handler, args));
            if (!ExtensionResultStatusType.NOT_HANDLED.equals((Object)result)) {
                notHandled = false;
            }
            if (this.shouldContinue(result, handler, method, args)) continue;
            break;
        }
        if (notHandled) {
            return ExtensionResultStatusType.NOT_HANDLED;
        }
        return null;
    }
}

