/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.core.offer.service.discount.domain;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.broadleafcommerce.common.money.Money;
import org.broadleafcommerce.core.offer.domain.Offer;
import org.broadleafcommerce.core.offer.domain.OfferItemCriteria;
import org.broadleafcommerce.core.offer.service.discount.PromotionDiscount;
import org.broadleafcommerce.core.offer.service.discount.PromotionQualifier;
import org.broadleafcommerce.core.offer.service.discount.domain.PromotableCandidateItemOffer;
import org.broadleafcommerce.core.offer.service.discount.domain.PromotableOrderItem;
import org.broadleafcommerce.core.offer.service.discount.domain.PromotableOrderItemPriceDetail;
import org.broadleafcommerce.core.offer.service.discount.domain.PromotableOrderItemPriceDetailAdjustment;
import org.broadleafcommerce.core.offer.service.type.OfferItemRestrictionRuleType;

public class PromotableOrderItemPriceDetailImpl
implements PromotableOrderItemPriceDetail {
    protected PromotableOrderItem promotableOrderItem;
    protected List<PromotableOrderItemPriceDetailAdjustment> promotableOrderItemPriceDetailAdjustments = new ArrayList<PromotableOrderItemPriceDetailAdjustment>();
    protected List<PromotionDiscount> promotionDiscounts = new ArrayList<PromotionDiscount>();
    protected List<PromotionQualifier> promotionQualifiers = new ArrayList<PromotionQualifier>();
    protected int quantity;
    protected boolean useSaleAdjustments = false;
    protected boolean adjustmentsFinalized = false;
    protected Money adjustedTotal;

    public PromotableOrderItemPriceDetailImpl(PromotableOrderItem promotableOrderItem, int quantity) {
        this.promotableOrderItem = promotableOrderItem;
        this.quantity = quantity;
    }

    @Override
    public boolean isAdjustmentsFinalized() {
        return this.adjustmentsFinalized;
    }

    @Override
    public void setAdjustmentsFinalized(boolean adjustmentsFinalized) {
        this.adjustmentsFinalized = adjustmentsFinalized;
    }

    @Override
    public void addCandidateItemPriceDetailAdjustment(PromotableOrderItemPriceDetailAdjustment itemAdjustment) {
        this.promotableOrderItemPriceDetailAdjustments.add(itemAdjustment);
    }

    @Override
    public List<PromotableOrderItemPriceDetailAdjustment> getCandidateItemAdjustments() {
        return Collections.unmodifiableList(this.promotableOrderItemPriceDetailAdjustments);
    }

    @Override
    public boolean hasNonCombinableAdjustments() {
        for (PromotableOrderItemPriceDetailAdjustment adjustment : this.promotableOrderItemPriceDetailAdjustments) {
            if (adjustment.isCombinable()) continue;
            return true;
        }
        return false;
    }

    protected boolean hasOrderItemAdjustments() {
        return this.promotableOrderItemPriceDetailAdjustments.size() > 0;
    }

    @Override
    public boolean isTotalitarianOfferApplied() {
        for (PromotableOrderItemPriceDetailAdjustment adjustment : this.promotableOrderItemPriceDetailAdjustments) {
            if (!adjustment.isTotalitarian()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isNonCombinableOfferApplied() {
        for (PromotableOrderItemPriceDetailAdjustment adjustment : this.promotableOrderItemPriceDetailAdjustments) {
            if (adjustment.isCombinable()) continue;
            return true;
        }
        return false;
    }

    public Money calculateSaleAdjustmentUnitPrice() {
        Money returnPrice = this.promotableOrderItem.getSalePriceBeforeAdjustments();
        if (returnPrice == null) {
            returnPrice = this.promotableOrderItem.getRetailPriceBeforeAdjustments();
        }
        for (PromotableOrderItemPriceDetailAdjustment adjustment : this.promotableOrderItemPriceDetailAdjustments) {
            returnPrice = returnPrice.subtract(adjustment.getSaleAdjustmentValue());
        }
        return returnPrice;
    }

    public Money calculateRetailAdjustmentUnitPrice() {
        Money returnPrice = this.promotableOrderItem.getRetailPriceBeforeAdjustments();
        for (PromotableOrderItemPriceDetailAdjustment adjustment : this.promotableOrderItemPriceDetailAdjustments) {
            returnPrice = returnPrice.subtract(adjustment.getRetailAdjustmentValue());
        }
        return returnPrice;
    }

    @Override
    public void chooseSaleOrRetailAdjustments() {
        this.adjustmentsFinalized = true;
        this.adjustedTotal = null;
        this.useSaleAdjustments = Boolean.FALSE;
        Money salePriceBeforeAdjustments = this.promotableOrderItem.getSalePriceBeforeAdjustments();
        Money retailPriceBeforeAdjustments = this.promotableOrderItem.getRetailPriceBeforeAdjustments();
        if (this.hasOrderItemAdjustments()) {
            Money saleAdjustmentPrice = this.calculateSaleAdjustmentUnitPrice();
            Money retailAdjustmentPrice = this.calculateRetailAdjustmentUnitPrice();
            if (this.promotableOrderItem.isOnSale()) {
                if (saleAdjustmentPrice.lessThanOrEqual(retailAdjustmentPrice)) {
                    this.useSaleAdjustments = Boolean.TRUE;
                    this.adjustedTotal = saleAdjustmentPrice;
                } else {
                    this.adjustedTotal = retailAdjustmentPrice;
                }
                if (!this.adjustedTotal.lessThan(salePriceBeforeAdjustments)) {
                    this.promotableOrderItemPriceDetailAdjustments.clear();
                    this.adjustedTotal = salePriceBeforeAdjustments;
                }
            } else if (!retailAdjustmentPrice.lessThan(this.promotableOrderItem.getRetailPriceBeforeAdjustments())) {
                this.promotableOrderItemPriceDetailAdjustments.clear();
                this.adjustedTotal = retailPriceBeforeAdjustments;
            } else {
                this.adjustedTotal = retailAdjustmentPrice;
            }
            if (this.useSaleAdjustments) {
                this.removeRetailOnlyAdjustments();
            }
            this.removeZeroDollarAdjustments(this.useSaleAdjustments);
            this.finalizeAdjustments(this.useSaleAdjustments);
        }
        if (this.adjustedTotal == null) {
            if (salePriceBeforeAdjustments != null) {
                this.useSaleAdjustments = true;
                this.adjustedTotal = salePriceBeforeAdjustments;
            } else {
                this.adjustedTotal = retailPriceBeforeAdjustments;
            }
        }
        this.adjustedTotal = this.adjustedTotal.multiply(this.quantity);
    }

    @Override
    public void removeAllAdjustments() {
        this.promotableOrderItemPriceDetailAdjustments.clear();
        this.chooseSaleOrRetailAdjustments();
    }

    protected void finalizeAdjustments(boolean useSaleAdjustments) {
        for (PromotableOrderItemPriceDetailAdjustment adjustment : this.promotableOrderItemPriceDetailAdjustments) {
            adjustment.finalizeAdjustment(useSaleAdjustments);
        }
    }

    protected void removeRetailOnlyAdjustments() {
        Iterator<PromotableOrderItemPriceDetailAdjustment> adjustments = this.promotableOrderItemPriceDetailAdjustments.iterator();
        while (adjustments.hasNext()) {
            PromotableOrderItemPriceDetailAdjustment adjustment = adjustments.next();
            if (adjustment.getOffer().getApplyDiscountToSalePrice()) continue;
            adjustments.remove();
        }
    }

    protected void removeZeroDollarAdjustments(boolean useSalePrice) {
        Iterator<PromotableOrderItemPriceDetailAdjustment> adjustments = this.promotableOrderItemPriceDetailAdjustments.iterator();
        while (adjustments.hasNext()) {
            PromotableOrderItemPriceDetailAdjustment adjustment = adjustments.next();
            if (useSalePrice) {
                if (!adjustment.getSaleAdjustmentValue().isZero()) continue;
                adjustments.remove();
                continue;
            }
            if (!adjustment.getRetailAdjustmentValue().isZero()) continue;
            adjustments.remove();
        }
    }

    @Override
    public PromotableOrderItem getPromotableOrderItem() {
        return this.promotableOrderItem;
    }

    @Override
    public List<PromotionDiscount> getPromotionDiscounts() {
        return this.promotionDiscounts;
    }

    @Override
    public List<PromotionQualifier> getPromotionQualifiers() {
        return this.promotionQualifiers;
    }

    @Override
    public int getQuantity() {
        return this.quantity;
    }

    @Override
    public void setQuantity(int quantity) {
        this.quantity = quantity;
    }

    private boolean restrictTarget(Offer offer, boolean targetType) {
        OfferItemRestrictionRuleType qualifierType = targetType ? offer.getOfferItemTargetRuleType() : offer.getOfferItemQualifierRuleType();
        return OfferItemRestrictionRuleType.NONE.equals(qualifierType) || OfferItemRestrictionRuleType.QUALIFIER.equals(qualifierType);
    }

    private boolean restrictQualifier(Offer offer, boolean targetType) {
        OfferItemRestrictionRuleType qualifierType = targetType ? offer.getOfferItemTargetRuleType() : offer.getOfferItemQualifierRuleType();
        return OfferItemRestrictionRuleType.NONE.equals(qualifierType) || OfferItemRestrictionRuleType.TARGET.equals(qualifierType);
    }

    @Override
    public int getQuantityAvailableToBeUsedAsTarget(PromotableCandidateItemOffer itemOffer) {
        int qtyAvailable = this.quantity;
        Offer promotion = itemOffer.getOffer();
        boolean combinable = promotion.isCombinableWithOtherOffers();
        if (!combinable && this.isNonCombinableOfferApplied()) {
            return 0;
        }
        for (PromotionDiscount promotionDiscount : this.promotionDiscounts) {
            if (promotionDiscount.getPromotion().equals(promotion) || this.restrictTarget(promotion, true)) {
                qtyAvailable -= promotionDiscount.getQuantity();
                continue;
            }
            if (!this.restrictTarget(promotionDiscount.getPromotion(), true)) continue;
            qtyAvailable -= promotionDiscount.getQuantity();
        }
        for (PromotionQualifier promotionQualifier : this.promotionQualifiers) {
            if (promotionQualifier.getPromotion().equals(promotion) || this.restrictQualifier(promotion, true)) {
                qtyAvailable -= promotionQualifier.getQuantity();
                continue;
            }
            if (!this.restrictTarget(promotionQualifier.getPromotion(), false)) continue;
            qtyAvailable -= promotionQualifier.getQuantity();
        }
        return qtyAvailable;
    }

    public PromotionQualifier lookupOrCreatePromotionQualifier(PromotableCandidateItemOffer candidatePromotion) {
        Offer promotion = candidatePromotion.getOffer();
        for (PromotionQualifier pq : this.promotionQualifiers) {
            if (!pq.getPromotion().equals(promotion)) continue;
            return pq;
        }
        PromotionQualifier pq = new PromotionQualifier();
        pq.setPromotion(promotion);
        this.promotionQualifiers.add(pq);
        return pq;
    }

    public PromotionDiscount lookupOrCreatePromotionDiscount(PromotableCandidateItemOffer candidatePromotion) {
        Offer promotion = candidatePromotion.getOffer();
        for (PromotionDiscount pd : this.promotionDiscounts) {
            if (!pd.getPromotion().equals(promotion)) continue;
            return pd;
        }
        PromotionDiscount pd = new PromotionDiscount();
        pd.setPromotion(promotion);
        this.promotionDiscounts.add(pd);
        return pd;
    }

    @Override
    public void addPromotionQualifier(PromotableCandidateItemOffer itemOffer, OfferItemCriteria itemCriteria, int qtyToMarkAsQualifier) {
        PromotionQualifier pq = this.lookupOrCreatePromotionQualifier(itemOffer);
        pq.incrementQuantity(qtyToMarkAsQualifier);
        pq.setItemCriteria(itemCriteria);
    }

    @Override
    public void addPromotionDiscount(PromotableCandidateItemOffer itemOffer, OfferItemCriteria itemCriteria, int qtyToMarkAsTarget) {
        PromotionDiscount pd = this.lookupOrCreatePromotionDiscount(itemOffer);
        if (pd == null) {
            return;
        }
        pd.incrementQuantity(qtyToMarkAsTarget);
        pd.setItemCriteria(itemCriteria);
        pd.setCandidateItemOffer(itemOffer);
    }

    @Override
    public void finalizeQuantities() {
        for (PromotionDiscount promotionDiscount : this.promotionDiscounts) {
            promotionDiscount.setFinalizedQuantity(promotionDiscount.getQuantity());
        }
        for (PromotionQualifier promotionQualifier : this.promotionQualifiers) {
            promotionQualifier.setFinalizedQuantity(promotionQualifier.getQuantity());
        }
    }

    @Override
    public void clearAllNonFinalizedQuantities() {
        Iterator<PromotionQualifier> promotionQualifierIterator = this.promotionQualifiers.iterator();
        while (promotionQualifierIterator.hasNext()) {
            PromotionQualifier promotionQualifier = promotionQualifierIterator.next();
            if (promotionQualifier.getFinalizedQuantity() == 0) {
                promotionQualifierIterator.remove();
                continue;
            }
            promotionQualifier.setQuantity(promotionQualifier.getFinalizedQuantity());
        }
        Iterator<PromotionDiscount> promotionDiscountIterator = this.promotionDiscounts.iterator();
        while (promotionDiscountIterator.hasNext()) {
            PromotionDiscount promotionDiscount = promotionDiscountIterator.next();
            if (promotionDiscount.getFinalizedQuantity() == 0) {
                promotionDiscountIterator.remove();
                continue;
            }
            promotionDiscount.setQuantity(promotionDiscount.getFinalizedQuantity());
        }
    }

    @Override
    public int getQuantityAvailableToBeUsedAsQualifier(PromotableCandidateItemOffer itemOffer) {
        int qtyAvailable = this.quantity;
        Offer promotion = itemOffer.getOffer();
        for (PromotionDiscount promotionDiscount : this.promotionDiscounts) {
            if (promotionDiscount.getPromotion().equals(promotion) || this.restrictTarget(promotion, false)) {
                qtyAvailable -= promotionDiscount.getQuantity();
                continue;
            }
            if (!this.restrictQualifier(promotionDiscount.getPromotion(), true)) continue;
            qtyAvailable -= promotionDiscount.getQuantity();
        }
        for (PromotionQualifier promotionQualifier : this.promotionQualifiers) {
            if (promotionQualifier.getPromotion().equals(promotion) || this.restrictQualifier(promotion, false)) {
                qtyAvailable -= promotionQualifier.getQuantity();
                continue;
            }
            if (!this.restrictQualifier(promotionQualifier.getPromotion(), false)) continue;
            qtyAvailable -= promotionQualifier.getQuantity();
        }
        return qtyAvailable;
    }

    @Override
    public Money calculateItemUnitPriceWithAdjustments(boolean allowSalePrice) {
        Money priceWithAdjustments = null;
        if (allowSalePrice) {
            priceWithAdjustments = this.promotableOrderItem.getSalePriceBeforeAdjustments();
            if (priceWithAdjustments == null) {
                return this.promotableOrderItem.getRetailPriceBeforeAdjustments();
            }
        } else {
            priceWithAdjustments = this.promotableOrderItem.getRetailPriceBeforeAdjustments();
        }
        for (PromotableOrderItemPriceDetailAdjustment adjustment : this.promotableOrderItemPriceDetailAdjustments) {
            if (allowSalePrice) {
                priceWithAdjustments = priceWithAdjustments.subtract(adjustment.getSaleAdjustmentValue());
                continue;
            }
            priceWithAdjustments = priceWithAdjustments.subtract(adjustment.getRetailAdjustmentValue());
        }
        return priceWithAdjustments;
    }

    protected Money calculateAdjustmentsUnitValue() {
        Money adjustmentUnitValue = new Money(this.promotableOrderItem.getCurrency());
        for (PromotableOrderItemPriceDetailAdjustment adjustment : this.promotableOrderItemPriceDetailAdjustments) {
            adjustmentUnitValue = adjustmentUnitValue.add(adjustment.getAdjustmentValue());
        }
        return adjustmentUnitValue;
    }

    @Override
    public String buildDetailKey() {
        ArrayList<Long> offerIds = new ArrayList<Long>();
        for (PromotableOrderItemPriceDetailAdjustment adjustment : this.promotableOrderItemPriceDetailAdjustments) {
            Long offerId = adjustment.getOffer().getId();
            offerIds.add(offerId);
        }
        Collections.sort(offerIds);
        return this.promotableOrderItem.getOrderItem().toString() + ((Object)offerIds).toString() + this.useSaleAdjustments;
    }

    @Override
    public Money getFinalizedTotalWithAdjustments() {
        this.chooseSaleOrRetailAdjustments();
        return this.adjustedTotal;
    }

    @Override
    public Money calculateTotalAdjustmentValue() {
        return this.calculateAdjustmentsUnitValue().multiply(this.quantity);
    }

    protected PromotableOrderItemPriceDetail split(int discountQty, Long offerId, boolean hasQualifiers) {
        int originalQty = this.quantity;
        this.quantity = discountQty;
        int splitItemQty = originalQty - discountQty;
        PromotableOrderItemPriceDetail newDetail = this.promotableOrderItem.createNewDetail(splitItemQty);
        for (PromotionDiscount existingDiscount : this.promotionDiscounts) {
            PromotionDiscount newDiscount = existingDiscount.split(discountQty);
            if (newDiscount == null) continue;
            newDetail.getPromotionDiscounts().add(newDiscount);
        }
        if (hasQualifiers) {
            Iterator<PromotionQualifier> qualifiers = this.promotionQualifiers.iterator();
            while (qualifiers.hasNext()) {
                PromotionQualifier currentQualifier = qualifiers.next();
                Long qualifierOfferId = currentQualifier.getPromotion().getId();
                if (qualifierOfferId.equals(offerId) && currentQualifier.getQuantity() <= splitItemQty) {
                    qualifiers.remove();
                    newDetail.getPromotionQualifiers().add(currentQualifier);
                    continue;
                }
                PromotionQualifier newQualifier = currentQualifier.split(splitItemQty);
                newDetail.getPromotionQualifiers().add(newQualifier);
            }
        }
        for (PromotableOrderItemPriceDetailAdjustment existingAdjustment : this.promotableOrderItemPriceDetailAdjustments) {
            PromotableOrderItemPriceDetailAdjustment newAdjustment = existingAdjustment.copy();
            newDetail.addCandidateItemPriceDetailAdjustment(newAdjustment);
        }
        return newDetail;
    }

    @Override
    public PromotableOrderItemPriceDetail splitIfNecessary() {
        PromotableOrderItemPriceDetail returnDetail = null;
        for (PromotionDiscount discount : this.promotionDiscounts) {
            if (discount.getQuantity() == this.quantity) continue;
            Long offerId = discount.getCandidateItemOffer().getOffer().getId();
            return this.split(discount.getQuantity(), offerId, !CollectionUtils.isEmpty(discount.getCandidateItemOffer().getOffer().getQualifyingItemCriteria()));
        }
        return returnDetail;
    }

    @Override
    public boolean useSaleAdjustments() {
        return this.useSaleAdjustments;
    }
}

