/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.core.catalog.domain;

import javax.persistence.Column;
import javax.persistence.EmbeddedId;
import javax.persistence.Entity;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;
import javax.persistence.Table;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.broadleafcommerce.common.presentation.AdminPresentation;
import org.broadleafcommerce.common.presentation.AdminPresentationClass;
import org.broadleafcommerce.common.presentation.client.VisibilityEnum;
import org.broadleafcommerce.core.catalog.domain.Category;
import org.broadleafcommerce.core.catalog.domain.CategoryProductXref;
import org.broadleafcommerce.core.catalog.domain.CategoryProductXrefPK;
import org.broadleafcommerce.core.catalog.domain.Product;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.hibernate.annotations.Polymorphism;
import org.hibernate.annotations.PolymorphismType;

@Entity
@Polymorphism(type=PolymorphismType.EXPLICIT)
@Inheritance(strategy=InheritanceType.JOINED)
@Table(name="BLC_CATEGORY_PRODUCT_XREF")
@AdminPresentationClass(excludeFromPolymorphism=false)
@Cache(usage=CacheConcurrencyStrategy.READ_WRITE, region="blStandardElements")
public class CategoryProductXrefImpl
implements CategoryProductXref {
    private static final long serialVersionUID = 1L;
    @EmbeddedId
    CategoryProductXrefPK categoryProductXref = new CategoryProductXrefPK();
    @Column(name="DISPLAY_ORDER")
    @AdminPresentation(visibility=VisibilityEnum.HIDDEN_ALL)
    protected Long displayOrder;

    public CategoryProductXrefPK getCategoryProductXref() {
        return this.categoryProductXref;
    }

    public void setCategoryProductXref(CategoryProductXrefPK categoryProductXref) {
        this.categoryProductXref = categoryProductXref;
    }

    @Override
    public Long getDisplayOrder() {
        return this.displayOrder;
    }

    @Override
    public void setDisplayOrder(Long displayOrder) {
        this.displayOrder = displayOrder;
    }

    @Override
    public Category getCategory() {
        return this.categoryProductXref.getCategory();
    }

    @Override
    public void setCategory(Category category) {
        this.categoryProductXref.setCategory(category);
    }

    @Override
    public Product getProduct() {
        return this.categoryProductXref.getProduct();
    }

    @Override
    public void setProduct(Product product) {
        this.categoryProductXref.setProduct(product);
    }

    public boolean equals(Object o) {
        if (o instanceof CategoryProductXrefImpl) {
            CategoryProductXrefImpl that = (CategoryProductXrefImpl)o;
            return new EqualsBuilder().append((Object)this.categoryProductXref, (Object)that.categoryProductXref).build();
        }
        return false;
    }

    public int hashCode() {
        int result = this.categoryProductXref != null ? this.categoryProductXref.hashCode() : 0;
        return result;
    }
}

