/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.core.order.service.workflow.update;

import javax.annotation.Resource;
import org.broadleafcommerce.core.order.domain.FulfillmentGroup;
import org.broadleafcommerce.core.order.domain.FulfillmentGroupItem;
import org.broadleafcommerce.core.order.domain.OrderItem;
import org.broadleafcommerce.core.order.service.OrderItemService;
import org.broadleafcommerce.core.order.service.OrderMultishipOptionService;
import org.broadleafcommerce.core.order.service.workflow.CartOperationContext;
import org.broadleafcommerce.core.order.service.workflow.CartOperationRequest;
import org.broadleafcommerce.core.workflow.BaseActivity;
import org.springframework.util.CollectionUtils;

public class UpdateOrderMultishipOptionActivity
extends BaseActivity<CartOperationContext> {
    @Resource(name="blOrderMultishipOptionService")
    protected OrderMultishipOptionService orderMultishipOptionService;
    @Resource(name="blOrderItemService")
    protected OrderItemService orderItemService;

    @Override
    public CartOperationContext execute(CartOperationContext context) throws Exception {
        CartOperationRequest request = context.getSeedData();
        Long orderItemId = request.getItemRequest().getOrderItemId();
        Integer orderItemQuantityDelta = request.getOrderItemQuantityDelta();
        if (orderItemQuantityDelta < 0) {
            FulfillmentGroup fg;
            int numToDelete = -1 * orderItemQuantityDelta;
            OrderItem orderItem = this.orderItemService.readOrderItemById(orderItemId);
            int qty = 0;
            if (!CollectionUtils.isEmpty(orderItem.getOrder().getFulfillmentGroups()) && (fg = orderItem.getOrder().getFulfillmentGroups().get(0)).getAddress() == null && fg.getFulfillmentOption() == null) {
                for (FulfillmentGroupItem fgItem : fg.getFulfillmentGroupItems()) {
                    if (!fgItem.getOrderItem().getId().equals(orderItemId)) continue;
                    qty += fgItem.getQuantity();
                }
            }
            if (numToDelete >= qty) {
                this.orderMultishipOptionService.deleteOrderItemOrderMultishipOptions(orderItemId, numToDelete - qty);
            }
        }
        return context;
    }
}

