/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.core.search.dao;

import java.util.List;
import javax.annotation.Resource;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Path;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Selection;
import org.broadleafcommerce.common.persistence.EntityConfiguration;
import org.broadleafcommerce.core.catalog.domain.ProductImpl;
import org.broadleafcommerce.core.search.dao.SearchFacetDao;
import org.broadleafcommerce.core.search.domain.SearchFacet;
import org.broadleafcommerce.core.search.domain.SearchFacetImpl;
import org.springframework.stereotype.Repository;

@Repository(value="blSearchFacetDao")
public class SearchFacetDaoImpl
implements SearchFacetDao {
    @PersistenceContext(unitName="blPU")
    protected EntityManager em;
    @Resource(name="blEntityConfiguration")
    protected EntityConfiguration entityConfiguration;

    @Override
    public List<SearchFacet> readAllSearchFacets() {
        CriteriaBuilder builder = this.em.getCriteriaBuilder();
        CriteriaQuery criteria = builder.createQuery(SearchFacet.class);
        Root facet = criteria.from(SearchFacetImpl.class);
        criteria.select((Selection)facet);
        criteria.where((Expression)builder.equal(facet.get("showOnSearch").as(Boolean.class), (Object)true));
        return this.em.createQuery(criteria).getResultList();
    }

    @Override
    public <T> List<T> readDistinctValuesForField(String fieldName, Class<T> fieldValueClass) {
        Path pathToUse;
        CriteriaBuilder builder = this.em.getCriteriaBuilder();
        CriteriaQuery criteria = builder.createQuery(fieldValueClass);
        Root product = criteria.from(ProductImpl.class);
        Path sku = product.get("defaultSku");
        if (fieldName.contains("defaultSku.")) {
            pathToUse = sku;
            fieldName = fieldName.substring("defaultSku.".length());
        } else if (fieldName.contains("productAttributes.")) {
            pathToUse = product.join("productAttributes");
            fieldName = fieldName.substring("productAttributes.".length());
            criteria.where((Expression)builder.equal(builder.lower(pathToUse.get("name").as(String.class)), (Object)fieldName.toLowerCase()));
            fieldName = "value";
        } else if (fieldName.contains("product.")) {
            pathToUse = product;
            fieldName = fieldName.substring("product.".length());
        } else {
            throw new IllegalArgumentException("Invalid facet fieldName specified: " + fieldName);
        }
        criteria.where((Expression)pathToUse.get(fieldName).as(fieldValueClass).isNotNull());
        criteria.distinct(true).select((Selection)pathToUse.get(fieldName).as(fieldValueClass));
        return this.em.createQuery(criteria).getResultList();
    }

    @Override
    public SearchFacet save(SearchFacet searchFacet) {
        return (SearchFacet)this.em.merge((Object)searchFacet);
    }
}

