/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.core.payment.service.module;

import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.validator.CreditCardValidator;
import org.broadleafcommerce.common.money.Money;
import org.broadleafcommerce.core.payment.domain.CreditCardPaymentInfo;
import org.broadleafcommerce.core.payment.domain.PaymentResponseItem;
import org.broadleafcommerce.core.payment.service.PaymentContext;
import org.broadleafcommerce.core.payment.service.exception.PaymentException;
import org.broadleafcommerce.core.payment.service.module.AbstractModule;
import org.broadleafcommerce.core.payment.service.type.PaymentInfoAdditionalFieldType;
import org.broadleafcommerce.core.payment.service.type.PaymentInfoType;
import org.joda.time.DateTime;

public class NullCreditCardPaymentModule
extends AbstractModule {
    @Override
    public PaymentResponseItem processAuthorize(PaymentContext paymentContext, Money amountToAuthorize, PaymentResponseItem responseItem) throws PaymentException {
        Map<String, String> additionalFields = this.validateNullCreditCard(paymentContext);
        responseItem.setTransactionSuccess(additionalFields != null);
        if (!responseItem.getTransactionSuccess().booleanValue()) {
            throw new PaymentException("Problem processing Credit Card.");
        }
        this.findPaymentInfoFromContext(paymentContext).setAdditionalFields(additionalFields);
        return responseItem;
    }

    @Override
    public PaymentResponseItem processReverseAuthorize(PaymentContext paymentContext, Money amountToReverseAuthorize, PaymentResponseItem responseItem) throws PaymentException {
        Map<String, String> additionalFields = this.validateNullCreditCard(paymentContext);
        this.findPaymentInfoFromContext(paymentContext).setAdditionalFields(additionalFields);
        return responseItem;
    }

    @Override
    public PaymentResponseItem processAuthorizeAndDebit(PaymentContext paymentContext, Money amountToDebit, PaymentResponseItem responseItem) throws PaymentException {
        PaymentResponseItem authorizeResponseItem = this.authorize(paymentContext);
        if (authorizeResponseItem.getTransactionSuccess().booleanValue()) {
            return this.debit(paymentContext);
        }
        throw new PaymentException("Problem processing Credit Card.");
    }

    @Override
    public PaymentResponseItem processDebit(PaymentContext paymentContext, Money amountToDebit, PaymentResponseItem responseItem) throws PaymentException {
        responseItem.setTransactionSuccess(true);
        Map<String, String> additionalFields = this.validateNullCreditCard(paymentContext);
        this.findPaymentInfoFromContext(paymentContext).setAdditionalFields(additionalFields);
        return responseItem;
    }

    @Override
    public PaymentResponseItem processCredit(PaymentContext paymentContext, Money amountToCredit, PaymentResponseItem responseItem) throws PaymentException {
        responseItem.setTransactionSuccess(true);
        Map<String, String> additionalFields = this.validateNullCreditCard(paymentContext);
        this.findPaymentInfoFromContext(paymentContext).setAdditionalFields(additionalFields);
        return responseItem;
    }

    @Override
    public PaymentResponseItem processVoidPayment(PaymentContext paymentContext, Money amountToVoid, PaymentResponseItem responseItem) throws PaymentException {
        if (amountToVoid.greaterThan(Money.ZERO)) {
            return this.credit(paymentContext);
        }
        return this.reverseAuthorize(paymentContext);
    }

    @Override
    public PaymentResponseItem processBalance(PaymentContext paymentContext, PaymentResponseItem responseItem) throws PaymentException {
        throw new PaymentException("balance not implemented.");
    }

    @Override
    public PaymentResponseItem processPartialPayment(PaymentContext paymentContext, Money amountToDebit, PaymentResponseItem responseItem) throws PaymentException {
        throw new PaymentException("partial payment not implemented.");
    }

    @Override
    public Boolean isValidCandidate(PaymentInfoType paymentType) {
        return PaymentInfoType.CREDIT_CARD.equals(paymentType);
    }

    protected String validateCardType(String ccNumber) {
        CreditCardValidator visaValidator = new CreditCardValidator(2);
        CreditCardValidator amexValidator = new CreditCardValidator(1);
        CreditCardValidator mcValidator = new CreditCardValidator(4);
        CreditCardValidator discoverValidator = new CreditCardValidator(8);
        if (visaValidator.isValid(ccNumber)) {
            return "VISA";
        }
        if (amexValidator.isValid(ccNumber)) {
            return "AMEX";
        }
        if (mcValidator.isValid(ccNumber)) {
            return "MASTERCARD";
        }
        if (discoverValidator.isValid(ccNumber)) {
            return "DISCOVER";
        }
        return "UNKNOWN";
    }

    protected Map<String, String> validateNullCreditCard(PaymentContext paymentContext) {
        boolean validCVV;
        CreditCardPaymentInfo ccInfo = (CreditCardPaymentInfo)paymentContext.getReferencedPaymentInfo();
        if (ccInfo == null || ccInfo.getPan() == null) {
            return null;
        }
        String nameOnCard = ccInfo.getNameOnCard();
        String ccNumber = ccInfo.getPan().replaceAll("[\\s-]+", "");
        Integer expMonth = ccInfo.getExpirationMonth();
        Integer expYear = ccInfo.getExpirationYear();
        String cvv = ccInfo.getCvvCode();
        String cardType = this.validateCardType(ccNumber);
        boolean validCard = !cardType.contains("UNKNOWN");
        DateTime expirationDate = new DateTime(expYear.intValue(), expMonth.intValue(), 1, 0, 0);
        boolean validDate = expirationDate.isAfterNow();
        boolean bl = validCVV = !"000".equals(cvv);
        if (validDate && validCard && validCVV) {
            HashMap<String, String> additionalFields = new HashMap<String, String>();
            additionalFields.put(PaymentInfoAdditionalFieldType.NAME_ON_CARD.getType(), nameOnCard);
            additionalFields.put(PaymentInfoAdditionalFieldType.CARD_TYPE.getType(), cardType);
            additionalFields.put(PaymentInfoAdditionalFieldType.EXP_MONTH.getType(), expMonth + "");
            additionalFields.put(PaymentInfoAdditionalFieldType.EXP_YEAR.getType(), expYear + "");
            additionalFields.put(PaymentInfoAdditionalFieldType.LAST_FOUR.getType(), StringUtils.right((String)ccNumber, (int)4));
            return additionalFields;
        }
        return null;
    }
}

